/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.packaging;

import com.arsdigita.packaging.Command;
import com.arsdigita.packaging.ConfigRegistry;
import com.arsdigita.util.Files;
import com.arsdigita.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;

public class HostInit {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/packaging/HostInit.java#15 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$packaging$HostInit == null ? (class$com$arsdigita$packaging$HostInit = HostInit.class$("com.arsdigita.packaging.HostInit")) : class$com$arsdigita$packaging$HostInit));
    private static final Options OPTIONS = new Options();
    static /* synthetic */ Class class$com$arsdigita$packaging$HostInit;

    private static final void err(String msg) {
        System.err.println(msg);
        System.exit(1);
    }

    public static final void main(String[] args) {
        CommandLine line;
        if (args.length == 0) {
            Command.usage(OPTIONS, System.err, "com.arsdigita.packaging.HostInit", null);
            System.exit(1);
        }
        try {
            line = new PosixParser().parse(OPTIONS, args);
        }
        catch (ParseException e) {
            HostInit.err(e.getMessage());
            return;
        }
        String classpath = line.getOptionValue("classpath");
        String webapps = line.getOptionValue("webapps");
        String destination = line.getOptionValue("destination");
        boolean clean = line.hasOption("clean");
        File dest = new File(destination);
        File inf = new File(dest, "WEB-INF");
        File lib = new File(inf, "lib");
        File system = new File(inf, "system");
        if (!dest.exists()) {
            dest.mkdir();
            if (!dest.exists()) {
                HostInit.err("unable to create destination: " + dest);
            }
        }
        if (clean) {
            File[] contents = dest.listFiles();
            if (contents == null) {
                HostInit.err("unable to get directory listing: " + dest);
            }
            for (int i = 0; i < contents.length; ++i) {
                Files.delete(contents[i]);
            }
        }
        lib.mkdirs();
        if (!lib.exists() || !lib.isDirectory()) {
            HostInit.err("unable to create lib: " + lib);
        }
        system.mkdirs();
        if (!system.exists() || !system.isDirectory()) {
            HostInit.err("unable to create system: " + system);
        }
        ConfigRegistry reg = new ConfigRegistry();
        List packages = reg.getPackages();
        try {
            HostInit.copy(classpath, packages, lib);
            HostInit.copySystem(classpath, packages, system);
            HostInit.copy(webapps, packages, dest);
        }
        catch (IOException e) {
            HostInit.err(e.getMessage());
        }
    }

    private static void copy(String pathfile, List packages, File dest) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(pathfile));
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).startsWith("#") || line.equals("")) continue;
            if (HostInit.contains(line, packages)) {
                File file = new File(line);
                if (line.endsWith(File.separator)) {
                    HostInit.copyDirectory(file, dest);
                    continue;
                }
                if (file.isFile() && line.endsWith(".jar")) {
                    HostInit.copyJar(file, dest);
                    continue;
                }
                if (s_log.isInfoEnabled()) {
                    s_log.info((Object)("Copying " + file.toString()));
                }
                Files.copy(file, dest, 2);
                continue;
            }
            if (!s_log.isInfoEnabled()) continue;
            s_log.info((Object)("Entry found in file that does not correspond to an installed package: " + line));
        }
        reader.close();
    }

    private static void copySystem(String pathfile, List packages, File dest) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(pathfile));
        while ((line = reader.readLine()) != null) {
            String newline;
            File file;
            if (!HostInit.contains(line = line.trim(), packages) || !line.endsWith(".jar") || !(file = new File(newline = line.substring(0, line.lastIndexOf(".jar")) + "-system.jar")).isFile()) continue;
            if (s_log.isInfoEnabled()) {
                s_log.info((Object)("Copying System JAR " + file.toString()));
            }
            Files.copy(file, dest, 2);
        }
        reader.close();
    }

    private static void copyDirectory(File dir, File dest) throws IOException {
        File[] files;
        if (s_log.isInfoEnabled()) {
            s_log.info((Object)("Copying directory " + dir.toString()));
        }
        if (!dir.isDirectory()) {
            HostInit.err("directory does not exist: " + dir);
        }
        if ((files = dir.listFiles()) == null) {
            HostInit.err("unable to get directory listing: " + dir);
        }
        for (int i = 0; i < files.length; ++i) {
            Files.copy(files[i], dest, 2);
        }
    }

    private static void copyJar(File file, File dest) throws IOException {
        if (s_log.isInfoEnabled()) {
            s_log.info((Object)("Copying JAR " + file.toString()));
        }
        Files.copy(file, dest, 2);
        File dir = file.getParentFile();
        JarFile jar = new JarFile(file);
        Manifest manifest = jar.getManifest();
        if (manifest == null) {
            return;
        }
        Attributes attrs = manifest.getMainAttributes();
        if (attrs == null) {
            return;
        }
        String path = attrs.getValue("Class-Path");
        if (path == null) {
            return;
        }
        String[] jars = StringUtils.split(path, ' ');
        for (int i = 0; i < jars.length; ++i) {
            File sub;
            String rel = jars[i].trim();
            if (rel.length() == 0 || !(sub = new File(dir, rel)).exists()) continue;
            if (s_log.isInfoEnabled()) {
                s_log.info((Object)("Copying referenced JAR " + sub.toString()));
            }
            Files.copy(sub, dest, 2);
        }
    }

    private static boolean contains(String line, List packages) {
        Iterator it = packages.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (line.indexOf(key) < 0) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withLongOpt((String)"classpath");
        OptionBuilder.withArgName((String)"FILE");
        OPTIONS.addOption(OptionBuilder.create());
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withLongOpt((String)"webapps");
        OptionBuilder.withArgName((String)"FILE");
        OPTIONS.addOption(OptionBuilder.create());
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withLongOpt((String)"destination");
        OptionBuilder.withArgName((String)"DIRECTORY");
        OPTIONS.addOption(OptionBuilder.create());
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withLongOpt((String)"clean");
        OptionBuilder.withDescription((String)"Remove the destination directory before copying files");
        OPTIONS.addOption(OptionBuilder.create());
    }
}

