/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.packaging;

import com.arsdigita.packaging.ConfigRegistry;
import com.arsdigita.packaging.ParameterMap;
import com.arsdigita.runtime.CCM;
import com.arsdigita.util.Classes;
import com.arsdigita.util.JavaPropertyWriter;
import com.arsdigita.util.parameter.ErrorList;
import com.arsdigita.util.parameter.ParameterContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public final class Config
extends ParameterMap {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/packaging/Config.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private ConfigRegistry m_reg;

    public Config(ConfigRegistry reg) {
        this.m_reg = reg;
        Iterator it = this.m_reg.getContexts().iterator();
        while (it.hasNext()) {
            Class klass = (Class)it.next();
            ParameterContext context = (ParameterContext)Classes.newInstance(klass);
            this.addContext(context);
        }
    }

    void load(ErrorList errs) {
        Iterator it = this.getContexts().iterator();
        while (it.hasNext()) {
            ParameterContext ctx = (ParameterContext)it.next();
            this.m_reg.load(ctx, errs);
        }
    }

    public final boolean load(PrintStream out) {
        ErrorList errs = new ErrorList();
        this.load(errs);
        if (!errs.isEmpty()) {
            out.println(" *** Warning ***");
            errs.report(new OutputStreamWriter(out));
            return false;
        }
        return true;
    }

    public final void save() throws IOException {
        this.save(CCM.getConfigDirectory());
    }

    void save(File conf) throws IOException {
        Properties props;
        String storage;
        if (!conf.exists()) {
            throw new IOException("no such directory: " + conf);
        }
        if (conf.isFile()) {
            throw new IOException("expecting directory: " + conf);
        }
        if (!conf.canWrite()) {
            throw new IOException("cannot write to directory: " + conf);
        }
        HashMap<String, Properties> stores = new HashMap<String, Properties>();
        Iterator<Object> it = this.getContexts().iterator();
        while (it.hasNext()) {
            ParameterContext ctx = (ParameterContext)it.next();
            storage = this.m_reg.getStorage(ctx.getClass());
            props = (Properties)stores.get(storage);
            if (props == null) {
                props = new Properties();
                stores.put(storage, props);
            }
            ctx.save(new JavaPropertyWriter(props));
        }
        it = stores.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = (Map.Entry)it.next();
            storage = (String)me.getKey();
            props = (Properties)me.getValue();
            if (props.size() == 0) continue;
            File file = new File(conf, storage);
            File dir = file.getParentFile();
            dir.mkdirs();
            if (!dir.exists() || !dir.isDirectory()) {
                throw new IOException("unable to create directory: " + dir);
            }
            try {
                FileOutputStream out = new FileOutputStream(file);
                props.store(out, " Generated by " + this.getClass().getName());
                out.close();
            }
            catch (IOException e) {
                throw new IOException("unable to save file: " + e.getMessage());
            }
        }
    }
}

