/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.notification;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Party;
import com.arsdigita.messaging.Message;
import com.arsdigita.notification.Digest;
import com.arsdigita.notification.NotificationConstants;
import com.arsdigita.persistence.OID;
import java.math.BigDecimal;
import java.util.Date;

public class Notification
extends ACSObject
implements NotificationConstants {
    public static final String BASE_DATA_OBJECT_TYPE = (class$com$arsdigita$notification$Notification == null ? (class$com$arsdigita$notification$Notification = Notification.class$("com.arsdigita.notification.Notification")) : class$com$arsdigita$notification$Notification).getName();
    static /* synthetic */ Class class$com$arsdigita$notification$Notification;

    public Notification() {
        super(BASE_DATA_OBJECT_TYPE);
        this.set("requestDate", new Date());
        this.set("maxRetries", new Integer(3));
        this.setStatus("pending");
        this.setIsPermanent(Boolean.TRUE);
        this.setExpandGroup(Boolean.TRUE);
    }

    public Notification(Digest digest, Party to, Party from, String subject, String body) {
        this(to, from, subject, body);
        this.setDigest(digest);
    }

    public Notification(Digest digest, Party to, Message msg) {
        this(to, msg);
        this.setDigest(digest);
    }

    public Notification(Party to, Party from, String subject, String body) {
        this();
        Message msg = new Message(from, subject, body);
        this.setTo(to);
        this.setMessage(msg);
        this.setMessageDelete(Boolean.TRUE);
        this.setIsPermanent(Boolean.FALSE);
    }

    public Notification(Party to, Message msg) {
        this();
        this.setTo(to);
        this.setMessage(msg);
    }

    public Notification(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public Notification(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public void setTo(Party to) {
        this.set("partyTo", to.getID());
    }

    private Message getMessage() {
        BigDecimal id = (BigDecimal)this.get("messageID");
        Message msg = null;
        if (id != null) {
            try {
                msg = new Message(id);
            }
            catch (DataObjectNotFoundException ex) {
                msg = null;
            }
        }
        return msg;
    }

    public void setMessage(Message msg) {
        if (msg.isNew()) {
            msg.save();
        }
        this.set("messageID", msg.getID());
    }

    public String getStatus() {
        return (String)this.get("status");
    }

    void setStatus(String status) {
        this.set("status", status);
    }

    public Boolean getIsPermanent() {
        return new Boolean((Boolean)this.get("expunge") == false);
    }

    public void setIsPermanent(Boolean permanent) {
        this.set("expunge", new Boolean(permanent == false));
    }

    public Boolean getMessageDelete() {
        return (Boolean)this.get("expungeMessage");
    }

    public void setMessageDelete(Boolean value) {
        this.set("expungeMessage", value);
    }

    public Boolean getExpandGroup() {
        return (Boolean)this.get("expandGroup");
    }

    public void setExpandGroup(Boolean expandGroup) {
        this.set("expandGroup", expandGroup);
    }

    public Digest getDigest() throws DataObjectNotFoundException {
        BigDecimal digestID = (BigDecimal)this.get("digestID");
        if (digestID != null) {
            return new Digest(digestID);
        }
        return null;
    }

    public void setDigest(Digest digest) {
        this.set("digestID", digest.getID());
    }

    public Date getRequestDate() {
        return (Date)this.get("requestDate");
    }

    public Date getFulfillDate() {
        return (Date)this.get("fulfillDate");
    }

    void setFulfillDate(Date d) {
        this.set("fulfillDate", d);
    }

    public void setHeader(String header) {
        this.set("header", header);
    }

    public void setSignature(String signature) {
        this.set("signature", signature);
    }

    private boolean isMimeType(String type) {
        Message msg = this.getMessage();
        if (msg == null) {
            return false;
        }
        return msg.isMimeType(type);
    }

    protected void beforeSave() {
        Message msg = this.getMessage();
        if (msg != null) {
            if (msg.isNew()) {
                msg.save();
            }
            this.set("messageID", msg.getID());
        }
        super.beforeSave();
    }

    public void delete() {
        Message msg;
        boolean msgDelete = this.getMessageDelete();
        if (msgDelete) {
            msg = this.getMessage();
            if (msg == null) {
                msgDelete = false;
            }
        } else {
            msg = null;
        }
        super.delete();
        if (msgDelete) {
            msg.delete();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

