/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.localization.demo;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.initializer.Configuration;
import com.arsdigita.initializer.InitializationException;
import com.arsdigita.kernel.PackageType;
import com.arsdigita.kernel.Stylesheet;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import java.util.Locale;
import org.apache.log4j.Logger;

public class Initializer
implements com.arsdigita.initializer.Initializer {
    private Configuration m_conf = new Configuration();
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/localization/demo/Initializer.java#9 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$localization$demo$Initializer == null ? (class$com$arsdigita$localization$demo$Initializer = Initializer.class$("com.arsdigita.localization.demo.Initializer")) : class$com$arsdigita$localization$demo$Initializer));
    private static final String SUBSITE_PACKAGE_KEY = "acs-subsite";
    static /* synthetic */ Class class$com$arsdigita$localization$demo$Initializer;

    public Configuration getConfiguration() {
        return this.m_conf;
    }

    public void startup() {
        String stylesheetPath = "/packages/localization-demo/xsl/login_de.xsl";
        TransactionContext txn = SessionManager.getSession().getTransactionContext();
        txn.beginTxn();
        PackageType subsitePackage = null;
        try {
            subsitePackage = PackageType.findByKey(SUBSITE_PACKAGE_KEY);
        }
        catch (DataObjectNotFoundException e) {
            s_log.warn((Object)"Error registering German-localized stylesheet for the ACS login/registration pages: the \"acs-subsite\" PackageType cannot be found.");
            return;
        }
        boolean isRegistered = false;
        Stylesheet stylesheet = null;
        Stylesheet[] stylesheets = subsitePackage.getStylesheets(Locale.GERMAN, "text/html");
        for (int i = 0; i < stylesheets.length; ++i) {
            stylesheet = stylesheets[i];
            if (!stylesheet.getPath().equals(stylesheetPath)) continue;
            isRegistered = true;
            break;
        }
        if (!isRegistered) {
            s_log.warn((Object)"Localization Demo: registering a German-localized stylesheet for ACS login/registration pages...");
            stylesheet = Stylesheet.createStylesheet(stylesheetPath, Locale.GERMAN);
            subsitePackage.addStylesheet(stylesheet);
            subsitePackage.save();
            s_log.info((Object)"Localization Demo: registration of German-localized stylesheet for ACS login/registration pages completed successfully.");
        }
        txn.commitTxn();
    }

    public void shutdown() throws InitializationException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

