/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel.security;

import com.arsdigita.kernel.security.Initializer;
import com.arsdigita.kernel.security.KeyStorage;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.apache.log4j.Logger;

final class Store
implements KeyStorage {
    static final Store INSTANCE = new Store();
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$kernel$security$Store == null ? (class$com$arsdigita$kernel$security$Store = Store.class$("com.arsdigita.kernel.security.Store")) : class$com$arsdigita$kernel$security$Store));
    private static final String TYPE = "com.arsdigita.kernel.security.KeyStore";
    private static final String ID = "id";
    private static final String OWNER = "owner";
    private static final String STORE = "store";
    private static final String OWNER_VALUE = "kernel.security";
    private static final BigInteger ID_VALUE = new BigInteger("0");
    private byte[] m_secret;
    static /* synthetic */ Class class$com$arsdigita$kernel$security$Store;

    Store() {
    }

    static byte[] newKey() {
        byte[] key = new byte[Initializer.SECRET_KEY_BYTES];
        new SecureRandom().nextBytes(key);
        return key;
    }

    public synchronized void init() {
        if (this.hasBeenInitialized()) {
            throw new UncheckedWrapperException("key store had been initialized");
        }
        this.init(ID_VALUE, OWNER_VALUE, Store.newKey());
    }

    private boolean hasBeenInitialized() {
        DataCollection dc = SessionManager.getSession().retrieve(TYPE);
        dc.addEqualsFilter(ID, ID_VALUE);
        boolean result = dc.size() > 0L;
        dc.close();
        return result;
    }

    void init(BigInteger id, String owner, byte[] store) {
        if (id == null) {
            throw new NullPointerException(ID);
        }
        if (owner == null) {
            throw new NullPointerException(OWNER);
        }
        if (store == null) {
            throw new NullPointerException(STORE);
        }
        if (store.length < 1) {
            throw new IllegalArgumentException("empty store");
        }
        DataObject dobj = SessionManager.getSession().create(TYPE);
        dobj.set(ID, id);
        dobj.set(OWNER, owner);
        dobj.set(STORE, store);
        dobj.save();
    }

    synchronized byte[] loadSecret() {
        if (this.m_secret != null) {
            return this.m_secret;
        }
        DataObject dobj = SessionManager.getSession().retrieve(new OID(TYPE, (Object)ID_VALUE));
        this.m_secret = (byte[])dobj.get(STORE);
        if (this.m_secret == null) {
            throw new IllegalStateException("the store is null");
        }
        if (this.m_secret.length != Initializer.SECRET_KEY_BYTES) {
            throw new IllegalArgumentException("wrong length. expected=" + Initializer.SECRET_KEY_BYTES + ", but got " + this.m_secret.length);
        }
        return this.m_secret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

