/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel.security;

import com.arsdigita.kernel.security.CredentialLoginModule;
import com.arsdigita.kernel.security.CredentialManager;
import com.arsdigita.kernel.security.CredentialNotFoundException;
import com.arsdigita.util.ServletUtils;
import com.arsdigita.util.UncheckedWrapperException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.servlet.http.Cookie;
import org.apache.log4j.Logger;

public class CookieManager
extends CredentialManager {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/security/CookieManager.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((String)(class$com$arsdigita$kernel$security$CookieManager == null ? (class$com$arsdigita$kernel$security$CookieManager = CookieManager.class$("com.arsdigita.kernel.security.CookieManager")) : class$com$arsdigita$kernel$security$CookieManager).getName());
    static /* synthetic */ Class class$com$arsdigita$kernel$security$CookieManager;

    public void initialize(CredentialLoginModule module, Subject subject, CallbackHandler handler, Map shared, Map options) {
        super.initialize(module, subject, handler, shared, options);
    }

    protected boolean shouldSetValue(String value) throws LoginException {
        if (this.getModule().requestIsExcluded()) {
            return false;
        }
        return !this.getModule().credentialIsSet() || !this.getModule().credentialHasValue(value) || this.getModule().credentialIsOld();
    }

    protected final String getValue() throws LoginException {
        s_log.debug((Object)"START getValue");
        String value = ServletUtils.getCookieValue(this.getModule().getRequest(), this.getModule().getCredentialName());
        if (value == null) {
            s_log.debug((Object)"FAILURE getValue");
            throw new CredentialNotFoundException();
        }
        s_log.debug((Object)("SUCCESS getValue: " + value));
        return value;
    }

    protected final void setValue(String value) throws LoginException {
        this.setCookie(this.getModule().getCredentialName(), value, this.getCookieMaxAge());
    }

    protected final void deleteValue() throws LoginException {
        this.deleteCookie(this.getModule().getCredentialName());
    }

    private void deleteCookie(String name) throws LoginException {
        if (this.isCookieSet(name)) {
            s_log.debug((Object)"deleting existing cookie");
            this.setCookie(name, "", 0);
        } else {
            s_log.debug((Object)"Not deleting cookie since it doesn't exist!");
        }
    }

    private boolean isCookieSet(String name) {
        Cookie[] cookies = null;
        try {
            cookies = this.getModule().getRequest().getCookies();
        }
        catch (LoginException ex) {
            throw new UncheckedWrapperException(ex);
        }
        if (cookies == null) {
            return false;
        }
        for (int i = 0; i < cookies.length; ++i) {
            if (!cookies[i].getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private void setCookie(String name, String value, int maxAge) throws LoginException {
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(maxAge);
        cookie.setPath("/");
        cookie.setSecure(this.getModule().isSecure());
        this.getModule().getResponse().addCookie(cookie);
    }

    protected int getCookieMaxAge() throws LoginException {
        return this.getModule().getForever() ? 94608000 : -1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

