/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel.permissions;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelHelper;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionException;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.web.Web;
import java.math.BigDecimal;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

class Permission
extends DomainObject {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/permissions/Permission.java#13 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$kernel$permissions$Permission == null ? (class$com$arsdigita$kernel$permissions$Permission = Permission.class$("com.arsdigita.kernel.permissions.Permission")) : class$com$arsdigita$kernel$permissions$Permission));
    static final String OBJECT_ID = "objectId";
    static final String PARTY_ID = "partyId";
    static final String PRIVILEGE = "privilege";
    static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.kernel.permissions.Permission";
    static /* synthetic */ Class class$com$arsdigita$kernel$permissions$Permission;

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    protected Permission() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    protected Permission(DataObject data) {
        super(data);
    }

    protected Permission(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    OID getPartyOID() {
        return new OID("com.arsdigita.kernel.Party", this.get(PARTY_ID));
    }

    void setPartyOID(OID partyOID) {
        this.set(PARTY_ID, partyOID.get("id"));
    }

    OID getACSObject() {
        return new OID("com.arsdigita.kernel.ACSObject", this.get(OBJECT_ID));
    }

    void setACSObjectOID(OID acsObjectOID) {
        this.set(OBJECT_ID, acsObjectOID.get("id"));
    }

    PrivilegeDescriptor getPrivilege() {
        return PrivilegeDescriptor.get((String)this.get(PRIVILEGE));
    }

    void setPrivilege(PrivilegeDescriptor privilege) {
        this.set(PRIVILEGE, privilege.getName());
    }

    User getCreationUser() {
        Object o = this.get("creationUser");
        if (o == null) {
            return null;
        }
        return User.retrieve((DataObject)o);
    }

    Date getCreationDate() {
        return (Date)this.get("creationDate");
    }

    String getCreationIP() {
        return (String)this.get("creationIP");
    }

    protected void beforeSave() throws PersistenceException {
        if (!this.isNew()) {
            throw new RuntimeException("Permission entries cannot be modified");
        }
        Party party = KernelHelper.getCurrentEffectiveParty();
        if (party == null || !party.getID().equals(Kernel.getSystemParty().getID())) {
            if (party == null) {
                try {
                    party = new User(new BigDecimal(-200.0));
                }
                catch (DataObjectNotFoundException e) {
                    ACSObject o;
                    try {
                        o = (ACSObject)DomainObjectFactory.newInstance(this.getACSObject());
                    }
                    catch (DataObjectNotFoundException de) {
                        throw new IllegalStateException();
                    }
                    throw new PermissionException(PrivilegeDescriptor.ADMIN, o);
                }
            }
            PermissionService.assertPermission(new PermissionDescriptor(PrivilegeDescriptor.ADMIN, this.getACSObject(), party.getOID()));
        }
        this.setCreationInfo();
        super.beforeSave();
    }

    private void setCreationInfo() {
        User user = Web.getContext().getUser();
        HttpServletRequest req = Web.getRequest();
        String ip = null;
        ip = req == null ? "127.0.0.1" : req.getRemoteAddr();
        Date date = new Date();
        this.setAssociation("creationUser", user);
        this.set("creationDate", date);
        this.set("creationIP", ip);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

