/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;

public class EmailAddress {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/EmailAddress.java#11 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private String m_emailAddress;
    private EmailAddressRecord m_emailRecord;

    public EmailAddress(String emailAddress) {
        if (emailAddress == null) {
            throw new IllegalArgumentException("Cannot create an EmailAddress object with null emailAddress string");
        }
        this.m_emailAddress = emailAddress.toLowerCase();
    }

    public EmailAddress(DataObject emailData) {
        this.m_emailRecord = new EmailAddressRecord(emailData);
        this.m_emailAddress = this.m_emailRecord.getEmailAddress();
    }

    public boolean isBouncing() {
        EmailAddressRecord rec = this.getEmailRecord();
        return rec.isBouncing();
    }

    public boolean isVerified() {
        EmailAddressRecord rec = this.getEmailRecord();
        return rec.isVerified();
    }

    public void setIsBouncing(boolean isBouncing) {
        EmailAddressRecord rec = this.getEmailRecord();
        rec.setIsBouncing(isBouncing);
        rec.save();
    }

    public void setIsVerified(boolean isVerified) {
        EmailAddressRecord rec = this.getEmailRecord();
        rec.setIsVerified(isVerified);
        rec.save();
    }

    public String getEmailAddress() {
        return this.m_emailAddress;
    }

    public String toString() {
        return this.getEmailAddress();
    }

    public boolean equals(Object o) {
        if (!(o instanceof EmailAddress)) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    protected DomainObject getEmailDomainObject() {
        return this.getEmailRecord();
    }

    private EmailAddressRecord getEmailRecord() {
        if (this.m_emailRecord == null) {
            try {
                this.m_emailRecord = new EmailAddressRecord(new OID("com.arsdigita.kernel.EmailAddress", (Object)this.m_emailAddress));
            }
            catch (DataObjectNotFoundException e) {
                this.m_emailRecord = new EmailAddressRecord(this.m_emailAddress);
            }
        }
        return this.m_emailRecord;
    }

    private static class EmailAddressRecord
    extends DomainObject {
        private static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.kernel.EmailAddress";

        protected String getBaseDataObjectType() {
            return BASE_DATA_OBJECT_TYPE;
        }

        public EmailAddressRecord(String emailAddress) {
            super(BASE_DATA_OBJECT_TYPE);
            this.set("emailAddress", emailAddress);
            this.setIsBouncing(false);
            this.setIsVerified(false);
        }

        public EmailAddressRecord(OID oid) throws DataObjectNotFoundException {
            super(oid);
        }

        public EmailAddressRecord(DataObject emailData) {
            super(emailData);
        }

        public String getEmailAddress() {
            return (String)this.get("emailAddress");
        }

        public boolean isBouncing() {
            Boolean isBouncing = (Boolean)this.get("isBouncing");
            return isBouncing;
        }

        public void setIsBouncing(boolean isBouncing) {
            this.set("isBouncing", new Boolean(isBouncing));
        }

        public boolean isVerified() {
            Boolean isVerified = (Boolean)this.get("isVerified");
            return isVerified;
        }

        public void setIsVerified(boolean isVerified) {
            this.set("isVerified", new Boolean(isVerified));
        }

        public String toString() {
            return this.getEmailAddress();
        }
    }
}

