/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.globalization;

import com.arsdigita.db.Sequences;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.globalization.GlobalizationException;
import com.arsdigita.globalization.Locale;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.UncheckedWrapperException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class MessageCatalog
extends DomainObject
implements Serializable {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/globalization/MessageCatalog.java#13 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_cat = Logger.getLogger((String)(class$com$arsdigita$globalization$MessageCatalog == null ? (class$com$arsdigita$globalization$MessageCatalog = MessageCatalog.class$("com.arsdigita.globalization.MessageCatalog")) : class$com$arsdigita$globalization$MessageCatalog).getName());
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.globalization.MessageCatalog";
    private boolean m_isReadOnly = true;
    static /* synthetic */ Class class$com$arsdigita$globalization$MessageCatalog;

    public MessageCatalog(String name) {
        super(BASE_DATA_OBJECT_TYPE);
        this.setReadWrite();
        this.setName(name);
    }

    public MessageCatalog(String name, java.util.Locale locale) throws GlobalizationException {
        this(name);
        this.setLocale(locale);
    }

    private MessageCatalog(DataObject dataObject) {
        super(dataObject);
    }

    protected void initialize() {
        super.initialize();
        if (this.isNew() && this.getID() == null) {
            try {
                this.set("id", Sequences.getNextValue());
            }
            catch (SQLException sqle) {
                s_cat.error((Object)"SQL Exception", (Throwable)sqle);
                throw new UncheckedWrapperException("could not get id", sqle);
            }
        }
    }

    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public BigDecimal getID() {
        return (BigDecimal)this.get("id");
    }

    public Date getLastModified() {
        return (Date)this.get("lastModified");
    }

    private void setLastModified() throws GlobalizationException {
        if (this.isReadOnly()) {
            throw new GlobalizationException("MessageCatalog is in read-only mode. You must use the MessageCatalog.retrieveForEdit() static method to edit a MessageCatalog.");
        }
        this.set("lastModified", new Date());
    }

    public java.util.Locale getLocale() {
        Locale localeDomainObject;
        DataObject localeDataObject = (DataObject)this.get("locale");
        java.util.Locale locale = null;
        if (localeDataObject != null && (localeDomainObject = new Locale(localeDataObject)) != null) {
            locale = localeDomainObject.toJavaLocale();
        }
        return locale;
    }

    public void setLocale(java.util.Locale locale) throws GlobalizationException {
        if (!this.isReadOnly()) {
            if (locale != null) {
                Locale localeObject = Locale.fromJavaLocale(locale);
                if (localeObject == null) {
                    throw new GlobalizationException("Locale " + locale.toString() + " is not supported.");
                }
                this.setLocale(localeObject);
            } else {
                this.clearLocale();
            }
        } else {
            throw new GlobalizationException("MessageCatalog is in read-only mode. You must use the MessageCatalog.retrieveForEdit() static method to edit a MessageCatalog.");
        }
    }

    public void setLocale(Locale locale) {
        this.setAssociation("locale", locale);
    }

    private void clearLocale() {
        this.setAssociation("locale", null);
    }

    /*
     * Loose catch block
     */
    public Map getMap() {
        Map catalog;
        block17: {
            catalog = null;
            Object object = this.get("catalog");
            if (object != null) {
                byte[] objectBytes = null;
                ObjectInputStream ois = null;
                if (object instanceof byte[]) {
                    objectBytes = (byte[])object;
                } else if (object instanceof Blob) {
                    try {
                        Blob objectBlob = (Blob)object;
                        objectBytes = objectBlob.getBytes(1L, (int)objectBlob.length());
                    }
                    catch (SQLException sqle) {
                        s_cat.error((Object)"SQL Exception", (Throwable)sqle);
                        throw new UncheckedWrapperException("SQLException: " + sqle.getMessage(), sqle);
                    }
                } else {
                    throw new RuntimeException("Was not able to determine BLOB type.");
                }
                try {
                    ois = new ObjectInputStream(new ByteArrayInputStream(objectBytes));
                }
                catch (IOException ioe) {
                    s_cat.debug(this.get("catalog"), (Throwable)ioe);
                    throw new IllegalStateException("Unable to get catalog.");
                }
                catalog = (Map)ois.readObject();
                Object var7_10 = null;
                try {
                    ois.close();
                }
                catch (IOException e) {
                    s_cat.error((Object)"Problem closing ObjectInputStream.", (Throwable)e);
                }
                break block17;
                {
                    catch (IOException ioe) {
                        throw new IllegalStateException();
                    }
                    catch (ClassNotFoundException cnfe) {
                        throw new IllegalStateException();
                    }
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    try {
                        ois.close();
                    }
                    catch (IOException e) {
                        s_cat.error((Object)"Problem closing ObjectInputStream.", (Throwable)e);
                    }
                    throw throwable;
                }
            }
        }
        return catalog;
    }

    /*
     * Unable to fully structure code
     */
    public void setMap(Map catalog) throws GlobalizationException {
        block10: {
            if (!this.isReadOnly()) {
                baos = new ByteArrayOutputStream();
                oos = null;
                try {
                    oos = new ObjectOutputStream(baos);
                    oos.writeObject(catalog);
                    var6_4 = null;
                    ** if (null == oos) goto lbl-1000
                }
                catch (Throwable var5_9) {
                    var6_5 = null;
                    if (null != oos) {
                        try {
                            oos.close();
                        }
                        catch (IOException e) {
                            MessageCatalog.s_cat.error((Object)"Problem closing ObjectOutputStream.", (Throwable)e);
                        }
                    }
                    throw var5_9;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        oos.close();
                    }
                    catch (IOException e) {
                        MessageCatalog.s_cat.error((Object)"Problem closing ObjectOutputStream.", (Throwable)e);
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block10;
                    catch (IOException ioe) {
                        throw new IllegalStateException();
                    }
                }
            }
            throw new GlobalizationException("MessageCatalog is in read-only mode. You must use the MessageCatalog.retrieveForEdit() static method to edit a MessageCatalog.");
        }
        MessageCatalog.s_cat.debug((Object)baos.toByteArray());
        this.set("catalog", baos.toByteArray());
    }

    public String getName() {
        return (String)this.get("name");
    }

    private void setName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name cannot be empty.");
        }
        this.set("name", name);
    }

    public boolean isReadOnly() {
        return this.m_isReadOnly;
    }

    private void setReadWrite() {
        this.m_isReadOnly = false;
    }

    private static DataObject load(String name) throws GlobalizationException {
        Locale locale = null;
        return MessageCatalog.load(name, locale);
    }

    private static DataObject load(String name, java.util.Locale locale) throws GlobalizationException {
        Locale localeObject = null;
        if (locale != null) {
            localeObject = Locale.fromJavaLocale(locale);
        }
        return MessageCatalog.load(name, localeObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DataObject load(String name, Locale locale) throws GlobalizationException {
        DataObject catalog;
        block6: {
            Session s = SessionManager.getSession();
            DataCollection catalogs = s.retrieve(BASE_DATA_OBJECT_TYPE);
            catalogs.addEqualsFilter("name", name);
            if (locale != null) {
                catalogs.addEqualsFilter("locale.id", locale.getID());
            } else {
                catalogs.addEqualsFilter("locale.id", null);
            }
            catalog = null;
            try {
                if (catalogs.next()) {
                    catalog = catalogs.getDataObject();
                    break block6;
                }
                throw new GlobalizationException("No MessageCatalog found");
            }
            finally {
                catalogs.close();
            }
        }
        return catalog;
    }

    public static MessageCatalog retrieve(String name) throws GlobalizationException {
        return new MessageCatalog(MessageCatalog.load(name));
    }

    public static MessageCatalog retrieve(String name, java.util.Locale locale) throws GlobalizationException {
        return new MessageCatalog(MessageCatalog.load(name, locale));
    }

    public static MessageCatalog retrieveForEdit(String name) throws GlobalizationException {
        MessageCatalog mc = new MessageCatalog(MessageCatalog.load(name));
        mc.setReadWrite();
        return mc;
    }

    public static MessageCatalog retrieveForEdit(String name, java.util.Locale locale) throws GlobalizationException {
        MessageCatalog mc = new MessageCatalog(MessageCatalog.load(name, locale));
        mc.setReadWrite();
        return mc;
    }

    protected void beforeSave() {
        try {
            this.setLastModified();
        }
        catch (GlobalizationException ge) {
            s_cat.error((Object)"MessageCatalog is in read-only mode. You must use the MessageCatalog.retrieveForEdit() static method to edit a MessageCatalog.", (Throwable)ge);
            throw new IllegalStateException("MessageCatalog is in read-only mode. You must use the MessageCatalog.retrieveForEdit() static method to edit a MessageCatalog.");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

