/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder.ui.editors;

import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.form.Widget;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.StringInRangeValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.formbuilder.PersistentFormSection;
import com.arsdigita.formbuilder.PersistentWidget;
import com.arsdigita.formbuilder.WidgetLabel;
import com.arsdigita.formbuilder.ui.editors.WidgetForm;
import com.arsdigita.formbuilder.util.GlobalizationUtil;
import com.arsdigita.globalization.GlobalizedMessage;
import java.math.BigDecimal;

public abstract class WidgetLabelForm
extends WidgetForm {
    private Widget m_label;

    public WidgetLabelForm(String name, SingleSelectionModel form, SingleSelectionModel control) {
        super(name, form, control);
    }

    protected void addWidgets(FormSection section) {
        if (this.wantLabelMultiline()) {
            TextArea text = new TextArea(new StringParameter("label"));
            text.setCols(30);
            text.setRows(10);
            text.addValidationListener(new NotNullValidationListener());
            text.addValidationListener(new StringInRangeValidationListener(1, 4000));
            this.m_label = text;
        } else {
            TextField text = new TextField(new StringParameter("label"));
            text.setSize(30);
            text.addValidationListener(new NotNullValidationListener());
            text.addValidationListener(new StringInRangeValidationListener(1, 4000));
            this.m_label = text;
        }
        this.m_label.setOnFocus("if (this.form.name.value == '') {  defaulting = true; this.form.name.value = urlize(this.value); }");
        this.m_label.setOnKeyUp("if (defaulting) { this.form.name.value = urlize(this.value) }");
        section.add(new Label(this.getLabelText()), 4);
        section.add(this.m_label);
        super.addWidgets(section);
        this.automaticallySetName(this.m_label.getParameterModel());
    }

    protected String getLabelText() {
        return (String)this.getGlobalizedLabelText().localize();
    }

    protected GlobalizedMessage getGlobalizedLabelText() {
        return GlobalizationUtil.globalize("formbuilder.ui.editors.label");
    }

    protected boolean wantLabelMultiline() {
        return false;
    }

    protected void initWidgets(FormSectionEvent e, PersistentWidget widget) throws FormProcessException {
        super.initWidgets(e, widget);
        PageState state = e.getPageState();
        if (widget != null) {
            WidgetLabel l = null;
            try {
                l = WidgetLabel.findByWidget(widget);
            }
            catch (DataObjectNotFoundException ex) {
                throw new FormProcessException("cannot find label for WidgetLabel");
            }
            this.m_label.setValue(state, l.getLabel());
        } else {
            this.m_label.setValue(state, "");
        }
    }

    protected void processWidgets(FormSectionEvent e, PersistentWidget widget) throws FormProcessException {
        super.processWidgets(e, widget);
        FormData data = e.getFormData();
        String label = (String)data.get("label");
        if (widget.isNew()) {
            return;
        }
        WidgetLabel l = null;
        try {
            l = WidgetLabel.findByWidget(widget);
        }
        catch (DataObjectNotFoundException ex) {
            throw new FormProcessException("cannot find label for WidgetLabel");
        }
        l.setLabel(label);
        l.save();
    }

    protected void addToForm(FormSectionEvent e, PersistentWidget widget) throws FormProcessException {
        FormData data = e.getFormData();
        String label = (String)data.get("label");
        BigDecimal form_id = (BigDecimal)this.getSelection().getSelectedKey(e.getPageState());
        PersistentFormSection form = null;
        try {
            form = new PersistentFormSection(form_id);
        }
        catch (DataObjectNotFoundException ex) {
            throw new FormProcessException("cannot find form", ex);
        }
        this.addWidgetLabel(widget, label, form);
        form.addComponent(widget);
        form.save();
    }

    protected WidgetLabel addWidgetLabel(PersistentWidget widget, String label, PersistentFormSection form) {
        WidgetLabel l = WidgetLabel.create(widget, label);
        l.save();
        form.addComponent(l);
        return l;
    }
}

