/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder.actions;

import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.formbuilder.PersistentProcessListener;
import com.arsdigita.formbuilder.util.Placeholders;
import com.arsdigita.mail.Mail;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import java.util.Iterator;
import javax.mail.MessagingException;

public class SimpleEmailListener
extends PersistentProcessListener {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.formbuilder.actions.SimpleEmailListener";
    public static final String TO = "recipient";
    public static final String SUBJECT = "subject";

    public SimpleEmailListener() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public SimpleEmailListener(String typeName) {
        super(typeName);
    }

    public SimpleEmailListener(ObjectType type) {
        super(type);
    }

    public SimpleEmailListener(DataObject obj) {
        super(obj);
    }

    public SimpleEmailListener(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public SimpleEmailListener(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public static SimpleEmailListener create(String name, String description, String to, String subject) {
        SimpleEmailListener l = new SimpleEmailListener();
        l.setup(name, description, to, subject);
        return l;
    }

    protected void setup(String name, String description, String to, String subject) {
        super.setup(name, description);
        this.set(TO, to);
        this.set(SUBJECT, subject);
    }

    public boolean isContainerModified() {
        return false;
    }

    public String getTo() {
        return (String)this.get(TO);
    }

    public void setTo(String to) {
        this.set(TO, to);
    }

    public String getSubject() {
        return (String)this.get(SUBJECT);
    }

    public void setSubject(String subject) {
        this.set(SUBJECT, subject);
    }

    public FormProcessListener createProcessListener() {
        return new SimpleEmailProcessListener(this.getTo(), this.getSubject());
    }

    private class SimpleEmailProcessListener
    implements FormProcessListener {
        String m_to;
        String m_subject;

        public SimpleEmailProcessListener(String to, String subject) {
            this.m_to = to;
            this.m_subject = subject;
        }

        public void process(FormSectionEvent e) throws FormProcessException {
            Placeholders p = new Placeholders(e.getPageState());
            String to = p.interpolate(this.m_to);
            String subject = p.interpolate(this.m_subject);
            String from = p.interpolate("::user.email::");
            StringBuffer body = new StringBuffer(p.interpolate("::user.givenname:: ::user.familyname:: submittted the following form values:\n\n"));
            FormData data = e.getFormData();
            Iterator keys = data.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Object value = data.get(key);
                body.append(key + ": " + (value == null ? "(null)" : value.toString()) + "\n");
            }
            try {
                Mail message = new Mail(to, from, subject, body.toString());
                message.send();
            }
            catch (MessagingException ex) {
                throw new UncheckedWrapperException("cannot send message", ex);
            }
        }
    }
}

