/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.dmi;

import com.arsdigita.dmi.ApplicationVersion;
import com.arsdigita.xmlinterp.XMLInterpreter;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class ProductXMLInterpreter
implements XMLInterpreter {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/dmi/ProductXMLInterpreter.java#11 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$dmi$ProductXMLInterpreter == null ? (class$com$arsdigita$dmi$ProductXMLInterpreter = ProductXMLInterpreter.class$("com.arsdigita.dmi.ProductXMLInterpreter")) : class$com$arsdigita$dmi$ProductXMLInterpreter));
    private String m_sProdName = null;
    private String m_sProdDesc = null;
    private String m_sCurrentVersion = null;
    private String m_sDatabase = null;
    private String m_sInstallFile = null;
    private boolean m_bVersionUpgradeDM = false;
    private String m_sVersionName = null;
    private String m_sVersionUpgradeFile = null;
    private String m_sVersionDesc = null;
    private String m_sVersionPreviousVersion = null;
    private HashMap m_VersionHistories = new HashMap();
    private ArrayList m_AppVersions = new ArrayList();
    private static final int PRODUCT = 0;
    private static final int VERSION_HISTORY = 1;
    private static final int VERSION = 2;
    private int m_iNodeType = 0;
    private String m_sError = "";
    static /* synthetic */ Class class$com$arsdigita$dmi$ProductXMLInterpreter;

    public void shift(String node, String value) {
        node = node.toUpperCase().trim();
        switch (this.m_iNodeType) {
            case 0: {
                if (node.compareTo("CURRENT_VERSION") == 0) {
                    this.m_sCurrentVersion = value;
                    break;
                }
                if (node.compareTo("NAME") == 0) {
                    this.m_sProdName = value;
                    break;
                }
                if (node.compareTo("PRODUCT_DESCRIPTION") == 0) {
                    this.m_sProdDesc = value;
                    break;
                }
                this.m_sError = this.m_sError + "Unsupported Node: " + node + " with value " + value + "\n";
                s_log.error((Object)this.m_sError);
                break;
            }
            case 1: {
                if (node.compareTo("DATABASE") == 0) {
                    this.m_sDatabase = value;
                    break;
                }
                if (node.compareTo("INSTALL_FILE") == 0) {
                    this.m_sInstallFile = value;
                    break;
                }
                this.m_sError = this.m_sError + "Unsupported Node: " + node + " with value " + value + "\n";
                s_log.error((Object)this.m_sError);
                break;
            }
            case 2: {
                if (node.compareTo("NAME") == 0) {
                    this.m_sVersionName = value;
                    break;
                }
                if (node.compareTo("PREVIOUS_VERSION") == 0) {
                    this.m_sVersionPreviousVersion = value;
                    break;
                }
                if (node.compareTo("DATA_MODEL_CHANGE") == 0) {
                    if ((value = value.toUpperCase()).compareTo("YES") == 0) {
                        this.m_bVersionUpgradeDM = true;
                        break;
                    }
                    if (value.compareTo("NO") == 0) {
                        this.m_bVersionUpgradeDM = false;
                        break;
                    }
                    this.m_sError = this.m_sError + "Unsupported Node: " + node + " with value " + value + "\n";
                    s_log.error((Object)this.m_sError);
                    break;
                }
                if (node.compareTo("UPGRADE_FILE") == 0) {
                    this.m_sVersionUpgradeFile = value;
                    break;
                }
                if (node.compareTo("VERSION_DESCRIPTION") == 0) {
                    this.m_sVersionDesc = value;
                    break;
                }
                this.m_sError = this.m_sError + "Unsupported Node: " + node + " with value " + value + "\n";
                s_log.error((Object)this.m_sError);
            }
        }
    }

    public void reduce(String node) {
        if (node.toUpperCase().compareTo("VERSION_HISTORY") == 0) {
            this.m_iNodeType = 0;
            VersionHistory vh = new VersionHistory(this.m_sInstallFile, (ArrayList)this.m_AppVersions.clone());
            this.m_VersionHistories.put(this.m_sDatabase, vh);
            s_log.warn((Object)("m_VersionHistories.put: " + this.m_sDatabase + " : " + this.m_VersionHistories.get(this.m_sDatabase)));
            this.m_sDatabase = null;
            this.m_sInstallFile = null;
            this.m_AppVersions = new ArrayList();
        } else if (node.toUpperCase().compareTo("VERSION") == 0) {
            this.m_iNodeType = 1;
            ApplicationVersion av = new ApplicationVersion(this.m_sVersionName, this.m_bVersionUpgradeDM, this.m_sVersionUpgradeFile, this.m_sVersionDesc, this.m_sVersionPreviousVersion);
            this.m_AppVersions.add(av);
            this.m_sVersionName = null;
            this.m_bVersionUpgradeDM = false;
            this.m_sVersionUpgradeFile = null;
            this.m_sVersionDesc = null;
            this.m_sVersionPreviousVersion = null;
        }
    }

    public void push(Node n) {
        if (n.getNodeName().toUpperCase().compareTo("PRODUCT") == 0) {
            this.m_iNodeType = 0;
        } else if (n.getNodeName().toUpperCase().compareTo("VERSION_HISTORY") == 0) {
            this.m_iNodeType = 1;
        } else if (n.getNodeName().toUpperCase().compareTo("VERSION") == 0) {
            this.m_iNodeType = 2;
        }
    }

    public String getError() {
        return this.m_sError;
    }

    public String getProductName() {
        return this.m_sProdName;
    }

    public String getProductDescription() {
        return this.m_sProdDesc;
    }

    public String getCurrentVersion() {
        return this.m_sCurrentVersion;
    }

    public String[] getDatabase() {
        return (String[])this.m_VersionHistories.keySet().toArray();
    }

    public String getInstallFile(String database) {
        if (this.m_VersionHistories.containsKey(database)) {
            VersionHistory vh = (VersionHistory)this.m_VersionHistories.get(database);
            if (vh == null) {
                return null;
            }
            return vh.getInstallFile();
        }
        return null;
    }

    public ApplicationVersion[] getVersions(String database) {
        if (this.m_VersionHistories.containsKey(database)) {
            VersionHistory vh = (VersionHistory)this.m_VersionHistories.get(database);
            if (vh == null) {
                return null;
            }
            s_log.warn((Object)("vh: " + vh));
            s_log.warn((Object)("database: " + database));
            s_log.warn((Object)("vh.getApplicationVersions(): " + vh.getApplicationVersions()));
            return vh.getApplicationVersions();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class VersionHistory {
        private String installFile = null;
        private ApplicationVersion[] applicationVersions = null;

        VersionHistory(String installFile, ArrayList appVersions) {
            this.installFile = installFile;
            ApplicationVersion[] av = appVersions.toArray(new ApplicationVersion[0]);
            this.applicationVersions = av;
        }

        protected String getInstallFile() {
            return this.installFile;
        }

        protected ApplicationVersion[] getApplicationVersions() {
            return this.applicationVersions;
        }
    }
}

