/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.core;

import com.arsdigita.db.DbHelper;
import com.arsdigita.initializer.Configuration;
import com.arsdigita.initializer.Initializer;
import com.arsdigita.initializer.Script;
import com.arsdigita.packaging.Config;
import com.arsdigita.packaging.ConfigRegistry;
import com.arsdigita.packaging.RegistryConfig;
import com.arsdigita.util.StringUtils;
import com.arsdigita.util.parameter.Parameter;
import com.arsdigita.util.parameter.ParameterContext;
import com.arsdigita.util.servlet.HttpHost;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class TroikaRickshawUpgrade {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$core$TroikaRickshawUpgrade == null ? (class$com$arsdigita$core$TroikaRickshawUpgrade = TroikaRickshawUpgrade.class$("com.arsdigita.core.TroikaRickshawUpgrade")) : class$com$arsdigita$core$TroikaRickshawUpgrade));
    private static final String s_key = "ccm-core";
    private static final String s_defaultDir = "/var/www/ccm-core/dist";
    static /* synthetic */ Class class$com$arsdigita$core$TroikaRickshawUpgrade;

    public static final void main(String[] args) throws IOException {
        RegistryConfig rconfig = new RegistryConfig();
        rconfig.load();
        List<String> loaded = Arrays.asList(rconfig.getPackages());
        if (loaded.contains(s_key)) {
            System.out.println("The ccm-core package is already upgraded");
            System.exit(1);
        }
        ConfigRegistry reg = new ConfigRegistry();
        reg.initialize(s_key);
        Config config = new Config(reg);
        config.load(System.err);
        Parameter param = config.getParameter("waf.config.packages");
        ParameterContext ctx = config.getContainer(param);
        ArrayList<String> pkgs = new ArrayList<String>(Arrays.asList((String[])ctx.get(param)));
        pkgs.add(s_key);
        ctx.set(param, pkgs.toArray(new String[pkgs.size()]));
        String webappBase = null;
        int count = 0;
        while (true) {
            File file;
            if (count == 0) {
                ++count;
                for (int i = 0; i < args.length; ++i) {
                    String[] split = StringUtils.split(args[i], '=');
                    if (split.length != 2 || !"webapp-dir".equals(split[0])) continue;
                    webappBase = split[1];
                    break;
                }
            }
            if (webappBase == null) {
                webappBase = TroikaRickshawUpgrade.promptWebappBase();
            }
            if (webappBase.equals("")) {
                webappBase = s_defaultDir;
            }
            if ((file = new File(webappBase)).exists() && file.isDirectory()) break;
            System.out.println(webappBase + " does not exist or is not a directory. " + "Please check the path and try again.");
        }
        File initFile = new File(webappBase + "/WEB-INF/resources/enterprise.init");
        System.out.println("Loading old configuration from " + initFile);
        Script script = Script.readConfig(new FileReader(initFile));
        Initializer dinit = script.getInitializer("com.arsdigita.db.Initializer");
        Configuration dconfig = dinit.getConfiguration();
        String url = (String)dconfig.getParameter("jdbcUrl");
        String user = (String)dconfig.getParameter("dbUsername");
        String password = (String)dconfig.getParameter("dbPassword");
        int db_type = DbHelper.getDatabaseFromURL(url);
        String jdbc = "";
        switch (db_type) {
            case 1: {
                jdbc = url;
                int index = jdbc.indexOf(58);
                index = jdbc.indexOf(58, index + 1);
                index = jdbc.indexOf(58, index + 1);
                String hostinfo = jdbc.substring(index + 1);
                jdbc = jdbc.substring(0, index) + ":" + user + "/";
                if (password != null && !password.equals("")) {
                    jdbc = jdbc + password;
                }
                jdbc = jdbc + hostinfo;
                break;
            }
            case 2: {
                jdbc = url + "?user=" + user;
                if (password == null || password.equals("")) break;
                jdbc = jdbc + "&password=" + password;
                break;
            }
            default: {
                System.out.println("jdbc url '" + url + "' is not recognized as Oracle or PostgreSQL");
            }
        }
        System.out.println("Translating JDBC URL as " + jdbc);
        TroikaRickshawUpgrade.set(config, "waf.runtime.jdbc_url", jdbc);
        File pdl = new File(webappBase + "/WEB-INF/pdl");
        System.out.println("Loading PDL from " + pdl);
        Initializer winit = script.getInitializer("com.arsdigita.web.Initializer");
        Configuration wconfig = winit.getConfiguration();
        String server = (String)wconfig.getParameter("serverName");
        Integer port = (Integer)wconfig.getParameter("serverPort");
        HttpHost hserver = new HttpHost(server, port);
        System.out.println("Translating server config as " + hserver);
        TroikaRickshawUpgrade.set(config, "waf.web.server", hserver);
        config.save();
    }

    private static String promptWebappBase() throws IOException {
        System.out.println("Enter the fully qualified path of the ccm-core webapp directory or press enter to accept the default.");
        System.out.print("[/var/www/ccm-core/dist]: ");
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        String result = reader.readLine();
        return result.trim();
    }

    private static void set(Config config, String key, Object value) {
        Parameter param = config.getParameter(key);
        ParameterContext ctx = config.getContainer(param);
        ctx.set(param, value);
        System.out.println("Parameter " + key + " set to " + value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

