/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop.table;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.util.Attributes;
import com.arsdigita.util.Assert;
import com.arsdigita.util.Lockable;
import com.arsdigita.xml.Element;

public class TableColumn
extends SimpleComponent
implements Lockable {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/table/TableColumn.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final String WIDTH_ATTR = "width";
    private static final String ALIGN_ATTR = "align";
    private static final String VALIGN_ATTR = "valign";
    private int m_modelIndex;
    private TableCellRenderer m_cellRenderer;
    private TableCellRenderer m_headerRenderer;
    private Object m_headerKey;
    private Object m_headerValue;
    private Attributes m_cellAttrs;

    public TableColumn() {
        this(0);
    }

    public TableColumn(int modelIndex) {
        this(modelIndex, null);
    }

    public TableColumn(int modelIndex, Object value) {
        this(modelIndex, value, null);
    }

    public TableColumn(int modelIndex, Object value, Object key) {
        this.m_modelIndex = modelIndex;
        this.m_headerValue = value;
        this.m_headerKey = key;
        this.m_cellAttrs = new Attributes();
    }

    public final TableCellRenderer getHeaderRenderer() {
        return this.m_headerRenderer;
    }

    public void setHeaderRenderer(TableCellRenderer v) {
        Assert.assertNotLocked(this);
        this.m_headerRenderer = v;
    }

    public final TableCellRenderer getCellRenderer() {
        return this.m_cellRenderer;
    }

    public void setCellRenderer(TableCellRenderer v) {
        Assert.assertNotLocked(this);
        this.m_cellRenderer = v;
    }

    public final Object getHeaderValue() {
        return this.m_headerValue;
    }

    public void setHeaderValue(Object value) {
        Assert.assertNotLocked(this);
        this.m_headerValue = value;
    }

    public final Object getHeaderKey() {
        return this.m_headerKey;
    }

    public void setHeaderKey(Object key) {
        Assert.assertNotLocked(this);
        this.m_headerKey = key;
    }

    public final int getModelIndex() {
        return this.m_modelIndex;
    }

    public void setModelIndex(int v) {
        Assert.assertNotLocked(this);
        this.m_modelIndex = v;
    }

    public String getWidth() {
        return this.getAttribute(WIDTH_ATTR);
    }

    public void setWidth(String v) {
        Assert.assertNotLocked(this);
        this.setAttribute(WIDTH_ATTR, v);
    }

    public void setAlign(String v) {
        Assert.assertNotLocked(this);
        this.m_cellAttrs.setAttribute(ALIGN_ATTR, v);
    }

    public void setHeadAlign(String v) {
        Assert.assertNotLocked(this);
        this.setAttribute(ALIGN_ATTR, v);
    }

    public void setVAlign(String v) {
        Assert.assertNotLocked(this);
        this.m_cellAttrs.setAttribute(VALIGN_ATTR, v);
    }

    public void setHeadVAlign(String v) {
        Assert.assertNotLocked(this);
        this.setAttribute(VALIGN_ATTR, v);
    }

    public void setStyleAttr(String style) {
        Assert.assertNotLocked(this);
        this.m_cellAttrs.setAttribute("style", style);
    }

    public void setHeadStyleAttr(String style) {
        Assert.assertNotLocked(this);
        this.setAttribute("style", style);
    }

    public void setClassAttr(String c) {
        Assert.assertNotLocked(this);
        this.m_cellAttrs.setAttribute("class", c);
    }

    public void setHeadClassAttr(String c) {
        Assert.assertNotLocked(this);
        this.setAttribute("class", c);
    }

    public void exportCellAttributes(Element e) {
        this.m_cellAttrs.exportAttributes(e);
    }

    final void exportHeadAttributes(Element e) {
        super.exportAttributes(e);
    }

    public void generateXML(PageState s, Element e) {
        throw new UnsupportedOperationException("TableColumn used outside of a Table");
    }
}

