/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop.parameters;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.event.ParameterEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.parameters.ParameterData;
import com.arsdigita.globalization.Globalization;
import com.arsdigita.util.Assert;
import com.arsdigita.util.Lockable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public abstract class ParameterModel
implements Lockable {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/parameters/ParameterModel.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    protected String m_name;
    protected Object m_defaultValue;
    protected List m_parameterListeners = new LinkedList();
    protected boolean m_locked = false;
    private boolean m_defaultOverridesNull = false;
    private boolean m_passIn = true;
    private static final Logger s_log = Logger.getLogger((String)(class$com$arsdigita$bebop$parameters$ParameterModel == null ? (class$com$arsdigita$bebop$parameters$ParameterModel = ParameterModel.class$("com.arsdigita.bebop.parameters.ParameterModel")) : class$com$arsdigita$bebop$parameters$ParameterModel).getName());
    static /* synthetic */ Class class$com$arsdigita$bebop$parameters$ParameterModel;
    static /* synthetic */ Class class$java$lang$Object;

    private ParameterModel() {
    }

    protected ParameterModel(String name) {
        this();
        Assert.assertNotLocked(this);
        Assert.assertNotNull(name, "Name");
        Assert.assertNotEmpty(name, "Name");
        this.m_name = name;
    }

    public final void setDefaultOverridesNull(boolean v) {
        Assert.assertNotLocked(this);
        this.m_defaultOverridesNull = v;
    }

    public final boolean isPassIn() {
        return this.m_passIn;
    }

    public final void setPassIn(boolean v) {
        Assert.assertNotLocked(this);
        this.m_passIn = v;
    }

    public final boolean getDefaultOverridesNull() {
        return this.m_defaultOverridesNull;
    }

    public final String getName() {
        return this.m_name;
    }

    public final void setName(String name) {
        Assert.assertNotLocked(this);
        this.m_name = name;
    }

    public void addParameterListener(ParameterListener listener) {
        Assert.assertNotLocked(this);
        this.m_parameterListeners.add(listener);
    }

    public void setDefaultValue(Object defaultValue) {
        Assert.assertNotLocked(this);
        this.m_defaultValue = defaultValue;
    }

    public final Object getDefaultValue() {
        return this.m_defaultValue;
    }

    public abstract Object transformValue(HttpServletRequest var1) throws IllegalArgumentException;

    protected final Object transformSingleValue(HttpServletRequest request) {
        String requestValue = Globalization.decodeParameter(request, this.getName());
        if (requestValue == null) {
            return null;
        }
        return this.unmarshal(requestValue);
    }

    public ParameterData createParameterData(HttpServletRequest request) {
        return this.createParameterData(request, null, false);
    }

    public ParameterData createParameterData(HttpServletRequest request, boolean isSubmission) {
        return this.createParameterData(request, null, isSubmission);
    }

    public ParameterData createParameterData(HttpServletRequest request, Object defaultValue, boolean isSubmission) {
        ParameterData result = new ParameterData(this, null);
        if (isSubmission) {
            try {
                result.setValue(this.transformValue(request));
                if (result.getValue() == null && defaultValue != null) {
                    result.setValue(defaultValue);
                }
                if (this.getDefaultOverridesNull() && result.getValue() == null) {
                    result.setValue(this.getDefaultValue());
                }
            }
            catch (IllegalArgumentException e) {
                if (this.getDefaultOverridesNull()) {
                    result.setValue(this.getDefaultValue());
                } else {
                    result.setValue((Object)null);
                }
                result.addError(e.getMessage());
                result.setUntransformed();
            }
        } else if (this.isPassIn()) {
            try {
                result.setValue(this.transformValue(request));
                if (result.getValue() == null && defaultValue != null) {
                    result.setValue(defaultValue);
                }
                if (result.getValue() == null) {
                    result.setValue(this.getDefaultValue());
                }
            }
            catch (IllegalArgumentException e) {
                result.setValue(this.getDefaultValue());
                result.addError(e.getMessage());
                result.setUntransformed();
            }
        } else if (defaultValue != null) {
            result.setValue(defaultValue);
        } else {
            result.setValue(this.getDefaultValue());
        }
        return result;
    }

    public synchronized void lock() {
        this.m_locked = true;
    }

    protected void validate(ParameterData data) throws FormProcessException {
        Assert.assertLocked(this);
        ParameterEvent e = null;
        Iterator i = this.m_parameterListeners.iterator();
        while (i.hasNext()) {
            if (e == null) {
                e = new ParameterEvent(this, data);
            }
            ((ParameterListener)i.next()).validate(e);
        }
    }

    public String marshal(Object value) {
        return value == null ? null : value.toString();
    }

    public Object unmarshal(String encoded) {
        throw new UnsupportedOperationException("Not implemented. This method needs to be implemented by the specific subclasses.");
    }

    public Class getValueClass() {
        return class$java$lang$Object == null ? (class$java$lang$Object = ParameterModel.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public final boolean isLocked() {
        return this.m_locked;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

