/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop.parameters;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.globalization.GlobalizedMessage;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public final class ParameterData
implements Map.Entry,
Cloneable {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/parameters/ParameterData.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private Object m_value;
    private LinkedList m_errors = new LinkedList();
    private boolean m_isValid = true;
    private boolean m_isTransformed = true;
    private ParameterModel m_model;

    private ParameterData() {
    }

    public ParameterData(ParameterModel model, Object value) {
        this();
        this.m_model = model;
        this.m_value = value;
    }

    public Object clone() throws CloneNotSupportedException {
        ParameterData result = (ParameterData)super.clone();
        result.m_errors = (LinkedList)this.m_errors.clone();
        return result;
    }

    public final Object getValue() {
        return this.m_value;
    }

    public final ParameterModel getModel() {
        return this.m_model;
    }

    public Object getName() {
        return this.m_model.getName();
    }

    public Object getKey() {
        return this.getName();
    }

    public final Object setValue(Object value) {
        Object old = this.m_value;
        this.m_value = value;
        this.m_isTransformed = true;
        return old;
    }

    public final String marshal() {
        return this.getModel().marshal(this.getValue());
    }

    public final void unmarshal(String encoded) {
        this.setValue(this.getModel().unmarshal(encoded));
    }

    public void addError(String message) {
        if (message != null && message.length() > 0) {
            this.addError(new GlobalizedMessage(message));
        }
    }

    public void addError(GlobalizedMessage message) {
        this.m_errors.add(message);
        this.m_isValid = false;
    }

    void copyErrors(ParameterData p) {
        if (p.m_errors.size() > 0) {
            this.m_errors.addAll(p.m_errors);
            this.m_isValid = false;
        }
    }

    void removeErrors() {
        this.m_errors.clear();
    }

    public Iterator getErrors() {
        return this.m_errors.iterator();
    }

    public void validate() throws FormProcessException {
        if (!this.isTransformed()) {
            return;
        }
        this.removeErrors();
        this.m_isValid = true;
        this.m_model.validate(this);
    }

    public boolean isArray() {
        return this.m_value instanceof Object[];
    }

    public final boolean isValid() {
        return this.m_isValid;
    }

    public final boolean isTransformed() {
        return this.m_isTransformed;
    }

    public final void setInvalid() {
        this.invalidate();
    }

    public final void invalidate() {
        this.m_isValid = false;
    }

    public final void setUntransformed() {
        this.m_isTransformed = false;
    }

    public String toString() {
        StringBuffer to = new StringBuffer();
        to.append("{").append(this.m_value).append(", ").append(this.m_errors);
        if (!this.m_isValid) {
            to.append(", not valid");
        }
        if (!this.m_isTransformed) {
            to.append(", not transformed");
        }
        to.append("}");
        return to.toString();
    }
}

