/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop.form;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.OptionGroup;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.util.BebopConstants;
import com.arsdigita.xml.Element;
import java.util.Iterator;

public class RadioGroup
extends OptionGroup
implements BebopConstants {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/form/RadioGroup.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final String AXIS = "axis";
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;

    public RadioGroup(String name) {
        this(new StringParameter(name));
    }

    public RadioGroup(ParameterModel model) {
        super(model);
        this.m_xmlElement = "bebop:radio";
    }

    public String getType() {
        return "radio";
    }

    protected String getElementTag() {
        return "bebop:radioGroup";
    }

    public void generateWidget(PageState state, Element parent) {
        Element radioGroup = parent.newChildElement(this.getElementTag(), "http://www.arsdigita.com/bebop/1.0");
        this.exportAttributes(radioGroup);
        Iterator i = this.getOptions(state);
        while (i.hasNext()) {
            Option o = (Option)i.next();
            o.generateXML(state, radioGroup);
        }
    }

    public boolean isMultiple() {
        return false;
    }

    public void setLayout(int layout) {
        this.setAttribute(AXIS, String.valueOf(layout));
    }

    public int getLayout() {
        String value = this.getAttribute(AXIS);
        if (value == null) {
            return 1;
        }
        if (value.equals(String.valueOf(1))) {
            return 1;
        }
        if (value.equals(String.valueOf(2))) {
            return 2;
        }
        throw new IllegalStateException("invalid value for axis attribute: " + value);
    }
}

