/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop.form;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.xml.Element;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class DHTMLEditor
extends TextArea {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/form/DHTMLEditor.java#11 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public static final int OFF = 0;
    public static final int HARD = 1;
    public static final int SOFT = 2;
    private Config m_config;
    private Set m_plugins;

    public DHTMLEditor(String name) {
        this(new StringParameter(name));
    }

    public DHTMLEditor(ParameterModel model) {
        this(model, Config.STANDARD);
    }

    public DHTMLEditor(ParameterModel model, Config config) {
        super(model);
        this.m_config = config;
        this.m_plugins = new HashSet();
    }

    public String getType() {
        return "DHTMLEditor";
    }

    public void setConfig(String config) {
        this.setAttribute("config", config);
    }

    public void addPlugin(String name) {
        this.m_plugins.add(name);
    }

    public void setRows(int rows) {
        this.setAttribute("rows", String.valueOf(rows));
    }

    public void setCols(int cols) {
        this.setAttribute("cols", String.valueOf(cols));
    }

    public void setWrap(int wrap) {
        String wrapString = null;
        switch (wrap) {
            case 0: {
                wrapString = "off";
                break;
            }
            case 1: {
                wrapString = "hard";
                break;
            }
            case 2: {
                wrapString = "soft";
            }
        }
        if (wrapString != null) {
            this.setAttribute("wrap", wrapString);
        }
    }

    protected String getElementTag() {
        return "bebop:dhtmleditor";
    }

    public void generateWidget(PageState state, Element parent) {
        String value = this.getParameterData(state).marshal();
        Element editor = parent.newChildElement(this.getElementTag(), "http://www.arsdigita.com/bebop/1.0");
        editor.addAttribute("name", this.getName());
        if (value != null) {
            editor.setText(value);
        } else {
            editor.setText("Edit text here");
        }
        this.exportAttributes(editor);
        Element config = editor.newChildElement("bebop:config", "http://www.arsdigita.com/bebop/1.0");
        config.addAttribute("name", this.m_config.getName());
        if (this.m_config.getPath() != null) {
            config.addAttribute("path", this.m_config.getPath());
        }
        Iterator plugins = this.m_plugins.iterator();
        while (plugins.hasNext()) {
            String name = (String)plugins.next();
            Element plugin = editor.newChildElement("bebop:plugin", "http://www.arsdigita.com/bebop/1.0");
            plugin.addAttribute("name", name);
        }
    }

    public static class Config {
        public static final Config STANDARD = new Config("HTMLArea.Config", null);
        private String m_name;
        private String m_path;

        public Config(String name) {
            this(name, null);
        }

        public Config(String name, String path) {
            this.m_name = name;
            this.m_path = path;
        }

        public String getName() {
            return this.m_name;
        }

        public String getPath() {
            return this.m_path;
        }

        public static Config valueOf(String cfg) {
            int offset = cfg.indexOf(",");
            if (offset != -1) {
                return new Config(cfg.substring(0, offset), cfg.substring(offset + 1));
            }
            return new Config(cfg);
        }

        public String toString() {
            if (this.m_path == null) {
                return this.m_name;
            }
            return this.m_name + "," + this.m_path;
        }
    }
}

