/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.util.BebopConstants;
import com.arsdigita.util.Assert;
import com.arsdigita.xml.Element;

public class SegmentedPanel
extends SimpleContainer
implements BebopConstants {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/SegmentedPanel.java#10 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public static final String HEADER_CLASS = "seg-header";

    public SegmentedPanel() {
    }

    public SegmentedPanel(String idAttr) {
        this();
        this.setIdAttr(idAttr);
    }

    public Segment addSegment(Component header, Component body) {
        Segment s = new Segment(header, body);
        this.add(s);
        return s;
    }

    public Segment addSegment(String segmentID, Component header, Component body) {
        Segment s = this.addSegment(header, body);
        s.setIdAttr(segmentID);
        return s;
    }

    public Segment addSegment(String segmentID, Component body) {
        return this.addSegment(segmentID, null, body);
    }

    public Segment addSegment() {
        Segment result = new Segment();
        this.add(result);
        return result;
    }

    public void generateXML(PageState state, Element parent) {
        if (this.isVisible(state)) {
            Element panel = parent.newChildElement("bebop:segmentedPanel", "http://www.arsdigita.com/bebop/1.0");
            this.exportAttributes(panel);
            super.generateXML(state, panel);
        }
    }

    public static class Segment
    extends SimpleContainer {
        private SimpleContainer m_header;
        private SimpleContainer m_body;

        public Segment() {
            this((Component)null, (Component)null);
        }

        public Segment(Component header, Component body) {
            if (header != null) {
                this.addHeader(header);
            }
            if (body != null) {
                this.add(body);
            }
        }

        public Segment(Component body) {
            this(null, body);
        }

        public void addHeader(Component c) {
            Assert.assertNotLocked(this);
            if (this.m_header == null) {
                this.m_header = new SimpleContainer("bebop:segmentHeader", "http://www.arsdigita.com/bebop/1.0");
                super.add(this.m_header);
            }
            this.m_header.add(c);
        }

        public void add(Component c) {
            Assert.assertNotLocked(this);
            if (this.m_body == null) {
                this.m_body = new SimpleContainer("bebop:segmentBody", "http://www.arsdigita.com/bebop/1.0");
                super.add(this.m_body);
            }
            this.m_body.add(c);
        }

        public void add(Component c, int constraints) {
            this.add(c);
        }

        public void generateXML(PageState state, Element parent) {
            if (this.isVisible(state)) {
                Element seg = parent.newChildElement("bebop:segment", "http://www.arsdigita.com/bebop/1.0");
                this.exportAttributes(seg);
                super.generateXML(state, seg);
            }
        }
    }
}

