/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.SessionExpiredException;
import com.arsdigita.bebop.parameters.BitSetParameter;
import com.arsdigita.bebop.parameters.ParameterData;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.util.Traversal;
import com.arsdigita.developersupport.DeveloperSupport;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.util.Assert;
import com.arsdigita.web.ParameterMap;
import com.arsdigita.web.URL;
import com.arsdigita.web.Web;
import com.arsdigita.xml.Element;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class PageState {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/PageState.java#22 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$bebop$PageState == null ? (class$com$arsdigita$bebop$PageState = PageState.class$("com.arsdigita.bebop.PageState")) : class$com$arsdigita$bebop$PageState));
    private Page m_page;
    private HttpServletRequest m_request;
    private HttpServletResponse m_response;
    private FormData m_pageState;
    private Map m_attributes;
    private Component m_grabbingComponent;
    private BitSet m_invisible;
    private boolean m_visibilityDirty = true;
    private int m_nextSession;
    private static final String SESSION_ATTRIBUTE = "com.arsdigita.bebop.FormData";
    private static final String SESSION_COUNTER_ATTRIBUTE = "com.arsdigita.bebop.FormData.counter";
    private static final String CURRENT_SESSION_PARAMETER = "bbp.session";
    private static final String PAGE_STATE_ATTRIBUTE = "com.arsdigita.bebop.PageState";
    private static int s_maxSessions = 10;
    private Traversal m_visibilityTraversal = new VisibilityTraversal();
    private List m_visibleComponents;
    static /* synthetic */ Class class$com$arsdigita$bebop$PageState;

    public static int getMaxStatesInSession() {
        return s_maxSessions;
    }

    public static void setMaxStatesInSession(int x) {
        s_maxSessions = x;
    }

    public static PageState getPageState(HttpServletRequest request) {
        return (PageState)request.getAttribute(PAGE_STATE_ATTRIBUTE);
    }

    public static PageState getPageState() {
        HttpServletRequest request = DispatcherHelper.getRequest();
        if (request == null) {
            return null;
        }
        return PageState.getPageState(request);
    }

    public PageState(Page page, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.m_page = page;
        if (this.m_page == null) {
            this.m_page = new Page();
            this.m_page.lock();
        }
        this.m_request = request;
        this.m_response = response;
        FormData pageStateFromSession = null;
        if (this.m_page.isUsingHttpSession()) {
            pageStateFromSession = this.getStateFromSession();
        }
        this.m_pageState = new FormData(this.m_page.getStateModel(), request, true, pageStateFromSession);
        this.m_page.getStateModel().process(this, this.m_pageState);
        this.m_invisible = this.decodeVisibility();
        this.m_request.setAttribute(PAGE_STATE_ATTRIBUTE, (Object)this);
    }

    protected BitSet decodeVisibility() {
        BitSet difference = (BitSet)this.m_pageState.get("bbp.i");
        BitSet current = (BitSet)this.m_page.m_invisible.clone();
        if (difference != null) {
            current.xor(difference);
        }
        return current;
    }

    protected BitSet encodeVisibility(BitSet current) {
        BitSet difference = (BitSet)this.m_page.m_invisible.clone();
        difference.xor(current);
        return difference;
    }

    private FormData getStateFromSession() throws SessionExpiredException {
        HttpSession session = this.m_request.getSession(true);
        FormData state = null;
        String key = this.m_request.getParameter(CURRENT_SESSION_PARAMETER);
        if (key != null && (state = (FormData)session.getAttribute(SESSION_ATTRIBUTE + key)) == null) {
            throw new SessionExpiredException();
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void respond() throws ServletException {
        String compKey = (String)this.m_pageState.get("bbp.s");
        if (compKey != null) {
            Component c = this.m_page.getComponent(compKey);
            if (c == null) {
                throw new ServletException("Selected component not on page.");
            }
            try {
                DeveloperSupport.startStage("Bebop Respond " + c.getClass().getName());
                c.respond(this);
            }
            finally {
                DeveloperSupport.endStage("Bebop Respond " + c.getClass().getName());
            }
        }
    }

    public final Page getPage() {
        return this.m_page;
    }

    public final HttpServletRequest getRequest() {
        return this.m_request;
    }

    public final HttpServletResponse getResponse() {
        return this.m_response;
    }

    private Component getComponent(int i) {
        return this.m_page.getComponent(i);
    }

    private int indexOf(Component c) {
        return this.m_page.stateIndex(c);
    }

    public boolean isVisible(Component c) {
        if (!this.getPage().stateContains(c)) {
            return true;
        }
        if (this.m_invisible == null) {
            return this.m_page.isVisibleDefault(c);
        }
        return !this.m_invisible.get(this.indexOf(c));
    }

    public boolean isVisibleOnPage(Component c) {
        if (this.m_visibleComponents == null) {
            this.m_visibleComponents = new ArrayList();
            this.m_visibilityTraversal.preorder(this.getPage().getPanel());
        }
        return this.m_visibleComponents.contains(c);
    }

    public void setVisible(Component c, boolean v) {
        if (Assert.isEnabled()) {
            Assert.truth(this.getPage().stateContains(c), "Component" + c + " is not registered on Page " + this.getPage());
        }
        if (this.m_invisible == null || this.m_invisible == this.getPage().m_invisible) {
            this.m_invisible = (BitSet)this.getPage().m_invisible.clone();
        }
        int i = this.indexOf(c);
        if (v) {
            this.m_invisible.clear(i);
        } else {
            this.m_invisible.set(i);
        }
        if (s_log.isInfoEnabled()) {
            s_log.info((Object)("Marking visibility parameter as dirty " + this.m_request));
        }
        this.m_visibilityDirty = true;
        this.m_visibleComponents = null;
    }

    public void reset(Component c) {
        this.getPage().reset(this, c);
    }

    public void setAttribute(Object key, Object value) {
        if (this.m_attributes == null) {
            this.m_attributes = new HashMap();
        }
        this.m_attributes.put(key, value);
    }

    public Object getAttribute(Object key) {
        if (this.m_attributes == null) {
            return null;
        }
        return this.m_attributes.get(key);
    }

    public void setValue(ParameterModel p, Object value) {
        this.m_pageState.put(p.getName(), value);
    }

    public Object getValue(ParameterModel p) {
        return this.m_pageState.get(p.getName());
    }

    public Object getGlobalValue(String name) {
        try {
            return this.m_pageState.get(this.m_page.parameterName(name));
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    public void setGlobalValue(String name, Object value) {
        this.m_pageState.put(this.m_page.parameterName(name), value);
    }

    public void grabControlEvent(Component c) {
        if (this.m_grabbingComponent != null && this.m_grabbingComponent != c) {
            throw new IllegalStateException("Component " + this.m_grabbingComponent.toString() + " already holds the control event");
        }
        this.m_grabbingComponent = c;
    }

    public void setControlEvent(Component c, String name, String value) {
        Assert.assertTrue(c == null || this.getPage().stateContains(c), "c == null || getPage().stateContains(c)");
        if (this.m_grabbingComponent != null && this.m_grabbingComponent != c) {
            throw new IllegalStateException("Component " + this.m_grabbingComponent.toString() + " holds the control event");
        }
        String key = null;
        if (c != null && (key = c.getKey()) == null) {
            key = Integer.toString(this.m_page.stateIndex(c));
        }
        this.m_pageState.put("bbp.s", c == null ? null : key);
        this.m_pageState.put("bbp.e", name);
        this.m_pageState.put("bbp.v", value);
    }

    public void setControlEvent(Component c) {
        this.setControlEvent(c, null, null);
    }

    public void clearControlEvent() {
        this.setControlEvent(null);
    }

    public String getControlEventName() {
        return (String)this.m_pageState.get("bbp.e");
    }

    public String getControlEventValue() {
        return (String)this.m_pageState.get("bbp.v");
    }

    public void releaseControlEvent(Component c) {
        if (this.m_grabbingComponent == null) {
            throw new IllegalStateException("No component holds the control event, but " + c.toString() + " tries to release it.");
        }
        if (c != this.m_grabbingComponent) {
            throw new IllegalStateException("Component " + this.m_grabbingComponent.toString() + " holds the control event, but " + c.toString() + " tries to release it.");
        }
        this.m_grabbingComponent = null;
    }

    public void generateXML(Element parent) {
        this.synchronizeVisibility();
        Iterator i = this.m_pageState.getParameters().iterator();
        while (i.hasNext()) {
            ParameterData p = (ParameterData)i.next();
            String key = (String)p.getName();
            String value = p.marshal();
            if (value == null) continue;
            Element hidden = parent.newChildElement("bebop:pageState", "http://www.arsdigita.com/bebop/1.0");
            hidden.addAttribute("name", key);
            hidden.addAttribute("value", value);
        }
    }

    public void generateXML(Element parent, Iterator models) {
        this.synchronizeVisibility();
        ArrayList<String> excludeParams = new ArrayList<String>();
        if (models != null) {
            while (models.hasNext()) {
                excludeParams.add(((ParameterModel)models.next()).getName());
            }
        }
        Iterator i = this.m_pageState.getParameters().iterator();
        while (i.hasNext()) {
            ParameterData p = (ParameterData)i.next();
            String key = (String)p.getName();
            String value = p.marshal();
            if (value == null || excludeParams.contains(key)) continue;
            Element hidden = parent.newChildElement("bebop:pageState", "http://www.arsdigita.com/bebop/1.0");
            hidden.addAttribute("name", key);
            hidden.addAttribute("value", value);
        }
    }

    void stateAsHttpSession() {
        HttpSession session = this.m_request.getSession(true);
        Integer counterObj = (Integer)session.getAttribute(SESSION_COUNTER_ATTRIBUTE);
        this.m_nextSession = counterObj == null ? 0 : counterObj + 1;
        session.setAttribute(SESSION_ATTRIBUTE + this.m_nextSession, (Object)this.m_pageState);
        session.setAttribute(SESSION_COUNTER_ATTRIBUTE, (Object)new Integer(this.m_nextSession));
        int toRemove = this.m_nextSession - s_maxSessions;
        if (toRemove >= 0) {
            session.removeAttribute(SESSION_ATTRIBUTE + toRemove);
        }
    }

    public String stateAsURL() throws IOException {
        return this.m_response.encodeURL(this.toURL().toString());
    }

    public final URL toURL() {
        this.synchronizeVisibility();
        ParameterMap params = new ParameterMap();
        if (s_log.isDebugEnabled()) {
            this.dumpVisibility();
        }
        Iterator iter = this.m_pageState.getParameters().iterator();
        while (iter.hasNext()) {
            String value;
            ParameterData data = (ParameterData)iter.next();
            String key = (String)data.getName();
            if (this.m_page.isUsingHttpSession() && !Page.CONTROL_EVENT_KEYS.contains(key) || (value = data.marshal()) == null) continue;
            params.setParameter(key, value);
        }
        if (this.m_page.isUsingHttpSession()) {
            params.setParameter(CURRENT_SESSION_PARAMETER, new Integer(this.m_nextSession));
        }
        return URL.request(this.m_request, params);
    }

    private void synchronizeVisibility() {
        if (this.m_visibilityDirty) {
            if (s_log.isInfoEnabled()) {
                s_log.info((Object)("Encoding visibility parameter " + this.m_request));
            }
            this.m_pageState.put("bbp.i", this.encodeVisibility(this.m_invisible));
            this.m_visibilityDirty = false;
        }
    }

    private void dumpVisibility() {
        BitSetParameter raw = new BitSetParameter("raw", 0);
        BitSetParameter dgap = new BitSetParameter("dgap", 1);
        BitSet current = this.m_invisible;
        BitSet base = this.m_page.m_invisible;
        BitSet difference = (BitSet)current.clone();
        difference.xor(base);
        s_log.debug((Object)("Current: " + current.toString()));
        s_log.debug((Object)("Default: " + base.toString()));
        s_log.debug((Object)("Difference: " + difference.toString()));
        s_log.debug((Object)("Current RAW: " + raw.marshal(current)));
        s_log.debug((Object)("Default RAW: " + raw.marshal(base)));
        s_log.debug((Object)("Difference RAW: " + raw.marshal(difference)));
        s_log.debug((Object)("Current DGAP: " + dgap.marshal(current)));
        s_log.debug((Object)("Default DGAP: " + dgap.marshal(base)));
        s_log.debug((Object)("Difference DGAP: " + dgap.marshal(difference)));
        s_log.debug((Object)("Current Result: " + dgap.unmarshal(dgap.marshal(current))));
        s_log.debug((Object)("Default Result: " + dgap.unmarshal(dgap.marshal(base))));
        s_log.debug((Object)("Difference Result: " + dgap.unmarshal(dgap.marshal(difference))));
        if (!current.equals(dgap.unmarshal(dgap.marshal(current)))) {
            s_log.debug((Object)"Broken marshal/unmarshal for current");
        }
        if (!base.equals(dgap.unmarshal(dgap.marshal(base)))) {
            s_log.debug((Object)"Broken marshal/unmarshal for default");
        }
        if (!difference.equals(dgap.unmarshal(dgap.marshal(difference)))) {
            s_log.debug((Object)"Broken marshal/unmarshal for difference");
        }
    }

    public String getRequestURI() {
        URL url = Web.getContext().getRequestURL();
        if (url == null) {
            return this.m_request.getRequestURI();
        }
        return url.getRequestURI();
    }

    public boolean isValid() {
        return this.m_pageState.isValid();
    }

    public Iterator getErrors() {
        return this.m_pageState.getAllErrors();
    }

    public String getErrorsString() {
        StringBuffer s = new StringBuffer();
        Iterator i = this.m_pageState.getAllErrors();
        while (i.hasNext()) {
            s.append(i.next().toString());
            s.append(System.getProperty("line.separator"));
        }
        return s.toString();
    }

    public void forceValidate() {
        this.m_pageState.forceValidate(this);
    }

    public String toString() {
        String newLine = System.getProperty("line.separator");
        String result = super.toString() + " = {" + newLine + "m_page = " + this.m_page + "," + newLine + "m_request = " + this.m_request + "," + newLine + "m_response = " + this.m_response + "," + newLine + "m_pageState = " + this.m_pageState.asString() + "," + newLine + "m_attributes = " + this.m_attributes + "," + newLine + "," + newLine + "m_grabbingComponent = " + this.m_grabbingComponent + "," + newLine + "m_invisible = " + this.m_invisible + newLine + "}";
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class VisibilityTraversal
    extends Traversal {
        private VisibilityTraversal() {
        }

        protected void act(Component c) {
            PageState.this.m_visibleComponents.add(c);
        }

        protected int test(Component c) {
            if (PageState.this.isVisible(c)) {
                return 0;
            }
            return 2;
        }
    }
}

