/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.auditing;

import com.arsdigita.auditing.AuditingSaveFactory;
import com.arsdigita.auditing.AuditingSaveInfo;
import com.arsdigita.auditing.BasicAuditTrail;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectObserver;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.PersistenceException;
import org.apache.log4j.Logger;

public class AuditingObserver
implements DomainObjectObserver {
    public static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$auditing$AuditingObserver == null ? (class$com$arsdigita$auditing$AuditingObserver = AuditingObserver.class$("com.arsdigita.auditing.AuditingObserver")) : class$com$arsdigita$auditing$AuditingObserver));
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/auditing/AuditingObserver.java#11 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private BasicAuditTrail m_audit_trail;
    private AuditingSaveInfo m_save_info = null;
    private boolean m_wasNew = false;
    static /* synthetic */ Class class$com$arsdigita$auditing$AuditingObserver;

    public AuditingObserver(BasicAuditTrail audit_trail) {
        this.m_audit_trail = audit_trail;
    }

    protected AuditingSaveInfo getSaveInfo() {
        return AuditingSaveFactory.newInstance();
    }

    public void beforeSave(DomainObject dobj) throws PersistenceException {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Doing before " + dobj));
        }
        if (dobj.isNew()) {
            this.m_wasNew = true;
        }
        this.m_save_info = this.getSaveInfo();
    }

    public void afterSave(DomainObject dobj) throws PersistenceException {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Doing after " + dobj));
        }
        if (dobj instanceof ACSObject && this.m_save_info != null) {
            ACSObject aobj = (ACSObject)dobj;
            if (this.m_audit_trail.isNew()) {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Setting create " + dobj));
                }
                this.m_audit_trail.setID(aobj.getID());
                this.m_audit_trail.setCreationInfo(this.m_save_info);
                this.m_wasNew = false;
            }
            this.m_audit_trail.setLastModifiedInfo(this.m_save_info);
            this.m_save_info = null;
            this.m_audit_trail.save();
        }
    }

    public void beforeDelete(DomainObject dobj) throws PersistenceException {
    }

    public void set(DomainObject dobj, String name, Object old_value, Object new_value) {
    }

    public void add(DomainObject dobj, String name, DataObject dataObject) {
    }

    public void remove(DomainObject dobj, String name, DataObject dataObject) {
    }

    public void clear(DomainObject dobj, String name) {
    }

    public void afterDelete(DomainObject dobj) throws PersistenceException {
    }

    public boolean equals(Object other) {
        if (other instanceof AuditingObserver) {
            return this.m_audit_trail.equals(((AuditingObserver)other).m_audit_trail);
        }
        return false;
    }

    public int hashCode() {
        return this.m_audit_trail.hashCode();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

