/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.profiler.rdbms;

import com.redhat.persistence.engine.rdbms.RDBMSProfiler;
import com.redhat.persistence.engine.rdbms.RDBMSStatement;
import com.redhat.persistence.engine.rdbms.StatementLifecycle;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CompoundProfiler
implements RDBMSProfiler {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/profiler/rdbms/CompoundProfiler.java#3 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private List m_children = new ArrayList();

    public void add(RDBMSProfiler child) {
        this.m_children.add(child);
    }

    public StatementLifecycle getLifecycle(RDBMSStatement stmt) {
        CompoundLifecycle result = null;
        Iterator it = this.m_children.iterator();
        while (it.hasNext()) {
            RDBMSProfiler child = (RDBMSProfiler)it.next();
            StatementLifecycle sl = child.getLifecycle(stmt);
            if (sl == null) continue;
            if (result == null) {
                result = new CompoundLifecycle();
            }
            result.add(sl);
        }
        return result;
    }

    private static class CompoundLifecycle
    implements StatementLifecycle {
        private List m_children = new ArrayList();

        private CompoundLifecycle() {
        }

        public void add(StatementLifecycle child) {
            this.m_children.add(child);
        }

        public void beginPrepare() {
            Iterator it = this.m_children.iterator();
            while (it.hasNext()) {
                StatementLifecycle child = (StatementLifecycle)it.next();
                child.beginPrepare();
            }
        }

        public void endPrepare() {
            Iterator it = this.m_children.iterator();
            while (it.hasNext()) {
                StatementLifecycle child = (StatementLifecycle)it.next();
                child.endPrepare();
            }
        }

        public void endPrepare(SQLException e) {
            Iterator it = this.m_children.iterator();
            while (it.hasNext()) {
                StatementLifecycle child = (StatementLifecycle)it.next();
                child.endPrepare(e);
            }
        }

        public void beginSet(int pos, int type, Object obj) {
            Iterator it = this.m_children.iterator();
            while (it.hasNext()) {
                StatementLifecycle child = (StatementLifecycle)it.next();
                child.beginSet(pos, type, obj);
            }
        }

        public void endSet() {
            Iterator it = this.m_children.iterator();
            while (it.hasNext()) {
                StatementLifecycle child = (StatementLifecycle)it.next();
                child.endSet();
            }
        }

        public void endSet(SQLException e) {
            Iterator it = this.m_children.iterator();
            while (it.hasNext()) {
                StatementLifecycle child = (StatementLifecycle)it.next();
                child.endSet(e);
            }
        }

        public void beginExecute() {
            Iterator it = this.m_children.iterator();
            while (it.hasNext()) {
                StatementLifecycle child = (StatementLifecycle)it.next();
                child.beginExecute();
            }
        }

        public void endExecute(int updateCount) {
            Iterator it = this.m_children.iterator();
            while (it.hasNext()) {
                StatementLifecycle child = (StatementLifecycle)it.next();
                child.endExecute(updateCount);
            }
        }

        public void endExecute(SQLException e) {
            Iterator it = this.m_children.iterator();
            while (it.hasNext()) {
                StatementLifecycle child = (StatementLifecycle)it.next();
                child.endExecute(e);
            }
        }

        public void beginNext() {
            Iterator it = this.m_children.iterator();
            while (it.hasNext()) {
                StatementLifecycle child = (StatementLifecycle)it.next();
                child.beginNext();
            }
        }

        public void endNext(boolean more) {
            Iterator it = this.m_children.iterator();
            while (it.hasNext()) {
                StatementLifecycle child = (StatementLifecycle)it.next();
                child.endNext(more);
            }
        }

        public void endNext(SQLException e) {
            Iterator it = this.m_children.iterator();
            while (it.hasNext()) {
                StatementLifecycle child = (StatementLifecycle)it.next();
                child.endNext(e);
            }
        }

        public void beginGet(String column) {
            Iterator it = this.m_children.iterator();
            while (it.hasNext()) {
                StatementLifecycle child = (StatementLifecycle)it.next();
                child.beginGet(column);
            }
        }

        public void endGet(Object result) {
            Iterator it = this.m_children.iterator();
            while (it.hasNext()) {
                StatementLifecycle child = (StatementLifecycle)it.next();
                child.endGet(result);
            }
        }

        public void endGet(SQLException e) {
            Iterator it = this.m_children.iterator();
            while (it.hasNext()) {
                StatementLifecycle child = (StatementLifecycle)it.next();
                child.endGet(e);
            }
        }

        public void beginClose() {
            Iterator it = this.m_children.iterator();
            while (it.hasNext()) {
                StatementLifecycle child = (StatementLifecycle)it.next();
                child.beginClose();
            }
        }

        public void endClose() {
            Iterator it = this.m_children.iterator();
            while (it.hasNext()) {
                StatementLifecycle child = (StatementLifecycle)it.next();
                child.endClose();
            }
        }

        public void endClose(SQLException e) {
            Iterator it = this.m_children.iterator();
            while (it.hasNext()) {
                StatementLifecycle child = (StatementLifecycle)it.next();
                child.endClose(e);
            }
        }
    }
}

