/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.oql;

import com.redhat.persistence.metadata.Root;
import com.redhat.persistence.oql.Code;
import com.redhat.persistence.oql.EquiSet;
import com.redhat.persistence.oql.Expression;
import com.redhat.persistence.oql.Generator;
import com.redhat.persistence.oql.QFrame;
import com.redhat.persistence.oql.Size;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.LRUMap;
import org.apache.log4j.Logger;

public class Query {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/oql/Query.java#8 $ by $Author: mbooth $, $DateTime: 2004/05/28 09:51:17 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$redhat$persistence$oql$Query == null ? (class$com$redhat$persistence$oql$Query = Query.class$("com.redhat.persistence.oql.Query")) : class$com$redhat$persistence$oql$Query));
    private Expression m_query;
    private List m_names;
    private Map m_fetched;
    private static final String ROWNUM = "rownum__";
    private static final ThreadLocal s_generators = new ThreadLocal(){

        public Object initialValue() {
            return new Generator();
        }
    };
    private static LRUMap s_cache = new LRUMap(2000);
    static /* synthetic */ Class class$com$redhat$persistence$oql$Query;

    public Query(Expression query) {
        this.m_query = query;
        this.m_names = new ArrayList();
        this.m_fetched = new HashMap();
    }

    public void fetch(String name, Expression value) {
        if (this.m_fetched.containsKey(name)) {
            throw new IllegalArgumentException(name + ": already bound to " + this.m_fetched.get(name));
        }
        this.m_names.add(name);
        this.m_fetched.put(name, value);
    }

    private Expression get(String name) {
        return (Expression)this.m_fetched.get(name);
    }

    public Code generate(Root root) {
        return this.generate(root, false);
    }

    public static void setQueryCacheSize(int size) {
        s_cache = new LRUMap(size);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Reset query cache to size " + size));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Code generate(Root root, boolean oracle) {
        QFrame qf;
        QFrame qf2;
        int i;
        boolean modified;
        Code cached;
        Object name;
        Generator gen = (Generator)s_generators.get();
        gen.init(root);
        this.m_query.hash(gen);
        for (int i2 = 0; i2 < this.m_names.size(); ++i2) {
            name = (String)this.m_names.get(i2);
            gen.hash((String)name);
            Expression e = this.get((String)name);
            e.hash(gen);
        }
        name = s_cache;
        synchronized (name) {
            cached = (Code)s_cache.get(gen.getLookupKey());
        }
        if (cached != null) {
            Code c = cached.resolve(gen.getBindings(), root);
            return c;
        }
        this.m_query.frame(gen);
        QFrame qframe = gen.getFrame(this.m_query);
        gen.push(qframe);
        try {
            for (int i3 = 0; i3 < this.m_names.size(); ++i3) {
                Expression e = this.get((String)this.m_names.get(i3));
                e.frame(gen);
            }
        }
        finally {
            gen.pop();
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("unoptimized frame:\n" + qframe));
        }
        List frames = gen.getFrames();
        do {
            modified = false;
            for (i = 0; i < frames.size(); ++i) {
                qf2 = (QFrame)frames.get(i);
                modified |= qf2.hoist();
            }
        } while (modified);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("hoisted frame:\n" + qframe));
        }
        for (i = 0; i < frames.size(); ++i) {
            qf2 = (QFrame)frames.get(i);
            qf2.mergeOuter();
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("outers merged:\n" + qframe));
        }
        for (i = 0; i < frames.size(); ++i) {
            qf2 = (QFrame)frames.get(i);
            if (qf2.getParent() != null) continue;
            qf2.equifill();
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("eq/nn filled:\n" + qframe));
        }
        HashSet collapse = new HashSet();
        HashMap canon = new HashMap();
        do {
            collapse.clear();
            canon.clear();
            modified = false;
            for (int i4 = 0; i4 < frames.size(); ++i4) {
                qf = (QFrame)frames.get(i4);
                long st = System.currentTimeMillis();
                modified |= qf.innerize(collapse, canon);
            }
            if (!modified) continue;
            Iterator it = collapse.iterator();
            while (it.hasNext()) {
                EquiSet eq = (EquiSet)it.next();
                eq.collapse();
            }
        } while (modified);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("innerized frame:\n" + qframe));
        }
        Iterator it = gen.getFrames().iterator();
        while (it.hasNext()) {
            qf = (QFrame)it.next();
            qf.shrink();
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("shrunk frame:\n" + qframe));
        }
        Code sql = new Code("select ");
        Iterator it2 = this.m_names.iterator();
        while (it2.hasNext()) {
            String name2 = (String)it2.next();
            Expression e = this.get(name2);
            sql = sql.add(e.emit(gen)).add(" as \"").add(name2).add("\"");
            if (!it2.hasNext()) continue;
            sql = sql.add(",\n       ");
        }
        if (this.m_names.isEmpty()) {
            sql = sql.add("1 as dummy");
        }
        sql = sql.add("\nfrom ").add(qframe.emit(false, !oracle));
        Expression offset = qframe.getOffset();
        Expression limit = qframe.getLimit();
        if (oracle && (offset != null || limit != null)) {
            sql = new Code("select * from (select r__.*, rownum as ").add(ROWNUM).add(" from (").add(sql).add(") r__) where ");
            if (offset != null) {
                sql = sql.add(ROWNUM).add(" > ").add(offset.emit(gen));
            }
            if (limit != null) {
                if (offset != null) {
                    sql = sql.add(" and ");
                }
                sql = sql.add(ROWNUM);
                if (offset != null) {
                    sql = sql.add(" - ").add(offset.emit(gen));
                }
                sql = sql.add(" <= ").add(limit.emit(gen));
            }
        }
        if (this.m_query instanceof Size) {
            sql = new Code("select count(*) as \"size\" from (").add(sql).add(") count__");
        }
        LRUMap lRUMap = s_cache;
        synchronized (lRUMap) {
            if (s_log.isInfoEnabled()) {
                s_log.info((Object)("Query cache MISS. Cache size " + s_cache.size()));
                if (s_log.isDebugEnabled()) {
                    StringBuffer buf = new StringBuffer();
                    buf.append("Cache Key: ").append(gen.getStoreKey().toString());
                    buf.append("\nValue: ").append(sql);
                    buf.append("\nQuery: ").append(this.toString());
                    s_log.debug((Object)buf.toString());
                }
            }
            s_cache.put(gen.getStoreKey(), (Object)sql);
        }
        sql = sql.resolve(gen.getBindings(), root);
        return sql;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("query(");
        result.append(this.m_query);
        Iterator it = this.m_names.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            result.append(", ");
            result.append(name);
            result.append(" = ");
            result.append(this.get(name));
        }
        result.append(")");
        return result.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

