/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.oql;

import com.redhat.persistence.common.Path;
import com.redhat.persistence.common.SQL;
import com.redhat.persistence.common.SQLToken;
import com.redhat.persistence.metadata.Constraint;
import com.redhat.persistence.metadata.JoinFrom;
import com.redhat.persistence.metadata.JoinThrough;
import com.redhat.persistence.metadata.JoinTo;
import com.redhat.persistence.metadata.Mapping;
import com.redhat.persistence.metadata.ObjectType;
import com.redhat.persistence.metadata.Property;
import com.redhat.persistence.metadata.Qualias;
import com.redhat.persistence.metadata.Static;
import com.redhat.persistence.metadata.Value;
import com.redhat.persistence.oql.Code;
import com.redhat.persistence.oql.Condition;
import com.redhat.persistence.oql.Define;
import com.redhat.persistence.oql.Equals;
import com.redhat.persistence.oql.Expression;
import com.redhat.persistence.oql.Generator;
import com.redhat.persistence.oql.OQLParser;
import com.redhat.persistence.oql.ParseException;
import com.redhat.persistence.oql.QFrame;
import com.redhat.persistence.oql.QValue;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class Get
extends Expression {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/oql/Get.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$redhat$persistence$oql$Get == null ? (class$com$redhat$persistence$oql$Get = Get.class$("com.redhat.persistence.oql.Get")) : class$com$redhat$persistence$oql$Get));
    private Expression m_expr;
    private String m_name;
    private static ThreadLocal s_parsers = new ThreadLocal(){

        protected Object initialValue() {
            return new OQLParser(new StringReader(""));
        }
    };
    static /* synthetic */ Class class$com$redhat$persistence$oql$Get;

    public Get(Expression expr, String name) {
        this.m_expr = expr;
        this.m_name = name;
    }

    void frame(Generator gen) {
        this.m_expr.frame(gen);
        QFrame expr = gen.getFrame(this.m_expr);
        QFrame frame = Get.frame(gen, expr, this.m_name, this);
        frame.addChild(0, expr);
        Property prop = expr.getType().getProperty(this.m_name);
        if (!prop.isCollection()) {
            List children = frame.getChildren();
            for (int i = 1; i < children.size(); ++i) {
                QFrame child = (QFrame)children.get(i);
                child.setOuter(true);
            }
        }
    }

    Code emit(Generator gen) {
        return gen.getFrame(this).emit();
    }

    void hash(Generator gen) {
        this.m_expr.hash(gen);
        gen.hash(this.m_name);
        gen.hash(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static QFrame frame(Generator gen, QFrame expr, String name, Expression result) {
        Collection props;
        Mapping m;
        ObjectType type = expr.getType();
        Property prop = type.getProperty(name);
        if (prop == null) {
            throw new IllegalStateException("no such property: " + name);
        }
        QFrame frame = gen.frame(result, prop.getType());
        if (prop.getRoot() != null && (m = Code.getMapping(prop)) instanceof Qualias) {
            Expression e;
            Qualias q = (Qualias)m;
            String query = q.getQuery();
            OQLParser p = (OQLParser)s_parsers.get();
            p.ReInit(new StringReader(query));
            try {
                e = p.expression();
            }
            catch (ParseException pe) {
                throw new IllegalStateException(pe.getMessage());
            }
            ++gen.level;
            This ths = new This(expr);
            ths.frame(gen);
            gen.push(expr);
            gen.push(gen.getFrame(ths));
            try {
                e.frame(gen);
                QFrame qualias = gen.getFrame(e);
                frame.addChild(qualias);
                frame.setValues(qualias.getValues());
                gen.addUses(result, frame.getValues());
                QFrame qFrame = frame;
                return qFrame;
            }
            finally {
                --gen.level;
                gen.pop();
                gen.pop();
            }
        }
        if (expr.hasMappings()) {
            Path path = Path.get(prop.getName());
            Iterator it = expr.getMappings().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                Path key = (Path)me.getKey();
                String value = (String)me.getValue();
                if (!path.isAncestor(key)) continue;
                frame.addMapping(Path.relative(path, key), value);
            }
        }
        if (!(props = Code.properties(prop.getContainer())).contains(prop)) {
            String[] columns = null;
            String table = null;
            if (expr.hasMappings()) {
                columns = Code.columns(prop, expr);
            }
            if (columns == null) {
                columns = Code.columns(prop, (String)null);
                table = Code.table(prop);
            }
            if (table == null) {
                QFrame stframe = ((QValue)expr.getValues().get(0)).getFrame();
                ArrayList<QValue> values = new ArrayList<QValue>();
                for (int i = 0; i < columns.length; ++i) {
                    values.add(stframe.getValue(columns[i]));
                }
                frame.setValues(values);
            } else {
                TableAll tall = new TableAll(table, columns, prop.getType().getQualifiedName());
                tall.frame(gen);
                QFrame tbl = gen.getFrame(tall);
                PropertyCondition cond = new PropertyCondition(expr, prop, tbl);
                cond.frame(gen);
                tbl.setCondition(cond);
                frame.addChild(tbl);
                frame.setValues(tbl.getValues());
            }
        } else {
            Property p;
            int lower = 0;
            Iterator it = props.iterator();
            while (it.hasNext() && !(p = (Property)it.next()).equals(prop)) {
                lower += Code.span(p.getType());
            }
            List values = expr.getValues();
            int upper = lower + Code.span(prop.getType());
            frame.setValues(values.subList(lower, upper));
        }
        gen.addUses(result, frame.getValues());
        return frame;
    }

    public String toString() {
        if (this.m_expr instanceof Condition) {
            return "(" + this.m_expr + ")." + this.m_name;
        }
        return this.m_expr + "." + this.m_name;
    }

    String summary() {
        return "get " + this.m_name;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class TableAll
    extends Expression {
        private String m_table;
        private String[] m_columns;
        private String m_type;

        TableAll(String table, String[] columns, String type) {
            this.m_table = table;
            this.m_columns = columns;
            this.m_type = type;
        }

        void frame(Generator gen) {
            QFrame frame = gen.frame(this, gen.getType(this.m_type));
            frame.setValues(this.m_columns);
            frame.setTable(this.m_table);
        }

        Code emit(Generator gen) {
            return gen.getFrame(this).emit();
        }

        void hash(Generator gen) {
            throw new UnsupportedOperationException();
        }

        String summary() {
            return "tall: " + this.m_table;
        }
    }

    private static class This
    extends Expression {
        private QFrame m_frame;

        This(QFrame frame) {
            this.m_frame = frame;
        }

        void frame(Generator gen) {
            QFrame ths = gen.frame(this, Define.define("this", this.m_frame.getType()));
            ths.setValues(this.m_frame.getValues());
        }

        Code emit(Generator gen) {
            return gen.getFrame(this).emit();
        }

        void hash(Generator gen) {
            throw new UnsupportedOperationException();
        }

        String summary() {
            return "this";
        }
    }

    private static class Key
    extends Expression {
        private QFrame m_frame;
        private String[] m_columns;

        Key(QFrame frame, String[] columns) {
            this.m_frame = frame;
            this.m_columns = columns;
        }

        void frame(Generator gen) {
            QFrame frame = gen.frame(this, null);
            ArrayList<QValue> values = new ArrayList<QValue>();
            for (int i = 0; i < this.m_columns.length; ++i) {
                values.add(this.m_frame.getValue(this.m_columns[i]));
            }
            frame.setValues(values);
        }

        Code emit(Generator gen) {
            return gen.getFrame(this).emit();
        }

        void hash(Generator gen) {
            throw new UnsupportedOperationException();
        }

        String summary() {
            return this.toString();
        }

        public String toString() {
            return this.m_frame.alias() + Arrays.asList(this.m_columns);
        }
    }

    private static class PropertyCondition
    extends Condition {
        private QFrame m_expr;
        private Property m_property;
        private QFrame m_frame;
        private This m_this;
        private Key m_key = null;

        PropertyCondition(QFrame expr, Property property, QFrame frame) {
            this.m_expr = expr;
            this.m_property = property;
            this.m_frame = frame;
            this.m_this = new This(this.m_expr);
            this.conditions();
        }

        void frame(Generator gen) {
            if (this.m_key == null) {
                gen.addUses(this, this.m_expr.getValues());
                gen.addUses(this, this.m_frame.getValues());
                return;
            }
            this.m_this.frame(gen);
            this.m_key.frame(gen);
            QFrame ths = gen.getFrame(this.m_this);
            QFrame key = gen.getFrame(this.m_key);
            gen.addUses(this, ths.getValues());
            gen.addUses(this, key.getValues());
            Equals.equate(gen, this, ths, key);
        }

        Code emit(Generator gen) {
            if (this.m_key == null) {
                return this.emitStatic();
            }
            return Equals.emit(gen, this.m_this, this.m_key);
        }

        void hash(Generator gen) {
            throw new UnsupportedOperationException();
        }

        String summary() {
            return this.toString();
        }

        private Code emitStatic() {
            Mapping m = Code.getMapping(this.m_property);
            List values = this.m_expr.getValues();
            String[] from = new String[values.size()];
            for (int i = 0; i < from.length; ++i) {
                from[i] = "" + values.get(i);
            }
            Path[] paths = Code.paths(this.m_property.getType(), Path.get(this.m_property.getName()));
            String[] cols = Code.columns(paths, m.getRetrieve());
            Map bindings = Code.map(Code.paths(this.m_property.getContainer(), null), from);
            String[] to = Code.columns(this.m_property.getType(), this.m_frame.alias());
            StringBuffer in = new StringBuffer();
            in.append("(");
            for (int i = 0; i < to.length; ++i) {
                in.append(to[i]);
                if (i >= to.length - 1) continue;
                in.append(", ");
            }
            in.append(") in (");
            PropertyCondition.in(m.getRetrieve().getSQL(), cols, bindings, in);
            in.append(")");
            return new Code(in.toString());
        }

        static boolean is(SQLToken t, String image) {
            return t.getImage().trim().equalsIgnoreCase(image);
        }

        static void in(SQL sql, String[] columns, Map values, StringBuffer buf) {
            SQLToken t;
            boolean select = false;
            int depth = 0;
            HashMap<String, String> selections = new HashMap<String, String>();
            StringBuffer selection = new StringBuffer();
            String prefix = null;
            for (t = sql.getFirst(); t != null; t = t.getNext()) {
                if (depth == 0 && PropertyCondition.is(t, "select")) {
                    select = true;
                    continue;
                }
                if (depth == 0 && select && (PropertyCondition.is(t, ",") || PropertyCondition.is(t, "from"))) {
                    String trimmed;
                    String sel = selection.toString();
                    String match = null;
                    for (int i = 0; i < columns.length; ++i) {
                        if (!sel.trim().endsWith(columns[i])) continue;
                        if (match == null) {
                            match = columns[i];
                        } else if (columns[i].length() > match.length()) {
                            match = columns[i];
                        }
                        selections.put(match, sel);
                    }
                    if (match == null && !(trimmed = sel.trim()).equals("*") && trimmed.endsWith("*")) {
                        if (prefix != null) {
                            throw new IllegalStateException("multiple prefixes: " + sql);
                        }
                        prefix = trimmed.substring(0, trimmed.indexOf(46));
                    }
                    if (PropertyCondition.is(t, "from")) break;
                    selection = new StringBuffer();
                    continue;
                }
                if (PropertyCondition.is(t, "(")) {
                    ++depth;
                } else if (PropertyCondition.is(t, ")")) {
                    --depth;
                }
                selection.append(t.getImage());
            }
            buf.append("select ");
            for (int i = 0; i < columns.length; ++i) {
                String sel = (String)selections.get(columns[i]);
                if (sel == null) {
                    if (prefix != null) {
                        buf.append(prefix);
                        buf.append(".");
                    }
                    buf.append(columns[i]);
                } else {
                    buf.append(sel);
                }
                if (i >= columns.length - 1) continue;
                buf.append(", ");
            }
            buf.append(" ");
            while (t != null) {
                if (t.isBind()) {
                    Path key = Path.get(t.getImage().substring(1));
                    String value = (String)values.get(key);
                    if (value == null) {
                        throw new IllegalStateException("no value for: " + key + " in " + values);
                    }
                    buf.append(value);
                } else {
                    buf.append(t.getImage());
                }
                t = t.getNext();
            }
        }

        private void conditions() {
            Mapping m = Code.getMapping(this.m_property);
            if (m.getRetrieve() != null) {
                return;
            }
            m.dispatch(new Mapping.Switch(this){
                private final /* synthetic */ PropertyCondition this$0;
                {
                    this.this$0 = this$0;
                }

                public void onValue(Value v) {
                    PropertyCondition.access$000(this.this$0, v.getTable().getPrimaryKey());
                }

                public void onJoinTo(JoinTo j) {
                    PropertyCondition.access$000(this.this$0, j.getTable().getPrimaryKey());
                }

                public void onJoinFrom(JoinFrom j) {
                    PropertyCondition.access$000(this.this$0, j.getKey());
                }

                public void onJoinThrough(JoinThrough jt) {
                    PropertyCondition.access$000(this.this$0, jt.getFrom());
                }

                public void onStatic(Static s) {
                }
            });
        }

        private void conditions(Constraint c) {
            String[] columns = Code.columns(c, this.m_expr.getType(), null);
            this.m_key = new Key(this.m_frame, columns);
        }

        public String toString() {
            return this.emit(this.m_frame.getGenerator()).getSQL();
        }

        static /* synthetic */ void access$000(PropertyCondition x0, Constraint x1) {
            x0.conditions(x1);
        }
    }
}

