/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.oql;

import com.redhat.persistence.common.Path;
import com.redhat.persistence.metadata.Model;
import com.redhat.persistence.metadata.ObjectType;
import com.redhat.persistence.metadata.Role;
import com.redhat.persistence.oql.Code;
import com.redhat.persistence.oql.Expression;
import com.redhat.persistence.oql.Generator;
import com.redhat.persistence.oql.QFrame;
import java.util.Iterator;
import java.util.Map;

public class Define
extends Expression {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/oql/Define.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private Expression m_expr;
    private String m_name;

    public Define(Expression expr, String name) {
        this.m_expr = expr;
        this.m_name = name;
    }

    void frame(Generator gen) {
        this.m_expr.frame(gen);
        QFrame expr = gen.getFrame(this.m_expr);
        QFrame frame = gen.frame(this, Define.define(this.m_name, expr.getType()));
        frame.addChild(expr);
        frame.setValues(expr.getValues());
        if (expr.hasMappings()) {
            Iterator it = expr.getMappings().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                Path key = (Path)me.getKey();
                String value = (String)me.getValue();
                frame.addMapping(Path.add(this.m_name, key), value);
            }
        }
        gen.addUses(this, gen.getUses(this.m_expr));
    }

    Code emit(Generator gen) {
        return gen.getFrame(this).emit();
    }

    void hash(Generator gen) {
        this.m_expr.hash(gen);
        gen.hash(this.m_name);
        gen.hash(this.getClass());
    }

    public String toString() {
        return this.m_name + " = " + this.m_expr;
    }

    String summary() {
        return "define " + this.m_name;
    }

    static ObjectType define(final String name, final ObjectType type) {
        Model anon = Model.getInstance("anonymous.define");
        ObjectType result = new ObjectType(anon, type.getQualifiedName() + "$" + name, null){

            public String toString() {
                return "{" + type + " " + name + ";" + "}";
            }
        };
        Role prop = new Role(name, type, false, false, false);
        result.addProperty(prop);
        return result;
    }
}

