/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.metadata;

import com.arsdigita.db.DbHelper;
import com.redhat.persistence.metadata.Constraint;
import com.redhat.persistence.metadata.Element;
import com.redhat.persistence.metadata.Table;
import com.redhat.persistence.metadata.UniqueKey;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Column
extends Element {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/metadata/Column.java#10 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private String m_name;
    private int m_type;
    private int m_size;
    private int m_scale;
    private boolean m_isNullable = false;
    private Set m_constraints = new HashSet();
    private static final Map DEFAULT = new HashMap();
    private static final Map POSTGRES = new HashMap();
    private static final Map ORACLE = new HashMap();

    public Column(String columnName) {
        this(columnName, Integer.MIN_VALUE);
    }

    public Column(String columnName, int type) {
        this(columnName, type, -1);
    }

    public Column(String columnName, int type, int size) {
        this(columnName, type, size, -1);
    }

    public Column(String columnName, int type, int size, int scale) {
        this(columnName, type, size, scale, false);
    }

    public Column(String name, int type, int size, int scale, boolean isNullable) {
        this.m_name = name;
        this.m_type = type;
        this.m_size = size;
        this.m_scale = scale;
        this.m_isNullable = isNullable;
        if (this.m_size == 0) {
            throw new IllegalArgumentException("Size cannot be zero");
        }
    }

    void addConstraint(Constraint constraint) {
        this.m_constraints.add(constraint);
    }

    public Table getTable() {
        return (Table)this.getParent();
    }

    public String getName() {
        return this.m_name;
    }

    public String getTableName() {
        return this.getTable().getName();
    }

    public String getColumnName() {
        return this.getName();
    }

    public boolean isNullable() {
        return this.m_isNullable;
    }

    public void setNullable(boolean value) {
        this.m_isNullable = value;
    }

    public int getType() {
        return this.m_type;
    }

    public void setType(int type) {
        this.m_type = type;
    }

    public String getQualifiedName() {
        return this.getTableName() + "." + this.getColumnName();
    }

    public boolean isPrimaryKey() {
        return this.getTable().getPrimaryKey() == this.getTable().getUniqueKey(this);
    }

    public boolean isUniqueKey() {
        return this.getTable().getUniqueKey(this) != null;
    }

    public boolean isForeignKey() {
        return this.getTable().getForeignKey(this) != null;
    }

    void outputPDL(PrintStream out) {
        out.print(this.getTable().getName() + "." + this.m_name);
        if (this.m_type != Integer.MIN_VALUE) {
            out.print(" " + Column.getTypeName(this.m_type));
        }
        if (this.m_size > -1) {
            out.print("(" + this.m_size + ")");
        }
    }

    public static String getTypeName(int type) {
        switch (type) {
            case 2003: {
                return "ARRAY";
            }
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case 2004: {
                return "BLOB";
            }
            case 1: {
                return "CHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 0: {
                return "NULL";
            }
            case 2: {
                return "NUMERIC";
            }
            case 1111: {
                return "OTHER";
            }
            case 7: {
                return "REAL";
            }
            case 2006: {
                return "REF";
            }
            case 5: {
                return "SMALLINT";
            }
            case 2002: {
                return "STRUCT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
        }
        throw new IllegalArgumentException("No such jdbcType: " + type);
    }

    public int getSize() {
        return this.m_size;
    }

    public void setSize(int size) {
        this.m_size = size;
    }

    public int getScale() {
        return this.m_scale;
    }

    public void setScale(int scale) {
        this.m_scale = scale;
    }

    private static final String getDatabaseType(int type) {
        String result;
        Integer key = new Integer(type);
        switch (DbHelper.getDatabase()) {
            case 2: {
                if (!POSTGRES.containsKey(key)) break;
                return (String)POSTGRES.get(key);
            }
            default: {
                if (!ORACLE.containsKey(key)) break;
                return (String)ORACLE.get(key);
            }
        }
        if ((result = (String)DEFAULT.get(key)) == null) {
            throw new Error("Don't know how to translate " + Column.getTypeName(type) + " to database specific type.");
        }
        return result;
    }

    String getInlineSQL(boolean defer) {
        StringBuffer result = new StringBuffer();
        result.append("    " + this.m_name + " ");
        if (this.m_type != Integer.MIN_VALUE) {
            result.append(Column.getDatabaseType(this.m_type));
        } else {
            result.append("<unknown>");
        }
        if (this.m_size > -1) {
            if (this.m_scale > -1) {
                result.append("(" + this.m_size + "," + this.m_scale + ")");
            } else {
                result.append("(" + this.m_size + ")");
            }
        } else if (this.m_type == 12) {
            if (this.hasUniqueKey()) {
                result.append("(700)");
            } else {
                result.append("(4000)");
            }
        }
        if (!this.m_isNullable) {
            result.append(" not null");
        }
        if (DbHelper.getDatabase() == 1 && this.m_type == -7) {
            String name = Constraint.generateName(this.getTable(), Collections.singletonList(this), "_c");
            result.append("\n        constraint " + name);
            result.append("\n          check(" + this.m_name + " in ('0', '1'))");
        }
        Iterator it = this.m_constraints.iterator();
        while (it.hasNext()) {
            Constraint con = (Constraint)it.next();
            if (con.getColumns().length != 1 || defer && con.isDeferred()) continue;
            result.append("\n");
            result.append(con.getColumnSQL());
        }
        return result.toString();
    }

    boolean hasPrimaryKey() {
        Iterator it = this.m_constraints.iterator();
        while (it.hasNext()) {
            UniqueKey uk;
            Constraint con = (Constraint)it.next();
            if (!(con instanceof UniqueKey) || !(uk = (UniqueKey)con).isPrimaryKey()) continue;
            return true;
        }
        return false;
    }

    boolean hasUniqueKey() {
        Iterator it = this.m_constraints.iterator();
        while (it.hasNext()) {
            if (!(it.next() instanceof UniqueKey)) continue;
            return true;
        }
        return false;
    }

    boolean hasDeferredConstraints() {
        Iterator it = this.m_constraints.iterator();
        while (it.hasNext()) {
            Constraint con = (Constraint)it.next();
            if (con.getColumns().length != 1 || !con.isDeferred()) continue;
            return true;
        }
        return false;
    }

    Object getElementKey() {
        return this.getName();
    }

    public String getSQL() {
        return "alter table " + this.getTable().getName() + " add\n" + this.getInlineSQL(false);
    }

    public String toString() {
        return this.getTable() + "." + this.m_name;
    }

    static {
        DEFAULT.put(new Integer(2003), "ARRAY");
        DEFAULT.put(new Integer(-5), "BIGINT");
        ORACLE.put(new Integer(-5), "integer");
        DEFAULT.put(new Integer(-2), "BINARY");
        DEFAULT.put(new Integer(-7), "BIT");
        ORACLE.put(new Integer(-7), "CHAR(1)");
        POSTGRES.put(new Integer(-7), "BOOLEAN");
        DEFAULT.put(new Integer(2004), "BLOB");
        POSTGRES.put(new Integer(2004), "BYTEA");
        DEFAULT.put(new Integer(1), "CHAR");
        DEFAULT.put(new Integer(2005), "CLOB");
        POSTGRES.put(new Integer(2005), "TEXT");
        DEFAULT.put(new Integer(91), "DATE");
        DEFAULT.put(new Integer(3), "DECIMAL");
        DEFAULT.put(new Integer(2001), "DISTINCT");
        DEFAULT.put(new Integer(8), "DOUBLE");
        ORACLE.put(new Integer(8), "integer");
        DEFAULT.put(new Integer(6), "FLOAT");
        DEFAULT.put(new Integer(4), "INTEGER");
        DEFAULT.put(new Integer(2000), "JAVA_OBJECT");
        DEFAULT.put(new Integer(-4), "LONGVARBINARY");
        DEFAULT.put(new Integer(-1), "LONGVARCHAR");
        DEFAULT.put(new Integer(0), "NULL");
        DEFAULT.put(new Integer(2), "NUMERIC");
        DEFAULT.put(new Integer(1111), "OTHER");
        DEFAULT.put(new Integer(7), "REAL");
        DEFAULT.put(new Integer(2006), "REF");
        DEFAULT.put(new Integer(5), "SMALLINT");
        DEFAULT.put(new Integer(2002), "STRUCT");
        DEFAULT.put(new Integer(92), "TIME");
        DEFAULT.put(new Integer(93), "TIMESTAMP");
        ORACLE.put(new Integer(93), "DATE");
        POSTGRES.put(new Integer(93), "TIMESTAMPTZ");
        DEFAULT.put(new Integer(-6), "TINYINT");
        DEFAULT.put(new Integer(-3), "VARBINARY");
        DEFAULT.put(new Integer(12), "VARCHAR");
    }
}

