/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.engine.rdbms;

import com.redhat.persistence.common.Path;
import com.redhat.persistence.engine.rdbms.Environment;

class SpliceEnvironment
extends Environment {
    private Environment m_base;
    private Path m_path;
    private Environment m_splice;

    public SpliceEnvironment(Environment base, Path path, Environment splice) {
        super(base.getEngine(), null);
        this.m_base = base;
        this.m_path = path;
        this.m_splice = splice;
    }

    private Path unsplice(Path path) {
        return Path.get(":" + this.m_path.getRelative(path).getPath());
    }

    public boolean contains(Path path) {
        if (this.m_path.isAncestor(path)) {
            return this.m_splice.contains(this.unsplice(path));
        }
        return this.m_base.contains(path);
    }

    public void set(Path parameter, Object value) {
        if (this.m_path.isAncestor(parameter)) {
            this.m_splice.set(this.unsplice(parameter), value);
        } else {
            this.m_base.set(parameter, value);
        }
    }

    public void set(Path parameter, Object value, int type) {
        if (this.m_path.isAncestor(parameter)) {
            this.m_splice.set(this.unsplice(parameter), value, type);
        } else {
            this.m_base.set(parameter, value, type);
        }
    }

    public Object get(Path parameter) {
        if (this.m_path.isAncestor(parameter)) {
            return this.m_splice.get(this.unsplice(parameter));
        }
        return this.m_base.get(parameter);
    }

    public int getType(Path parameter) {
        if (this.m_path.isAncestor(parameter)) {
            return this.m_splice.getType(this.unsplice(parameter));
        }
        return this.m_base.getType(parameter);
    }

    public String toString() {
        return "<env " + this.m_base + " splice on " + this.m_path + " with " + this.m_splice + ">";
    }
}

