/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.engine.rdbms;

import com.arsdigita.util.WrappedError;
import com.redhat.persistence.Condition;
import com.redhat.persistence.Expression;
import com.redhat.persistence.SQLWriterException;
import com.redhat.persistence.common.ParseException;
import com.redhat.persistence.common.Path;
import com.redhat.persistence.common.SQL;
import com.redhat.persistence.common.SQLParser;
import com.redhat.persistence.common.SQLToken;
import com.redhat.persistence.engine.rdbms.CrossJoin;
import com.redhat.persistence.engine.rdbms.Delete;
import com.redhat.persistence.engine.rdbms.InnerJoin;
import com.redhat.persistence.engine.rdbms.Insert;
import com.redhat.persistence.engine.rdbms.Join;
import com.redhat.persistence.engine.rdbms.LeftJoin;
import com.redhat.persistence.engine.rdbms.Operation;
import com.redhat.persistence.engine.rdbms.RDBMSEngine;
import com.redhat.persistence.engine.rdbms.RightJoin;
import com.redhat.persistence.engine.rdbms.Select;
import com.redhat.persistence.engine.rdbms.SimpleJoin;
import com.redhat.persistence.engine.rdbms.StatementLifecycle;
import com.redhat.persistence.engine.rdbms.StaticJoin;
import com.redhat.persistence.engine.rdbms.StaticOperation;
import com.redhat.persistence.engine.rdbms.UnboundParameterException;
import com.redhat.persistence.engine.rdbms.Update;
import com.redhat.persistence.metadata.Adapter;
import com.redhat.persistence.metadata.Column;
import com.redhat.persistence.metadata.ObjectMap;
import com.redhat.persistence.metadata.Root;
import com.redhat.persistence.metadata.SQLBlock;
import com.redhat.persistence.oql.Code;
import java.io.StringReader;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public abstract class SQLWriter {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/engine/rdbms/SQLWriter.java#16 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private RDBMSEngine m_engine;
    private Operation m_op = null;
    private StringBuffer m_sql = new StringBuffer();
    private ArrayList m_bindings = new ArrayList();
    private ArrayList m_types = new ArrayList();
    private HashSet m_expanded = new HashSet();
    private final Expression.Switch m_esw = new Expression.Switch(){

        public void onCondition(Condition c) {
            SQLWriter.this.write(c);
        }

        public void onVariable(Expression.Variable v) {
            SQLWriter.this.write(v);
        }

        public void onValue(Expression.Value v) {
            SQLWriter.this.write(v);
        }

        public void onPassthrough(Expression.Passthrough p) {
            SQLWriter.this.write(p);
        }
    };
    private final Condition.Switch m_csw = new Condition.Switch(){

        public void onAnd(Condition.And a) {
            SQLWriter.this.write(a);
        }

        public void onOr(Condition.Or o) {
            SQLWriter.this.write(o);
        }

        public void onNot(Condition.Not n) {
            SQLWriter.this.write(n);
        }

        public void onEquals(Condition.Equals e) {
            SQLWriter.this.write(e);
        }

        public void onIn(Condition.In i) {
            SQLWriter.this.write(i);
        }

        public void onContains(Condition.Contains c) {
            SQLWriter.this.write(c);
        }
    };

    void setEngine(RDBMSEngine engine) {
        this.m_engine = engine;
    }

    public RDBMSEngine getEngine() {
        return this.m_engine;
    }

    public void clear() {
        this.m_op = null;
        this.m_sql = new StringBuffer();
        this.m_bindings.clear();
        this.m_types.clear();
        this.m_expanded.clear();
    }

    public String getSQL() {
        return this.m_sql.toString();
    }

    public Collection getBindings() {
        return this.m_bindings;
    }

    public Collection getTypes() {
        return this.m_types;
    }

    public Collection getTypeNames() {
        ArrayList<String> result = new ArrayList<String>();
        Iterator it = this.getTypes().iterator();
        while (it.hasNext()) {
            Integer type = (Integer)it.next();
            result.add(Column.getTypeName(type));
        }
        return result;
    }

    public void bind(PreparedStatement ps, StatementLifecycle cycle) {
        Root root = this.m_engine.getSession().getRoot();
        for (int i = 0; i < this.m_bindings.size(); ++i) {
            int index = i + 1;
            Object obj = this.m_bindings.get(i);
            int type = (Integer)this.m_types.get(i);
            try {
                if (cycle != null) {
                    cycle.beginSet(index, type, obj);
                }
                if (obj == null) {
                    ps.setNull(index, type);
                } else {
                    Adapter ad = root.getAdapter(obj.getClass());
                    ad.bind(ps, index, obj, type);
                }
                if (cycle == null) continue;
                cycle.endSet();
                continue;
            }
            catch (SQLException e) {
                if (cycle != null) {
                    cycle.endSet(e);
                }
                throw new WrappedError("SQL error binding [" + index + "] to " + obj, e);
            }
        }
    }

    public void write(String str) {
        this.m_sql.append(str);
    }

    public void write(Path path) {
        if (this.m_op == null) {
            throw new IllegalStateException("trying to write path outside of operation");
        }
        if (this.m_op.isParameter(path)) {
            if (!this.m_op.contains(path)) {
                throw new UnboundParameterException(path);
            }
            Object value = this.m_op.get(path);
            if (value instanceof Collection) {
                Collection c = (Collection)value;
                this.m_sql.append("(");
                Iterator it = c.iterator();
                while (it.hasNext()) {
                    Object o = it.next();
                    this.writeBind(o, this.m_op.getType(path));
                    if (!it.hasNext()) continue;
                    this.m_sql.append(", ");
                }
                this.m_sql.append(")");
            } else {
                this.writeBind(value, this.m_op.getType(path));
            }
        } else {
            this.m_sql.append(path);
        }
    }

    void writeBind(Object value, int jdbcType) {
        this.m_sql.append("?");
        this.m_bindings.add(value);
        this.m_types.add(new Integer(jdbcType));
    }

    void write(Code code) {
        this.write(code.getSQL());
        List bindings = code.getBindings();
        for (int i = 0; i < bindings.size(); ++i) {
            Code.Binding b = (Code.Binding)bindings.get(i);
            this.m_bindings.add(b.getValue());
            this.m_types.add(new Integer(b.getType()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Operation op) {
        Operation old = this.m_op;
        try {
            this.m_op = op;
            op.write(this);
        }
        finally {
            this.m_op = old;
        }
    }

    public void write(SQL sql) {
        this.write(sql.getFirst(), null);
    }

    public void write(SQL sql, boolean map) {
        this.write(sql.getFirst(), null, map);
    }

    public void write(SQLToken start, SQLToken end) {
        this.write(start, end, false);
    }

    public void write(SQLToken start, SQLToken end, boolean map) {
        Root r = this.m_engine.getSession().getRoot();
        for (SQLToken t = start; t != end; t = t.getNext()) {
            if (t.isRaw()) {
                String raw = t.getImage();
                this.write(raw.substring(4, raw.length() - 1));
                continue;
            }
            if (t.isBind()) {
                this.write(Path.get(t.getImage()));
                continue;
            }
            if (t.isPath() && r.hasObjectType(t.getImage())) {
                ObjectMap om = r.getObjectMap(r.getObjectType(t.getImage()));
                SQLBlock b = om.getRetrieveAll();
                if (b == null) continue;
                this.write(b.getSQL());
                continue;
            }
            if (t.isPath() && map) {
                Path p = Path.get(t.getImage());
                if (this.m_op.getMapping(p) != null) {
                    this.write(Expression.variable(p));
                    continue;
                }
                this.write(t.getImage());
                continue;
            }
            this.write(t.getImage());
        }
    }

    public void write(StaticOperation sop) {
        SQLBlock block = sop.getSQLBlock();
        SQL sql = block.getSQL();
        boolean first = true;
        boolean execute = false;
        SQLToken written = sql.getFirst();
        SQLToken firstBegin = null;
        Iterator it = block.getAssigns().iterator();
        while (it.hasNext()) {
            SQLBlock.Assign assign = (SQLBlock.Assign)it.next();
            boolean keep = true;
            List bindings = SQL.getBindings(assign.getBegin(), assign.getEnd());
            Iterator iter = bindings.iterator();
            while (iter.hasNext()) {
                Path p = (Path)iter.next();
                if (sop.contains(p)) continue;
                keep = false;
            }
            if (first) {
                first = false;
                firstBegin = assign.getBegin();
            }
            if (keep) {
                if (execute) {
                    this.write(",");
                } else {
                    this.write(sql.getFirst(), firstBegin);
                }
                execute = true;
                this.write(assign.getBegin(), assign.getEnd());
            }
            written = assign.getEnd();
        }
        if (execute || block.getAssigns().size() == 0) {
            this.write(written, null);
        }
    }

    public void write(Join join) {
        join.write(this);
    }

    public void write(Expression expr) {
        expr.dispatch(this.m_esw);
    }

    public void write(Condition cond) {
        cond.dispatch(this.m_csw);
    }

    public void write(Expression.Variable v) {
        if (this.m_expanded.contains(v)) {
            this.write(v.getPath());
        } else {
            Path[] cols = this.m_op.getMapping(v.getPath());
            if (cols == null) {
                throw new Error("no mapping: " + v);
            }
            if (cols.length != 1) {
                throw new Error("expands to wrong multiplicity");
            }
            this.write(cols[0]);
        }
    }

    public void write(Expression.Value v) {
        int type = RDBMSEngine.getType(this.getEngine().getSession().getRoot(), v.getValue());
        this.writeBind(v.getValue(), type);
    }

    public void write(Expression.Passthrough e) {
        SQLParser p = new SQLParser(new StringReader(e.getExpression()));
        try {
            p.sql();
        }
        catch (ParseException pe) {
            throw new WrappedError(pe);
        }
        this.write(p.getSQL(), true);
    }

    public void write(Condition.And cond) {
        this.write(cond.getLeft());
        this.write(" and ");
        this.write(cond.getRight());
    }

    public void write(Condition.Or cond) {
        this.write(cond.getLeft());
        this.write(" or ");
        this.write(cond.getRight());
    }

    public void write(Condition.Not cond) {
        this.write("not ");
        this.write(cond.getExpression());
    }

    public void write(Condition.In cond) {
        this.write(cond.getLeft());
        this.write(" in (");
        this.write(cond.getRight());
        this.write(")");
    }

    private boolean isExpandable(Expression expr) {
        return !this.m_expanded.contains(expr) && expr instanceof Expression.Variable || expr instanceof Expression.Value;
    }

    private Path[] expand(Expression expr) {
        final Path[][] result = new Path[][]{null};
        expr.dispatch(new Expression.Switch(){

            public void onVariable(Expression.Variable v) {
                if (SQLWriter.this.m_op.isParameter(v.getPath())) {
                    result[0] = new Path[]{v.getPath()};
                } else {
                    result[0] = SQLWriter.this.m_op.getMapping(v.getPath());
                    if (result[0] == null) {
                        throw new IllegalStateException("no expansion for expr: " + v);
                    }
                }
            }

            public void onValue(Expression.Value v) {
                throw new Error("not implemented");
            }

            public void onPassthrough(Expression.Passthrough p) {
                throw new Error("not implemented");
            }

            public void onCondition(Condition c) {
                throw new Error("not implemented");
            }
        });
        return result[0];
    }

    private Expression expand(Expression left, Expression right) {
        Path[] rightCols;
        if (!this.isExpandable(left)) {
            throw new IllegalArgumentException("not expandable: " + left);
        }
        if (!this.isExpandable(right)) {
            throw new IllegalArgumentException("not expandable: " + right);
        }
        Condition.Binary result = null;
        Path[] leftCols = this.expand(left);
        if (leftCols.length != (rightCols = this.expand(right)).length) {
            throw new SQLWriterException("left and right of different lengths\nleft expression: " + left + "; columns: " + Arrays.asList(leftCols) + "\n" + "right expression: " + right + "; columns: " + Arrays.asList(rightCols));
        }
        for (int i = 0; i < leftCols.length; ++i) {
            Expression.Variable l = Expression.variable(leftCols[i]);
            Expression.Variable r = Expression.variable(rightCols[i]);
            this.m_expanded.add(l);
            this.m_expanded.add(r);
            Condition.Equals eq = Condition.equals(l, r);
            result = result == null ? eq : Condition.and(result, eq);
        }
        return result;
    }

    private void writeLogicalEquals(Expression left, Expression right) {
        if (this.isExpandable(left) && this.isExpandable(right)) {
            this.write(this.expand(left, right));
        } else {
            this.writeEquals(left, right);
        }
    }

    void writeEquals(Expression left, Expression right) {
        this.write(left);
        this.write(" = ");
        this.write(right);
    }

    public void write(Condition.Equals cond) {
        this.writeLogicalEquals(cond.getLeft(), cond.getRight());
    }

    public void write(Condition.Contains cond) {
        this.writeLogicalEquals(cond.getLeft(), cond.getRight());
    }

    public abstract void write(Select var1);

    public abstract void write(Insert var1);

    public abstract void write(Update var1);

    public abstract void write(Delete var1);

    public abstract void write(StaticJoin var1);

    public abstract void write(SimpleJoin var1);

    public abstract void write(InnerJoin var1);

    public abstract void write(LeftJoin var1);

    public abstract void write(RightJoin var1);

    public abstract void write(CrossJoin var1);
}

