/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.engine.rdbms;

import com.redhat.persistence.AddEvent;
import com.redhat.persistence.Condition;
import com.redhat.persistence.CreateEvent;
import com.redhat.persistence.DeleteEvent;
import com.redhat.persistence.Event;
import com.redhat.persistence.ObjectEvent;
import com.redhat.persistence.PropertyEvent;
import com.redhat.persistence.PropertyMap;
import com.redhat.persistence.RemoveEvent;
import com.redhat.persistence.SetEvent;
import com.redhat.persistence.common.Path;
import com.redhat.persistence.engine.rdbms.DML;
import com.redhat.persistence.engine.rdbms.Delete;
import com.redhat.persistence.engine.rdbms.Environment;
import com.redhat.persistence.engine.rdbms.Insert;
import com.redhat.persistence.engine.rdbms.Mutation;
import com.redhat.persistence.engine.rdbms.RDBMSEngine;
import com.redhat.persistence.engine.rdbms.SpliceEnvironment;
import com.redhat.persistence.engine.rdbms.StaticOperation;
import com.redhat.persistence.engine.rdbms.Update;
import com.redhat.persistence.metadata.Adapter;
import com.redhat.persistence.metadata.Column;
import com.redhat.persistence.metadata.Constraint;
import com.redhat.persistence.metadata.JoinFrom;
import com.redhat.persistence.metadata.JoinThrough;
import com.redhat.persistence.metadata.JoinTo;
import com.redhat.persistence.metadata.Mapping;
import com.redhat.persistence.metadata.ObjectMap;
import com.redhat.persistence.metadata.ObjectType;
import com.redhat.persistence.metadata.Property;
import com.redhat.persistence.metadata.Qualias;
import com.redhat.persistence.metadata.Role;
import com.redhat.persistence.metadata.SQLBlock;
import com.redhat.persistence.metadata.Static;
import com.redhat.persistence.metadata.Table;
import com.redhat.persistence.metadata.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

class EventSwitch
extends Event.Switch {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/engine/rdbms/EventSwitch.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger LOG = Logger.getLogger((Class)(class$com$redhat$persistence$engine$rdbms$EventSwitch == null ? (class$com$redhat$persistence$engine$rdbms$EventSwitch = EventSwitch.class$("com.redhat.persistence.engine.rdbms.EventSwitch")) : class$com$redhat$persistence$engine$rdbms$EventSwitch));
    private static final Path KEY = Path.get("__key__");
    private static final Path KEY_FROM = Path.get("__key_from__");
    private static final Path KEY_TO = Path.get("__key_to__");
    private RDBMSEngine m_engine;
    static /* synthetic */ Class class$com$redhat$persistence$engine$rdbms$EventSwitch;

    public EventSwitch(RDBMSEngine engine) {
        this.m_engine = engine;
    }

    private static final Path getPath(Column column) {
        return Path.get(column.toString());
    }

    void flatten(Path prefix, Object obj, List paths, Map values) {
        LinkedList<Object> stack = new LinkedList<Object>();
        stack.add(prefix);
        stack.add(obj);
        while (stack.size() > 0) {
            Object o = stack.removeLast();
            Path p = (Path)stack.removeLast();
            Collection keys = null;
            if (o != null) {
                ObjectType type = this.m_engine.getSession().getObjectType(o);
                keys = type.getKeyProperties();
            }
            if (keys == null || keys.size() == 0) {
                paths.add(p);
                values.put(p, o);
                continue;
            }
            PropertyMap props = this.m_engine.getSession().getProperties(o);
            ArrayList revKeys = new ArrayList(keys.size());
            revKeys.addAll(keys);
            Collections.reverse(revKeys);
            Iterator it = revKeys.iterator();
            while (it.hasNext()) {
                Property key = (Property)it.next();
                if (p == null) {
                    stack.add(Path.get(key.getName()));
                } else {
                    stack.add(Path.get(p.getPath() + "." + key.getName()));
                }
                stack.add(props.get(key));
            }
        }
    }

    private void filter(Mutation mut, Constraint constraint, Path prefix, Object obj) {
        LinkedList paths = new LinkedList();
        HashMap values = new HashMap();
        this.flatten(prefix, obj, paths, values);
        Column[] cols = constraint.getColumns();
        int index = 0;
        Condition cond = mut.getCondition();
        Iterator it = paths.iterator();
        while (it.hasNext()) {
            Path p = (Path)it.next();
            Object o = values.get(p);
            Path col = EventSwitch.getPath(cols[index]);
            Condition.Equals eq = Condition.equals(col, p);
            mut.setMapping(col, new Path[]{col});
            cond = cond == null ? eq : Condition.and(eq, cond);
            mut.set(p, o, cols[index].getType());
            ++index;
        }
        mut.setCondition(cond);
    }

    private void set(DML op, Constraint constraint, Object obj) {
        this.set(op, constraint.getColumns(), obj);
    }

    private void set(DML op, Column[] cols, Object obj) {
        LinkedList paths = new LinkedList();
        HashMap values = new HashMap();
        this.flatten(null, obj, paths, values);
        int index = 0;
        Iterator it = paths.iterator();
        while (it.hasNext()) {
            Path p = (Path)it.next();
            Object o = values.get(p);
            op.set(cols[index++], o);
        }
    }

    private void set(Object obj, Constraint cons, Object arg) {
        this.set(obj, cons.getColumns(), arg);
    }

    private void set(Object obj, Column col, Object arg) {
        this.set(obj, new Column[]{col}, arg);
    }

    private void set(Object obj, Column[] cols, Object arg) {
        Table table = cols[0].getTable();
        DML op = this.m_engine.getOperation(obj, table);
        if (op == null) {
            if (!this.getTables(this.m_engine.getSession().getObjectMap(obj), false, true, false).contains(table)) {
                return;
            }
            Update up = new Update(this.m_engine, table, null);
            this.filter(up, table.getPrimaryKey(), KEY, obj);
            this.m_engine.addOperation(obj, up);
            this.m_engine.markUpdate(obj, up);
            op = up;
        }
        this.set(op, cols, arg);
    }

    private Collection getTables(ObjectMap om, boolean ins, boolean up, boolean del) {
        Collection tables = om.getTables();
        while (om != null) {
            if (ins && om.getDeclaredInserts() != null || up && om.getDeclaredUpdates() != null || del && om.getDeclaredDeletes() != null) {
                tables.removeAll(om.getDeclaredTables());
            }
            om = om.getSuperMap();
        }
        return tables;
    }

    private void addDML(Object obj, Collection tables, boolean insert) {
        Iterator it = tables.iterator();
        while (it.hasNext()) {
            Table table = (Table)it.next();
            if (insert) {
                Insert ins = new Insert(this.m_engine, table);
                this.set((DML)ins, (Constraint)table.getPrimaryKey(), obj);
                this.m_engine.addOperation(obj, ins);
                continue;
            }
            Delete del = new Delete(this.m_engine, table, null);
            this.filter(del, table.getPrimaryKey(), KEY, obj);
            this.m_engine.addOperation(obj, del);
        }
    }

    private List getObjectMaps(ObjectMap om) {
        if (om == null) {
            return new ArrayList();
        }
        List result = this.getObjectMaps(om.getSuperMap());
        result.add(om);
        return result;
    }

    private void onObjectEvent(ObjectEvent e) {
        Object obj = e.getObject();
        List oms = this.getObjectMaps(e.getObjectMap());
        if (e instanceof DeleteEvent) {
            Collections.reverse(oms);
        }
        if (e instanceof DeleteEvent) {
            this.m_engine.removeUpdates(obj);
        } else {
            if (this.m_engine.hasUpdates(obj)) {
                throw new IllegalStateException("updates exist for object being created");
            }
            this.m_engine.markUpdate(obj);
        }
        Iterator it = oms.iterator();
        while (it.hasNext()) {
            ObjectMap om = (ObjectMap)it.next();
            if (e instanceof CreateEvent) {
                if (om.getDeclaredInserts() != null) {
                    this.addOperations(obj, om.getDeclaredInserts());
                    continue;
                }
                this.addDML(obj, om.getDeclaredTables(), true);
                continue;
            }
            if (e instanceof DeleteEvent) {
                if (om.getDeclaredDeletes() != null) {
                    this.addOperations(obj, om.getDeclaredDeletes());
                    continue;
                }
                this.addDML(obj, om.getDeclaredTables(), false);
                continue;
            }
            throw new IllegalArgumentException("not a create or delete event");
        }
    }

    public void onCreate(CreateEvent e) {
        this.onObjectEvent(e);
    }

    public void onDelete(DeleteEvent e) {
        this.onObjectEvent(e);
    }

    private void onPropertyEvent(final PropertyEvent e) {
        final Object obj = e.getObject();
        final Object arg = e.getArgument();
        ObjectMap om = e.getObjectMap();
        Mapping m = om.getMapping(Path.get(e.getProperty().getName()));
        final Role role = (Role)e.getProperty();
        if (e instanceof AddEvent && m.getAdds() != null) {
            this.addOperations(obj, role, arg, m.getAdds());
            return;
        }
        if (e instanceof RemoveEvent && m.getRemoves() != null) {
            this.addOperations(obj, role, arg, m.getRemoves());
            return;
        }
        if (e instanceof SetEvent) {
            SetEvent se = (SetEvent)e;
            Object prev = se.getPreviousValue();
            if (prev != null && m.getRemoves() != null) {
                this.addOperations(obj, role, prev, m.getRemoves());
            }
            if (arg != null && m.getAdds() != null) {
                this.addOperations(obj, role, arg, m.getAdds());
            }
        }
        m.dispatch(new Mapping.Switch(){

            public void onQualias(Qualias q) {
            }

            public void onStatic(Static m) {
            }

            public void onValue(Value m) {
                Column col = m.getColumn();
                EventSwitch.this.set(obj, col, arg);
            }

            public void onJoinTo(JoinTo m) {
                EventSwitch.this.set(obj, m.getKey(), arg);
            }

            /*
             * WARNING - void declaration
             */
            public void onJoinFrom(JoinFrom m) {
                void var3_4;
                void var2_3;
                Object toSet;
                Object toNull;
                if (e instanceof SetEvent) {
                    SetEvent se = (SetEvent)e;
                    toNull = se.getPreviousValue();
                    toSet = arg;
                } else if (e instanceof RemoveEvent) {
                    toNull = arg;
                    toSet = null;
                } else if (e instanceof AddEvent) {
                    toNull = null;
                    toSet = arg;
                } else {
                    throw new IllegalArgumentException("expecting ProperyEvent");
                }
                if (var2_3 != null) {
                    EventSwitch.this.set(var2_3, m.getKey(), null);
                }
                if (var3_4 != null) {
                    EventSwitch.this.set(var3_4, m.getKey(), obj);
                }
            }

            public void onJoinThrough(JoinThrough m) {
                if (role.isReversable()) {
                    Role rev = role.getReverse();
                    if (role.getName().compareTo(rev.getName()) < 0) {
                        return;
                    }
                }
                if (e instanceof SetEvent) {
                    SetEvent se = (SetEvent)e;
                    Object prev = se.getPreviousValue();
                    if (prev != null) {
                        this.remove(m, obj, prev);
                    }
                    if (arg != null) {
                        this.add(m, obj, arg);
                    }
                } else if (e instanceof AddEvent) {
                    this.add(m, obj, arg);
                } else if (e instanceof RemoveEvent) {
                    this.remove(m, obj, arg);
                } else {
                    throw new IllegalArgumentException("not a set, add, or remove");
                }
            }

            private void add(JoinThrough m, Object obj2, Object arg2) {
                if (m.getAdds() == null) {
                    Table table = m.getFrom().getTable();
                    Insert ins = new Insert(EventSwitch.this.m_engine, table);
                    EventSwitch.this.set(ins, m.getFrom(), obj2);
                    EventSwitch.this.set(ins, m.getTo(), arg2);
                    EventSwitch.this.m_engine.addOperation(ins);
                }
            }

            private void remove(JoinThrough m, Object obj2, Object arg2) {
                if (m.getRemoves() == null) {
                    Table table = m.getFrom().getTable();
                    Delete del = new Delete(EventSwitch.this.m_engine, table, null);
                    EventSwitch.this.filter(del, m.getFrom(), KEY_FROM, obj2);
                    EventSwitch.this.filter(del, m.getTo(), KEY_TO, arg2);
                    EventSwitch.this.m_engine.addOperation(del);
                }
            }
        });
    }

    public void onSet(SetEvent e) {
        this.onPropertyEvent(e);
        Object obj = e.getObject();
        if (!this.m_engine.hasUpdates(obj)) {
            this.m_engine.markUpdate(obj);
            this.addOperations(obj, e.getObjectMap().getUpdates(), false);
        }
        Property prop = e.getProperty();
        Path path = Path.get(prop.getName());
        Environment env = this.m_engine.getEnvironment(obj);
        this.set(env, prop.getType(), e.getArgument(), path);
        this.scheduleMutation(e);
    }

    private void scheduleMutation(SetEvent e) {
        Property prop = e.getProperty();
        ObjectType type = prop.getType();
        if (type.isKeyed()) {
            return;
        }
        ObjectMap om = this.m_engine.getSession().getRoot().getObjectMap(prop.getContainer());
        Mapping m = om.getMapping(Path.get(prop.getName()));
        Adapter ad = this.m_engine.getSession().getRoot().getAdapter(type);
        final int[] jdbcType = new int[]{ad.defaultJDBCType()};
        m.dispatch(new Mapping.Switch(){

            public void onValue(Value v) {
                jdbcType[0] = v.getColumn().getType();
            }

            public void onStatic(Static st) {
            }

            public void onQualias(Qualias q) {
            }

            public void onJoinTo(JoinTo j) {
                throw new IllegalStateException("bad mapping");
            }

            public void onJoinFrom(JoinFrom j) {
                throw new IllegalStateException("bad mapping");
            }

            public void onJoinThrough(JoinThrough j) {
                throw new IllegalStateException("bad mapping");
            }
        });
        if (ad.isMutation(e.getArgument(), jdbcType[0])) {
            this.m_engine.scheduleMutation(e, jdbcType[0]);
        }
    }

    public void onAdd(AddEvent e) {
        this.onPropertyEvent(e);
    }

    public void onRemove(RemoveEvent e) {
        this.onPropertyEvent(e);
    }

    private void addOperations(Object obj, Collection blocks) {
        this.addOperations(obj, blocks, true);
    }

    private void addOperations(Object obj, Collection blocks, boolean initialize) {
        ObjectType type = this.m_engine.getSession().getObjectType(obj);
        Iterator it = blocks.iterator();
        while (it.hasNext()) {
            SQLBlock block = (SQLBlock)it.next();
            Environment env = this.m_engine.getEnvironment(obj);
            StaticOperation op = new StaticOperation(this.m_engine, block, env, initialize);
            this.set(env, type, obj, null);
            this.m_engine.addOperation(op);
            if (initialize) continue;
            this.m_engine.markUpdate(obj, op);
        }
    }

    private void addOperations(Object from, Property prop, Object to, Collection blocks) {
        Environment fromEnv = this.m_engine.getEnvironment(from);
        this.set(fromEnv, prop.getContainer(), from, null);
        Environment toEnv = this.m_engine.getEnvironment(to);
        this.set(toEnv, prop.getType(), to, null);
        Path path = Path.get(prop.getName());
        SpliceEnvironment env = new SpliceEnvironment(fromEnv, Path.get(":" + path.getPath()), toEnv);
        Role role = (Role)prop;
        if (role.isReversable()) {
            env = new SpliceEnvironment(env, Path.get(":" + role.getReverse().getName()), fromEnv);
        }
        Iterator it = blocks.iterator();
        while (it.hasNext()) {
            SQLBlock block = (SQLBlock)it.next();
            StaticOperation op = new StaticOperation(this.m_engine, block, env);
            this.m_engine.addOperation(op);
        }
    }

    private void set(Environment env, ObjectType type, Object obj, Path path) {
        if (!type.hasKey()) {
            env.set(Path.get(":" + path.getPath()), obj);
            return;
        }
        PropertyMap props = obj == null ? new PropertyMap(type) : this.m_engine.getSession().getProperties(obj);
        Iterator it = type.getKeyProperties().iterator();
        while (it.hasNext()) {
            Property key = (Property)it.next();
            Path keyPath = path == null ? Path.get(key.getName()) : Path.get(path.getPath() + "." + key.getName());
            this.set(env, key.getType(), props.get(key), keyPath);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

