/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.xmlinterp;

import com.arsdigita.xmlinterp.XMLInterpreter;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLWalker {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/xmlinterp/XMLWalker.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private final String TM = "#";
    private boolean trace = false;
    private XMLInterpreter xi;

    private void shift(String s1, String s2) {
        if (this.trace) {
            System.out.println("Tracing: shift " + s1 + " " + s2);
        }
        this.xi.shift(s1, s2);
    }

    private void push(Node n) {
        if (this.trace) {
            System.out.println("Tracing: push " + n.getNodeName());
        }
        this.xi.push(n);
    }

    private void reduce(String s) {
        if (this.trace) {
            System.out.println("Tracing: reduce " + s);
        }
        this.xi.reduce(s);
    }

    private void shiftAttributes(NamedNodeMap nm, String nn) {
        int il = nm.getLength();
        for (int i = 0; i < il; ++i) {
            Node n = nm.item(i);
            try {
                this.shift(n.getNodeName(), n.getNodeValue());
                continue;
            }
            catch (DOMException e) {
                System.out.println("Exception in attribute parser " + e.toString());
            }
        }
    }

    private void step(Node n) {
        boolean pureshift;
        NodeList nl = n.getChildNodes();
        String nn = n.getNodeName();
        int il = nl.getLength();
        boolean bl = pureshift = 1 == il && !n.hasAttributes();
        if (n.hasAttributes()) {
            this.push(n);
            this.shiftAttributes(n.getAttributes(), nn);
        }
        if (pureshift) {
            String v;
            Node fc = nl.item(0);
            try {
                v = fc.getNodeValue();
            }
            catch (DOMException e) {
                System.out.println("Caught exception; returning");
                return;
            }
            this.shift(nn, v);
            if (n.hasAttributes()) {
                this.reduce(nn);
            }
            return;
        }
        if (!n.hasAttributes()) {
            this.push(n);
        }
        for (int i = 0; i < il; ++i) {
            Node pn = nl.item(i);
            if (pn.getNodeName().startsWith("#")) continue;
            this.step(pn);
        }
        this.reduce(nn);
    }

    public void setTracing() {
        this.trace = true;
    }

    public void clearTracing() {
        this.trace = false;
    }

    public void walk(Document d, XMLInterpreter x) {
        Element elem = d.getDocumentElement();
        this.xi = x;
        this.step(elem);
    }
}

