/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.util;

import com.arsdigita.util.StringUtils;
import java.util.HashMap;
import java.util.Vector;
import org.apache.oro.text.perl.Perl5Util;

public class HtmlToText {
    private StringBuffer m_output;
    private boolean m_showtags = true;
    private int m_maxlen = 70;
    private int m_linelen;
    private int m_pre;
    private int m_p;
    private int m_br;
    private int m_space;
    private int m_blockquote;
    private static Perl5Util s_re = new Perl5Util();

    public HtmlToText() {
        this.reset();
    }

    public void setMaxLength(int maxlen) {
        if (maxlen > 0) {
            this.m_maxlen = maxlen;
        }
    }

    public void setShowTags(boolean showtags) {
        this.m_showtags = showtags;
    }

    public String toString() {
        return this.m_output.toString();
    }

    private void reset() {
        this.m_linelen = 0;
        this.m_pre = 0;
        this.m_p = 0;
        this.m_br = 0;
        this.m_space = 0;
        this.m_blockquote = 0;
        this.m_output = new StringBuffer();
    }

    private void putNewline() {
        this.m_output.append('\n');
        this.m_output.append(StringUtils.repeat("    ", this.m_blockquote));
        this.m_linelen = 0;
    }

    private static String expandEntities(String s) {
        s = s_re.substitute("s/&lt;/</gi", s);
        s = s_re.substitute("s/&gt;/>/gi", s);
        s = s_re.substitute("s/&quot;/'/gi", s);
        s = s_re.substitute("s/&mdash;/--/gi", s);
        s = s_re.substitute("s/&#151;/--/gi", s);
        return s_re.substitute("s/&amp;/&/gi", s);
    }

    private void put(String text) {
        text = HtmlToText.expandEntities(text);
        if (this.m_pre <= 0) {
            if ((text = s_re.substitute("s/\\s+/ /g", text)).equals(" ")) {
                this.m_space = 1;
                return;
            }
            if (text.equals("")) {
                return;
            }
            if (text.charAt(0) == ' ') {
                this.m_space = 1;
                text = StringUtils.trimleft(text);
            }
        } else {
            text = s_re.substitute("s/\r\n/\n/g", text);
            text = s_re.substitute("s/\r/\n/g", text);
            text = s_re.substitute("s/\t/    /g", text);
        }
        if (!(this.m_p == 0 && this.m_br == 0 && this.m_space == 0 || text.equals(""))) {
            if (this.m_p > 0) {
                this.putNewline();
                this.putNewline();
            } else if (this.m_br > 0) {
                this.putNewline();
            } else if (this.m_pre > 0 || this.m_linelen != 0) {
                this.m_output.append(' ');
                ++this.m_linelen;
            }
        }
        this.m_p = 0;
        this.m_br = 0;
        this.m_space = 0;
        if (s_re.match("/^(.*) $/", text)) {
            this.m_space = 1;
            text = s_re.group(1);
        }
        if (text.equals("")) {
            this.m_output.append(StringUtils.repeat("    ", this.m_blockquote));
        }
        while (s_re.match("/^( +|\\s|\\S+)/", text)) {
            String word = s_re.toString();
            text = s_re.postMatch();
            if ((word = s_re.substitute("s/&nbsp;/ /g", word)).equals("\n")) {
                if (this.m_output.length() <= 0) continue;
                this.putNewline();
                continue;
            }
            if (word.charAt(0) == ' ') {
                this.m_output.append(word);
                this.m_linelen += word.length();
                continue;
            }
            if (this.m_maxlen > 0 && this.m_linelen + word.length() > this.m_maxlen) {
                this.putNewline();
            }
            this.m_output.append(word);
            this.m_linelen += word.length();
        }
    }

    private static final HashMap parseAttributes(String html) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        int i = 0;
        int count = 0;
        while (i < html.length() && html.charAt(i) != '>') {
            String value;
            if (count++ > 100) {
                throw new RuntimeException("Infinite loop in HtmlToText.parseAttributes");
            }
            if (html.startsWith("/>", i)) break;
            if (!s_re.match("/\\s*([^\\s=>]+)\\s*(=?)\\s*/", html.substring(i))) {
                s_re.match("/[\\s=]*/", html.substring(i));
                i += s_re.end(0);
                continue;
            }
            String name = s_re.group(1).toLowerCase();
            i += s_re.end(0);
            if (s_re.group(2) == "") {
                attrs.put(name, null);
                continue;
            }
            String exp = html.charAt(i) == '\"' ? "/\"([^\"]*)\"\\s*/" : (html.charAt(i) == '\'' ? "/'([^']*)'\\s*/" : "/([^\\s>]*)\\s*/");
            if (!s_re.match(exp, html.substring(i))) {
                value = html.substring(i);
                i = html.length();
            } else {
                value = s_re.group(1);
                i += s_re.end(0);
            }
            attrs.put(name, HtmlToText.expandEntities(value));
        }
        return attrs;
    }

    public String convert(String input) {
        this.reset();
        Vector<String> hrefURLs = new Vector<String>();
        Vector<String> hrefStack = new Vector<String>();
        int lastTagEnd = 0;
        int i = input.indexOf(60);
        while (i != -1) {
            this.put(input.substring(lastTagEnd, i));
            int tagStart = ++i;
            int count = 0;
            while (true) {
                if (count++ > 100) {
                    throw new RuntimeException("HtmlToText: infinite loop");
                }
                int quoteIdx = input.indexOf(34, i);
                int apostropheIdx = input.indexOf(39, i);
                int gtIdx = input.indexOf(62, i);
                if (gtIdx == -1) {
                    i = input.length();
                    break;
                }
                int stringDelimiterIdx = Math.min(quoteIdx, apostropheIdx);
                if (gtIdx < stringDelimiterIdx || stringDelimiterIdx == -1) {
                    i = gtIdx;
                    break;
                }
                char stringDelimiter = input.charAt(stringDelimiterIdx);
                i = input.indexOf(stringDelimiter, ++stringDelimiterIdx);
                if (i == -1) {
                    i = input.length();
                    break;
                }
                ++i;
            }
            String fullTag = input.substring(tagStart, i);
            if (s_re.match("/(\\/?)([^\\s]+)/", fullTag)) {
                String slash = s_re.group(1);
                String tagname = s_re.group(2);
                String attributes = s_re.postMatch();
                if ((tagname = tagname.toLowerCase()).equals("p") || tagname.equals("ul") || tagname.equals("ol") || tagname.equals("table")) {
                    this.m_p = 1;
                } else if (tagname.equals("br")) {
                    this.putNewline();
                } else if (tagname.equals("tr") || tagname.equals("td") || tagname.equals("th")) {
                    this.m_br = 1;
                } else if (tagname.equals("h1") || tagname.equals("h2") || tagname.equals("h3") || tagname.equals("h4") || tagname.equals("h5") || tagname.equals("h6")) {
                    this.m_p = 1;
                    if (slash.equals("")) {
                        int level = Integer.valueOf(tagname.substring(1));
                        this.put(StringUtils.repeat("*", level));
                    }
                } else if (tagname.equals("li")) {
                    this.m_br = 1;
                    if (slash.equals("")) {
                        this.put("- ");
                    }
                } else if (tagname.equals("strong") || tagname.equals("b")) {
                    this.put("*");
                } else if (tagname.equals("em") || tagname.equals("i") || tagname.equals("cite") || tagname.equals("u")) {
                    this.put("_");
                } else if (tagname.equals("a")) {
                    if (slash.equals("")) {
                        HashMap attrs = HtmlToText.parseAttributes(attributes);
                        if (attrs.containsKey("href")) {
                            String title = attrs.containsKey("title") ? ": " + attrs.get("title") : "";
                            int n = hrefURLs.size() + 1;
                            hrefURLs.add("[" + n + "] " + attrs.get("href"));
                            hrefStack.add("[" + n + title + "]");
                        } else if (attrs.containsKey("title")) {
                            hrefStack.add("[" + attrs.get("title") + "]");
                        } else {
                            hrefStack.add("");
                        }
                    } else if (hrefStack.size() > 0) {
                        if (!((String)hrefStack.lastElement()).equals("")) {
                            this.put((String)hrefStack.lastElement());
                        }
                        hrefStack.removeAllElements();
                    }
                } else if (tagname.equals("pre")) {
                    this.m_p = 1;
                    this.m_pre = slash.equals("") ? ++this.m_pre : --this.m_pre;
                } else if (tagname.equals("blockquote")) {
                    this.m_p = 1;
                    if (slash.equals("")) {
                        ++this.m_blockquote;
                        this.m_maxlen -= 4;
                    } else {
                        --this.m_blockquote;
                        this.m_maxlen += 5;
                    }
                } else if (tagname.equals("hr")) {
                    this.m_p = 1;
                    this.put(StringUtils.repeat('-', this.m_maxlen));
                    this.m_p = 1;
                } else if (tagname.equals("q")) {
                    this.put("\"");
                } else if (tagname.equals("img")) {
                    if (slash.equals("")) {
                        HashMap attrs = HtmlToText.parseAttributes(attributes);
                        StringBuffer imgInfo = new StringBuffer();
                        if (attrs.containsKey("alt")) {
                            imgInfo.append('\'');
                            imgInfo.append((String)attrs.get("alt"));
                            imgInfo.append('\'');
                        }
                        if (attrs.containsKey("src")) {
                            imgInfo.append(' ');
                            imgInfo.append((String)attrs.get("src"));
                        }
                        if (imgInfo.length() == 0) {
                            this.put("[IMAGE]");
                        } else {
                            this.put("[IMAGE: " + imgInfo.toString() + "]");
                        }
                    }
                } else if (this.m_showtags) {
                    this.put("&lt;" + slash + tagname + attributes + "&gt;");
                }
            }
            lastTagEnd = ++i;
            i = input.indexOf(60, i);
        }
        this.put(input.substring(lastTagEnd));
        this.m_pre = 0;
        while (this.m_blockquote > 0) {
            --this.m_blockquote;
            this.m_maxlen += 4;
        }
        if (hrefURLs.size() > 0) {
            this.m_output.append("\n\n");
            for (i = 0; i < hrefURLs.size(); ++i) {
                this.m_output.append((String)hrefURLs.get(i));
                this.m_output.append("\n");
            }
        }
        if (this.m_output.charAt(this.m_output.length() - 1) != '\n') {
            this.m_output.append('\n');
        }
        return this.m_output.toString();
    }

    public static String generateHTMLText(String text, String formatType) {
        if (text == null) {
            return "";
        }
        if (formatType == null || "text/html".equals(formatType)) {
            return text;
        }
        if (formatType.equals("text/plain; format=preformatted")) {
            return "<pre>" + StringUtils.quoteHtml(text) + "</pre>";
        }
        if (formatType.equals("text/plain; format=smart")) {
            return StringUtils.smartTextToHtml(text);
        }
        return StringUtils.textToHtml(text);
    }
}

