/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.util;

import com.arsdigita.kernel.Kernel;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;

public final class Files {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/util/Files.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$util$Files == null ? (class$com$arsdigita$util$Files = Files.class$("com.arsdigita.util.Files")) : class$com$arsdigita$util$Files));
    public static final int OVERWRITE = 0;
    public static final int UPDATE = 1;
    public static final int IGNORE_EXISTING = 2;
    static /* synthetic */ Class class$com$arsdigita$util$Files;

    private Files() {
    }

    public static void delete(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                Files.delete(files[i]);
            }
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Deleting " + file.toString()));
        }
        file.delete();
    }

    public static void copy(File from, File to) throws IOException {
        Files.copy(from, to, 0);
    }

    public static void copy(File from, File to, int mode) throws IOException {
        if (to.isDirectory()) {
            to = new File(to, from.getName());
        }
        if (from.isDirectory()) {
            to.mkdir();
            if (!to.exists() || !to.isDirectory()) {
                throw new IOException("couldn't make directory: " + to);
            }
            File[] files = from.listFiles();
            if (files == null) {
                throw new IOException("could not read directory: " + from);
            }
            for (int i = 0; i < files.length; ++i) {
                Files.copy(files[i], to, mode);
            }
        } else {
            int bytes;
            File parent;
            if (to.exists()) {
                if (mode == 2) {
                    if (s_log.isDebugEnabled()) {
                        s_log.debug((Object)("Skipping copy of '" + from.toString() + "' because target exists."));
                    }
                    return;
                }
                if (mode == 1 && to.lastModified() > from.lastModified()) {
                    if (s_log.isDebugEnabled()) {
                        s_log.debug((Object)("Skipping copy of '" + from.toString() + "' because target is newer."));
                    }
                    return;
                }
                if (!to.canWrite()) {
                    throw new IOException("can not write file: " + to);
                }
            }
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Copying '" + from.toString() + "' to '" + to.toString() + "'"));
            }
            if ((parent = to.getParentFile()) != null && !parent.canWrite()) {
                throw new IOException("can not write to directory: " + parent);
            }
            if (!from.canRead()) {
                throw new IOException("can not read file: " + from);
            }
            FileInputStream is = new FileInputStream(from);
            FileOutputStream os = new FileOutputStream(to);
            byte[] buf = new byte[65536];
            while ((bytes = ((InputStream)is).read(buf)) >= 0) {
                ((OutputStream)os).write(buf, 0, bytes);
            }
            ((OutputStream)os).close();
            ((InputStream)is).close();
        }
    }

    public static void writeZipFile(String outputFileName, String[] includedFiles, File baseFile) {
        try {
            Files.writeZipFile(new FileOutputStream(outputFileName), includedFiles, baseFile);
        }
        catch (FileNotFoundException e) {
            s_log.error((Object)("Error creating the file output stream for file " + outputFileName), (Throwable)e);
        }
    }

    public static void writeZipFile(OutputStream outputStream, String[] fileList, File baseFile) {
        byte[] buffer = new byte[1024];
        try {
            ZipOutputStream out = new ZipOutputStream(outputStream);
            for (int i = 0; i < fileList.length; ++i) {
                File inputFile = new File(baseFile, fileList[i]);
                if (inputFile.isDirectory()) continue;
                FileInputStream in = new FileInputStream(inputFile);
                ZipEntry zipEntry = new ZipEntry(fileList[i]);
                out.putNextEntry(zipEntry);
                if (s_log.isDebugEnabled()) {
                    long compressed = zipEntry.getCompressedSize();
                    long original = zipEntry.getSize();
                    long ratio = (original - compressed) * 100L / original;
                    s_log.debug((Object)("Compressing file " + fileList[i] + "; original size = " + original + "; compressed = " + compressed + "; ratio = " + ratio));
                }
                int len = 0;
                while ((len = in.read(buffer)) > -1) {
                    out.write(buffer, 0, len);
                }
                out.closeEntry();
                in.close();
            }
            out.close();
        }
        catch (IOException e) {
            throw new UncheckedWrapperException("Error Creating the Zip File", e);
        }
    }

    public static String[] listFilesInTree(File baseDirectory, FilenameFilter filter) {
        return Files.listFilesInTree(baseDirectory, filter, new ArrayList(), null);
    }

    private static String[] listFilesInTree(File baseDirectory, FilenameFilter filter, Collection files, String prefix) {
        Assert.truth(baseDirectory.isDirectory(), "Base Directory must be a directory but is actually a file.");
        if (prefix != null && prefix.trim().length() == 0) {
            prefix = null;
        }
        File tempFile = null;
        String[] list = baseDirectory.list(filter);
        ArrayList<File> directories = new ArrayList<File>();
        for (int i = 0; i < list.length; ++i) {
            tempFile = new File(baseDirectory, list[i]);
            if (tempFile.isDirectory()) {
                directories.add(tempFile);
                continue;
            }
            if (prefix == null) {
                files.add(list[i]);
                continue;
            }
            files.add(prefix + File.separator + list[i]);
        }
        Iterator iter = directories.iterator();
        while (iter.hasNext()) {
            tempFile = (File)iter.next();
            if (prefix == null) {
                files.add(tempFile.getName());
                Files.listFilesInTree(tempFile, filter, files, tempFile.getName());
                continue;
            }
            String name = prefix + File.separator + tempFile.getName();
            files.add(name);
            Files.listFilesInTree(tempFile, filter, files, name);
        }
        return files.toArray(new String[0]);
    }

    public static String getPrettySize(File file) {
        if (file == null || !file.exists()) {
            return "0";
        }
        return Files.getPrettySize(file.length());
    }

    public static String getPrettySize(long longSize) {
        double d;
        double d2;
        Locale locale = Kernel.getContext().getLocale();
        NumberFormat nf = NumberFormat.getNumberInstance(locale);
        nf.setMaximumFractionDigits(0);
        double size = longSize;
        if (size < 1000.0) {
            return nf.format(size) + " b";
        }
        size = Files.byteToKilo(longSize);
        if (d2 < 1000.0) {
            return nf.format(size) + " kb";
        }
        nf.setMaximumFractionDigits(2);
        size = Files.byteToMega(longSize);
        if (d < 1000.0) {
            return nf.format(size) + " MB";
        }
        return nf.format(size) + " GB";
    }

    private static double byteToKilo(long size) {
        return (double)size / 1024.0;
    }

    private static double byteToMega(long size) {
        return (double)size / 1048576.0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

