/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.ui.login;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.form.Hidden;
import com.arsdigita.bebop.form.Password;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.parameters.URLParameter;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.KernelHelper;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.UserAuthentication;
import com.arsdigita.kernel.security.Initializer;
import com.arsdigita.kernel.security.RecoveryLoginModule;
import com.arsdigita.mail.Mail;
import com.arsdigita.ui.login.LoginHelper;
import com.arsdigita.ui.login.PasswordValidationListener;
import com.arsdigita.ui.login.UserAuthenticationListener;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.ReturnSignal;
import com.arsdigita.web.URL;
import com.arsdigita.web.Web;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class ChangePasswordForm
extends Form
implements FormProcessListener,
FormValidationListener {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/ui/login/ChangePasswordForm.java#14 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((String)(class$com$arsdigita$ui$login$ChangePasswordForm == null ? (class$com$arsdigita$ui$login$ChangePasswordForm = ChangePasswordForm.class$("com.arsdigita.ui.login.ChangePasswordForm")) : class$com$arsdigita$ui$login$ChangePasswordForm).getName());
    static final String CHANGE_PASSWORD_FORM_NAME = "change-password";
    static final String OLD_PASSWORD_PARAM_NAME = "old-password";
    static final String NEW_PASSWORD_PARAM_NAME = "new-password";
    static final String CONFIRM_PASSWORD_PARAM_NAME = "confirm-password";
    static final String RETURN_URL_PARAM_NAME = "return_url";
    private UserAuthenticationListener m_listener = new UserAuthenticationListener();
    private Hidden m_returnURL;
    private Hidden m_recovery;
    private Label m_oldPasswordLabel;
    private Password m_oldPassword;
    private Password m_newPassword;
    private Password m_confirmPassword;
    static /* synthetic */ Class class$com$arsdigita$ui$login$ChangePasswordForm;

    public ChangePasswordForm() {
        this(new BoxPanel());
    }

    public void register(Page p) {
        super.register(p);
        p.addRequestListener(this.m_listener);
        p.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState state = e.getPageState();
                boolean visible = !ChangePasswordForm.isRecovering();
                ChangePasswordForm.this.m_oldPasswordLabel.setVisible(state, visible);
                ChangePasswordForm.this.m_oldPassword.setVisible(state, visible);
            }
        });
    }

    public ChangePasswordForm(Container panel) {
        super(CHANGE_PASSWORD_FORM_NAME, panel);
        this.setMethod("post");
        this.addValidationListener(this);
        this.addProcessListener(this);
        this.m_recovery = new Hidden(new StringParameter(RecoveryLoginModule.getParamName()));
        this.m_recovery.setPassIn(true);
        this.add(this.m_recovery);
        this.m_returnURL = new Hidden(new URLParameter(RETURN_URL_PARAM_NAME));
        this.m_returnURL.setPassIn(true);
        this.add(this.m_returnURL);
        this.m_oldPasswordLabel = new Label(LoginHelper.getMessage("login.changePasswordForm.oldPasswordLabel"));
        this.add(this.m_oldPasswordLabel);
        this.m_oldPassword = new Password(OLD_PASSWORD_PARAM_NAME);
        this.add(this.m_oldPassword);
        Object[] params = new Object[]{new Integer(6)};
        this.add(new Label(LoginHelper.getMessage("login.changePasswordForm.newPasswordLabel", params)));
        this.m_newPassword = new Password(NEW_PASSWORD_PARAM_NAME);
        this.m_newPassword.addValidationListener(new PasswordValidationListener());
        this.add(this.m_newPassword);
        this.add(new Label(LoginHelper.getMessage("login.changePasswordForm.confirmPasswordLabel")));
        this.m_confirmPassword = new Password(CONFIRM_PASSWORD_PARAM_NAME);
        this.m_confirmPassword.addValidationListener(new NotNullValidationListener());
        this.add(this.m_confirmPassword);
        this.add(new Submit(LoginHelper.getMessage("login.changePasswordForm.submit")), 66);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void validate(FormSectionEvent event) throws FormProcessException {
        FormData data;
        PageState state;
        block15: {
            block16: {
                block14: {
                    block13: {
                        block11: {
                            block10: {
                                state = event.getPageState();
                                data = event.getFormData();
                                try {
                                    String confirmPassword;
                                    String newPassword;
                                    String oldPassword;
                                    block12: {
                                        if (!this.m_listener.isLoggedIn(state)) {
                                            data.addError(LoginHelper.localize("login.changePasswordForm.noUserError", state.getRequest()));
                                            Object var10_4 = null;
                                            if (data.isValid()) return;
                                            break block10;
                                        }
                                        User user = this.m_listener.getUser(state);
                                        oldPassword = (String)this.m_oldPassword.getValue(state);
                                        newPassword = (String)this.m_newPassword.getValue(state);
                                        confirmPassword = (String)this.m_confirmPassword.getValue(state);
                                        if (ChangePasswordForm.isRecovering()) break block12;
                                        try {
                                            if (oldPassword == null || !oldPassword.trim().equals(oldPassword)) {
                                                data.addError(OLD_PASSWORD_PARAM_NAME, LoginHelper.localize("login.changePasswordForm.badPasswordError", state.getRequest()));
                                                break block11;
                                            }
                                        }
                                        catch (DataObjectNotFoundException e) {
                                            throw new UncheckedWrapperException("Could not get UserAuthentication", e);
                                        }
                                        {
                                            UserAuthentication auth = UserAuthentication.retrieveForUser(user);
                                            if (auth.isValidPassword(oldPassword)) break block12;
                                            data.addError(OLD_PASSWORD_PARAM_NAME, LoginHelper.localize("login.changePasswordForm.badPasswordError", state.getRequest()));
                                        }
                                        break block13;
                                    }
                                    if (newPassword.equals(oldPassword)) {
                                        data.addError(NEW_PASSWORD_PARAM_NAME, LoginHelper.localize("login.changePasswordForm.mustDifferError", state.getRequest()));
                                        break block14;
                                    }
                                    if (newPassword.equals(confirmPassword)) break block15;
                                    data.addError(CONFIRM_PASSWORD_PARAM_NAME, LoginHelper.localize("login.changePasswordForm.mustMatchError", state.getRequest()));
                                    break block16;
                                }
                                catch (Throwable throwable) {
                                    Object var10_10 = null;
                                    if (data.isValid()) throw throwable;
                                    this.m_oldPassword.setValue(state, "");
                                    this.m_newPassword.setValue(state, "");
                                    this.m_confirmPassword.setValue(state, "");
                                    throw throwable;
                                }
                            }
                            this.m_oldPassword.setValue(state, "");
                            this.m_newPassword.setValue(state, "");
                            this.m_confirmPassword.setValue(state, "");
                            return;
                        }
                        Object var10_5 = null;
                        if (data.isValid()) return;
                        this.m_oldPassword.setValue(state, "");
                        this.m_newPassword.setValue(state, "");
                        this.m_confirmPassword.setValue(state, "");
                        return;
                    }
                    Object var10_6 = null;
                    if (data.isValid()) return;
                    this.m_oldPassword.setValue(state, "");
                    this.m_newPassword.setValue(state, "");
                    this.m_confirmPassword.setValue(state, "");
                    return;
                }
                Object var10_7 = null;
                if (data.isValid()) return;
                this.m_oldPassword.setValue(state, "");
                this.m_newPassword.setValue(state, "");
                this.m_confirmPassword.setValue(state, "");
                return;
            }
            Object var10_8 = null;
            if (data.isValid()) return;
            this.m_oldPassword.setValue(state, "");
            this.m_newPassword.setValue(state, "");
            this.m_confirmPassword.setValue(state, "");
            return;
        }
        Object var10_9 = null;
        if (data.isValid()) return;
        this.m_oldPassword.setValue(state, "");
        this.m_newPassword.setValue(state, "");
        this.m_confirmPassword.setValue(state, "");
    }

    public void process(FormSectionEvent event) throws FormProcessException {
        HttpServletRequest req;
        PageState state = event.getPageState();
        FormData data = event.getFormData();
        if (!this.m_listener.isLoggedIn(state)) {
            data.addError(LoginHelper.localize("login.changePasswordForm.noUserError", state.getRequest()));
            return;
        }
        User user = this.m_listener.getUser(state);
        try {
            UserAuthentication auth = UserAuthentication.retrieveForUser(user);
            String newPassword = (String)this.m_newPassword.getValue(state);
            auth.setPassword(newPassword);
            s_log.debug((Object)"committing password change");
            auth.save();
        }
        catch (DataObjectNotFoundException e) {
            throw new UncheckedWrapperException("Could not get UserAuthentication", e);
        }
        if (user.getPrimaryEmail() != null) {
            req = state.getRequest();
            String to = user.getPrimaryEmail().toString();
            String from = KernelHelper.getSystemAdministratorEmailAddress();
            String name = user.getPersonName().getGivenName();
            String subject = LoginHelper.localize("login.changePasswordForm.mailSubject", req);
            String body = LoginHelper.localize("login.changePasswordForm.mailBody", new Object[]{name}, req);
            try {
                Mail.send(to, from, subject, body);
            }
            catch (MessagingException e) {
                s_log.error((Object)"Could not notify user of password change", (Throwable)e);
            }
        } else {
            s_log.debug((Object)("Could not notify user of password change: null email, user ID: " + user.getID()));
        }
        req = state.getRequest();
        String path = Initializer.getFullURL(Initializer.WORKSPACE_PAGE_KEY, req);
        URL fallback = URL.there(req, path);
        throw new ReturnSignal(req, fallback);
    }

    private static boolean isRecovering() {
        return Web.getUserContext().isRecovering();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

