/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.ui.admin;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.Resettable;
import com.arsdigita.bebop.SegmentedPanel;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.TabbedPane;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.kernel.Group;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.UserAuthentication;
import com.arsdigita.kernel.security.Initializer;
import com.arsdigita.kernel.security.UserContext;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.ui.admin.AdminConstants;
import com.arsdigita.ui.admin.GroupAdministrationTab;
import com.arsdigita.ui.admin.PartyListModel;
import com.arsdigita.ui.admin.UserEditForm;
import com.arsdigita.ui.admin.UserInfo;
import com.arsdigita.ui.admin.UserPasswordForm;
import com.arsdigita.ui.admin.UserTableModelBuilder;
import com.arsdigita.util.LockableImpl;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.RedirectSignal;
import com.arsdigita.web.URL;
import com.arsdigita.web.Web;
import java.math.BigDecimal;
import java.util.ArrayList;
import javax.security.auth.login.LoginException;
import org.apache.log4j.Logger;

class UserBrowsePane
extends SegmentedPanel
implements TableCellRenderer,
TableActionListener,
Resettable,
ActionListener,
AdminConstants,
ChangeListener {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/ui/admin/UserBrowsePane.java#19 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$ui$admin$UserBrowsePane == null ? (class$com$arsdigita$ui$admin$UserBrowsePane = UserBrowsePane.class$("com.arsdigita.ui.admin.UserBrowsePane")) : class$com$arsdigita$ui$admin$UserBrowsePane));
    private Component m_userBrowsePanel;
    private Component m_userInfoPanel;
    private Component m_userEditPanel;
    private Component m_userPasswordPanel;
    private Component m_groupMembershipPanel;
    private Component m_actionPanel;
    private Component m_extremeActionPanel;
    private Component m_userDeleteFailedPanel;
    private GroupAdministrationTab m_groupAdministrationTab;
    private TabbedPane m_tabbedPane;
    private List m_groupList = null;
    private ArrayList m_panelList = new ArrayList();
    private RequestLocal m_user = new RequestLocal(){

        protected Object initialValue(PageState ps) {
            User user;
            BigDecimal id = (BigDecimal)ps.getValue(AdminConstants.USER_ID_PARAM);
            try {
                user = User.retrieve(id);
            }
            catch (DataObjectNotFoundException ex) {
                throw new UncheckedWrapperException("Failed to retrieve user: " + id);
            }
            return user;
        }
    };
    static /* synthetic */ Class class$com$arsdigita$ui$admin$UserBrowsePane;

    public void register(Page p) {
        for (int i = 0; i < this.m_panelList.size(); ++i) {
            p.setVisibleDefault((Component)this.m_panelList.get(i), false);
        }
        p.setVisibleDefault(this.m_userBrowsePanel, true);
        p.addActionListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        PageState ps = e.getPageState();
        Party party = Kernel.getContext().getParty();
        BigDecimal userID = (BigDecimal)ps.getValue(AdminConstants.USER_ID_PARAM);
        if (this.m_userInfoPanel.isVisible(ps)) {
            if (party.getID().equals(userID)) {
                this.m_extremeActionPanel.setVisible(ps, false);
            } else {
                this.m_extremeActionPanel.setVisible(ps, true);
            }
        }
    }

    public UserBrowsePane() {
        this.m_userBrowsePanel = this.buildUserBrowsePanel();
        this.m_panelList.add(this.m_userBrowsePanel);
        this.m_userInfoPanel = this.buildUserInfoPanel();
        this.m_panelList.add(this.m_userInfoPanel);
        this.m_userEditPanel = this.buildUserEditPanel();
        this.m_panelList.add(this.m_userEditPanel);
        this.m_userPasswordPanel = this.buildUserPasswordPanel();
        this.m_panelList.add(this.m_userPasswordPanel);
        this.m_groupMembershipPanel = this.buildGroupMembershipPanel();
        this.m_panelList.add(this.m_groupMembershipPanel);
        this.m_actionPanel = this.buildActionPanel();
        this.m_panelList.add(this.m_actionPanel);
        this.m_extremeActionPanel = this.buildExtremeActionPanel();
        this.m_panelList.add(this.m_extremeActionPanel);
        this.m_userDeleteFailedPanel = this.buildUserDeleteFailedPanel();
        this.m_panelList.add(this.m_userDeleteFailedPanel);
    }

    public User getUser(PageState ps) {
        return (User)this.m_user.get(ps);
    }

    private Component buildUserInfoPanel() {
        ActionLink link = new ActionLink(new Label(new GlobalizedMessage("ui.admin.user.editlink", "com.arsdigita.ui.admin.AdminResources")));
        link.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState ps = e.getPageState();
                UserBrowsePane.this.displayEditPanel(ps);
            }
        });
        link.setClassAttr("actionLink");
        BoxPanel p = new BoxPanel();
        p.add(new UserInfo(this));
        p.add(link);
        return this.addSegment(AdminConstants.USER_INFO_LABEL, (Component)p);
    }

    private Component buildUserEditPanel() {
        return this.addSegment(AdminConstants.USER_EDIT_PANEL_HEADER, (Component)new UserEditForm(this));
    }

    private Component buildUserPasswordPanel() {
        BoxPanel p = new BoxPanel();
        p.add(new UserPasswordForm(this));
        p.add(new SimpleContainer("admin:PasswordNote", "http://www.arsdigita.com/admin-ui/1.0"));
        return this.addSegment(AdminConstants.USER_PASSWORD_PANEL_HEADER, (Component)p);
    }

    private Component buildGroupMembershipPanel() {
        this.m_groupList = new List();
        this.m_groupList.setClassAttr("UserGroupsResultList");
        this.m_groupList.setModelBuilder(new GroupsModelBuilder());
        this.m_groupList.addChangeListener(this);
        return this.addSegment(AdminConstants.USER_GROUP_PANEL_HEADER, (Component)this.m_groupList);
    }

    private Component buildActionPanel() {
        BoxPanel p = new BoxPanel();
        ActionLink link = new ActionLink(AdminConstants.UPDATE_USER_PASSWORD_LABEL);
        link.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState ps = e.getPageState();
                UserBrowsePane.this.displayUserPasswordPanel(ps);
            }
        });
        link.setClassAttr("actionLink");
        p.add(link);
        link = new ActionLink(AdminConstants.BECOME_USER_LABEL);
        link.setClassAttr("actionLink");
        link.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState state = e.getPageState();
                BigDecimal id = (BigDecimal)state.getValue(AdminConstants.USER_ID_PARAM);
                try {
                    UserContext uc = Web.getUserContext();
                    uc.login(id);
                }
                catch (LoginException ex) {
                    throw new UncheckedWrapperException("access denied", ex);
                }
                String path = Initializer.getFullURL(Initializer.LOGIN_REDIRECT_PAGE_KEY, state.getRequest());
                URL url = URL.there(state.getRequest(), path);
                throw new RedirectSignal(url, true);
            }
        });
        p.add(link);
        link = new ActionLink(new Label(new GlobalizedMessage("ui.admin.user.browselink", "com.arsdigita.ui.admin.AdminResources")));
        link.setClassAttr("actionLink");
        link.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState ps = e.getPageState();
                UserBrowsePane.this.displayUserBrowsePanel(ps);
            }
        });
        p.add(link);
        return this.addSegment(AdminConstants.USER_ACTION_PANEL_HEADER, (Component)p);
    }

    private Component buildExtremeActionPanel() {
        ActionLink link = new ActionLink(AdminConstants.USER_DELETE_LABEL);
        link.setClassAttr("actionLink");
        link.setConfirmation(AdminConstants.USER_DELETE_CONFIRMATION.localize().toString());
        link.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState state = e.getPageState();
                User user = UserBrowsePane.this.getUser(state);
                try {
                    UserAuthentication.retrieveForUser(user).delete();
                }
                catch (DataObjectNotFoundException ex) {
                    // empty catch block
                }
                try {
                    user.delete();
                    UserBrowsePane.this.displayUserBrowsePanel(state);
                }
                catch (PersistenceException ex) {
                    s_log.error((Object)("Unable to delete user: " + ex.getMessage()));
                    UserBrowsePane.this.displayUserDeleteFailedPanel(state);
                }
            }
        });
        BoxPanel p = new BoxPanel();
        p.add(link);
        return this.addSegment(AdminConstants.USER_TAB_EXTREME_ACTION_LABEL, (Component)p);
    }

    private Component buildUserDeleteFailedPanel() {
        ActionLink link = new ActionLink(AdminConstants.USER_ACTION_CONTINUE);
        link.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState state = e.getPageState();
                UserBrowsePane.this.displayUserInfoPanel(state);
            }
        });
        Label label = new Label(AdminConstants.USER_DELETE_FAILED_MSG);
        label.setClassAttr("deleteFailedMessage");
        BoxPanel p = new BoxPanel();
        p.add(label);
        p.add(link);
        return this.addSegment(AdminConstants.USER_DELETE_FAILED_PANEL_HEADER, (Component)p);
    }

    private Component buildUserBrowsePanel() {
        Object[] headers = new String[]{"ID", "Name", "Screen Name", "Email"};
        Table table = new Table((TableModelBuilder)new UserTableModelBuilder(), headers);
        table.setClassAttr("AlternateTable");
        table.setDefaultCellRenderer(this);
        table.addTableActionListener(this);
        return this.addSegment(AdminConstants.BROWSE_USER_PANEL_HEADER, (Component)table);
    }

    void displayUserInfoPanel(PageState ps) {
        this.hideAll(ps);
        this.m_userInfoPanel.setVisible(ps, true);
        this.m_groupMembershipPanel.setVisible(ps, true);
        this.m_actionPanel.setVisible(ps, true);
        this.m_extremeActionPanel.setVisible(ps, true);
    }

    void displayEditPanel(PageState ps) {
        this.hideAll(ps);
        this.m_userEditPanel.setVisible(ps, true);
    }

    public void displayUserBrowsePanel(PageState ps) {
        this.hideAll(ps);
        this.m_userBrowsePanel.setVisible(ps, true);
    }

    public void displayUserPasswordPanel(PageState ps) {
        this.hideAll(ps);
        this.m_userPasswordPanel.setVisible(ps, true);
    }

    public void displayUserDeleteFailedPanel(PageState ps) {
        this.hideAll(ps);
        this.m_userDeleteFailedPanel.setVisible(ps, true);
    }

    private void hideAll(PageState ps) {
        for (int i = 0; i < this.m_panelList.size(); ++i) {
            ((Component)this.m_panelList.get(i)).setVisible(ps, false);
        }
    }

    public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int col) {
        if (col == 0) {
            ControlLink link = new ControlLink(value.toString());
            return link;
        }
        if (value != null) {
            return new Label(value.toString());
        }
        return new Label("&nbsp;", false);
    }

    public void cellSelected(TableActionEvent e) {
        PageState ps = e.getPageState();
        ps.setValue(AdminConstants.USER_ID_PARAM, new BigDecimal((String)e.getRowKey()));
        this.displayUserInfoPanel(ps);
    }

    public void headSelected(TableActionEvent e) {
    }

    public void reset(PageState ps) {
        this.displayUserBrowsePanel(ps);
    }

    public void setTabbedPane(TabbedPane tabbedPane) {
        this.m_tabbedPane = tabbedPane;
    }

    public void setGroupAdministrationTab(GroupAdministrationTab groupAdministrationTab) {
        this.m_groupAdministrationTab = groupAdministrationTab;
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.m_groupList && this.m_tabbedPane != null && this.m_groupAdministrationTab != null) {
            PageState ps = e.getPageState();
            String id = (String)this.m_groupList.getSelectedKey(ps);
            if (id != null) {
                Group group = null;
                try {
                    group = new Group(new BigDecimal(id));
                }
                catch (DataObjectNotFoundException exc) {
                    // empty catch block
                }
                this.m_groupAdministrationTab.setGroup(ps, group);
                this.m_groupAdministrationTab.displayGroupInfoPanel(ps);
                this.m_tabbedPane.setSelectedIndex(ps, 1);
            } else {
                this.reset(ps);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class GroupsModelBuilder
    extends LockableImpl
    implements ListModelBuilder,
    AdminConstants {
        private GroupsModelBuilder() {
        }

        public ListModel makeModel(List list, PageState state) {
            User user = UserBrowsePane.this.getUser(state);
            return new PartyListModel(user.getGroups());
        }
    }
}

