/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.toolbox.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.PaginationModelBuilder;
import com.arsdigita.bebop.Paginator;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.table.DefaultTableCellRenderer;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.bebop.table.TableColumnModel;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.domain.DomainCollection;
import com.arsdigita.domain.DomainServiceInterfaceExposer;
import com.arsdigita.toolbox.util.GlobalizationUtil;
import com.arsdigita.util.Assert;
import com.arsdigita.util.LockableImpl;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import java.util.ArrayList;

public abstract class AbstractCollectionTable
extends Table
implements PaginationModelBuilder {
    private RequestLocal m_collection;
    private ArrayList m_columnOrder;
    private RequestLocal m_querySize;
    private StringParameter m_dirParam;
    public static final String DIRECTION = "direction";
    public static final String ASCENDING = "asc";
    public static final String DESCENDING = "desc";

    public AbstractCollectionTable(RequestLocal collection) {
        this.m_collection = collection;
        this.m_columnOrder = new ArrayList();
        this.m_querySize = new RequestLocal();
        this.m_dirParam = new StringParameter(DIRECTION);
        this.setDefaultOrderDirection(ASCENDING);
        this.setModelBuilder(new TableModelBuilder(){

            public TableModel makeModel(Table t, PageState ps) {
                return AbstractCollectionTable.this.makeTableModel(ps);
            }

            public void lock() {
            }

            public boolean isLocked() {
                return true;
            }
        });
        this.addTableActionListener(new TableActionListener(){

            public void cellSelected(TableActionEvent evt) {
                AbstractCollectionTable.this.tableCellSelected(evt.getPageState(), evt.getRowKey(), evt.getColumn());
            }

            public void headSelected(TableActionEvent evt) {
                AbstractCollectionTable.this.tableHeadSelected(evt.getPageState(), evt.getColumn());
            }
        });
        this.setClassAttr("abstractCollectionTable");
    }

    public void register(Page p) {
        super.register(p);
        p.addComponentStateParam(this, this.m_dirParam);
    }

    public void setDefaultOrderDirection(String direction) {
        Assert.assertTrue(ASCENDING.equals(direction) || DESCENDING.equals(direction), "The order must be either ascending or descending");
        this.m_dirParam.setDefaultValue(direction);
    }

    public String getOrderDirection(PageState s) {
        return (String)s.getValue(this.m_dirParam);
    }

    public void setOrderDirection(PageState s, String dir) {
        Assert.assertTrue(ASCENDING.equals(dir) || DESCENDING.equals(dir));
        s.setValue(this.m_dirParam, dir);
    }

    public String toggleOrderDirection(PageState s) {
        String dir = this.getOrderDirection(s);
        dir = ASCENDING.equals(dir) ? DESCENDING : ASCENDING;
        this.setOrderDirection(s, dir);
        return dir;
    }

    public void setDefaultOrder(String attribute) {
        Assert.assertNotLocked(this);
        Assert.assertTrue(this.m_columnOrder.contains(attribute), "The passed in attribute '" + attribute + "' is not the name of a column.");
        this.getColumnSelectionModel().getStateParameter().setDefaultValue(new Integer(this.m_columnOrder.indexOf(attribute)));
    }

    public String getDefaultOrder() {
        return (String)this.m_columnOrder.get((Integer)this.getColumnSelectionModel().getStateParameter().getDefaultValue());
    }

    protected TableColumn addColumn(String label, String attribute, boolean isSortable, String type) {
        return this.addColumn(label, attribute, isSortable, new DefaultTableCellRenderer(), type);
    }

    protected TableColumn addColumn(String label, String attribute, boolean isSortable, TableCellRenderer renderer, String type) {
        TableColumnModel cols = this.getColumnModel();
        TableColumn col = new TableColumn(cols.size(), label, attribute);
        col.setCellRenderer(renderer);
        col.setHeaderRenderer(new AbstractTableCellRenderer(isSortable));
        cols.add(col);
        this.m_columnOrder.add(type);
        return col;
    }

    public BigDecimal getSelectedTask(PageState ps) {
        SingleSelectionModel ss = this.getRowSelectionModel();
        return new BigDecimal((String)ss.getSelectedKey(ps));
    }

    protected void tableCellSelected(PageState ps, Object key, int index) {
    }

    protected void tableHeadSelected(PageState ps, int index) {
    }

    public int getTotalSize(Paginator paginator, PageState s) {
        DomainCollection collection = this.getDomainCollection(s);
        BigDecimal size = (BigDecimal)this.m_querySize.get(s);
        if (size == null) {
            size = new BigDecimal((double)collection.size());
            this.m_querySize.set(s, (Object)size);
        }
        DomainServiceInterfaceExposer.getDataCollection(collection).setRange(new Integer(paginator.getFirst(s)), new Integer(paginator.getLast(s) + 1));
        return size.intValue();
    }

    public DomainCollection getDomainCollection(PageState state) {
        return (DomainCollection)this.m_collection.get(state);
    }

    protected String getColumnType(int index) {
        return (String)this.m_columnOrder.get(index);
    }

    protected abstract TableModel makeTableModel(PageState var1);

    public void generateExtraXMLAttributes(PageState state, Element element) {
        String dir;
        Integer index = (Integer)this.getColumnSelectionModel().getSelectedKey(state);
        if (index != null) {
            element.addAttribute("order", index.toString());
        }
        if ((dir = this.getOrderDirection(state)) != null) {
            element.addAttribute(DIRECTION, dir);
        }
    }

    private class AbstractTableCellRenderer
    extends LockableImpl
    implements TableCellRenderer {
        private boolean m_active;
        private ThreadLocal m_label;
        private ThreadLocal m_controlLink;

        AbstractTableCellRenderer(boolean isActive) {
            this.m_active = isActive;
            this.m_label = new ThreadLocal(this){
                private final /* synthetic */ AbstractTableCellRenderer this$1;
                {
                    this.this$1 = this$1;
                }

                protected Object initialValue() {
                    return new Label("");
                }
            };
            this.m_controlLink = new ThreadLocal(this){
                private final /* synthetic */ AbstractTableCellRenderer this$1;
                {
                    this.this$1 = this$1;
                }

                protected Object initialValue() {
                    return new ControlLink((Label)AbstractTableCellRenderer.access$000(this.this$1).get());
                }
            };
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            if (!this.isLocked() && table != null && table.isLocked()) {
                this.lock();
            }
            if (column == 0) {
                AbstractCollectionTable.this.setOrderDirection(state, AbstractCollectionTable.this.toggleOrderDirection(state));
            }
            if (value instanceof Component) {
                return (Component)value;
            }
            Label l = (Label)this.m_label.get();
            if (value == null) {
                l.setLabel((String)GlobalizationUtil.globalize("toolbox.ui.").localize());
                l.setOutputEscaping(false);
            } else {
                l.setLabel(value.toString());
                l.setOutputEscaping(true);
            }
            l.setFontWeight(isSelected && this.m_active ? "b" : null);
            if (this.m_active) {
                return (ControlLink)this.m_controlLink.get();
            }
            return l;
        }

        static /* synthetic */ ThreadLocal access$000(AbstractTableCellRenderer x0) {
            return x0.m_label;
        }
    }
}

