/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.search;

import com.arsdigita.search.Document;
import com.arsdigita.search.QuerySpecification;
import com.arsdigita.search.ResultSet;
import com.arsdigita.search.Search;
import java.util.Collections;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class CachedResultSet
implements ResultSet {
    private static Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$search$CachedResultSet == null ? (class$com$arsdigita$search$CachedResultSet = CachedResultSet.class$("com.arsdigita.search.CachedResultSet")) : class$com$arsdigita$search$CachedResultSet));
    private QuerySpecification m_spec;
    private long m_count;
    private long m_time;
    private Document[] m_results;
    private String m_engine;
    static /* synthetic */ Class class$com$arsdigita$search$CachedResultSet;

    public CachedResultSet(QuerySpecification spec, ResultSet results, int size) {
        this.m_spec = spec;
        this.m_time = results.getQueryTime();
        this.m_count = results.getCount();
        this.m_engine = results.getEngine();
        if (this.m_count < (long)size) {
            s_log.info((Object)("Cache size: " + size + ", is greater than result count: " + this.m_count));
            size = (int)this.m_count;
        }
        this.m_results = new Document[size];
        Iterator resultsIter = size == 0 ? Collections.EMPTY_LIST.iterator() : results.getDocuments(0L, size);
        int i = 0;
        while (resultsIter.hasNext() && i < size) {
            this.m_results[i++] = (Document)resultsIter.next();
        }
        if (i != size) {
            s_log.warn((Object)("Result count: " + i + ", was smaller than expected: " + size));
            size = i;
            Document[] cachedResults = new Document[size];
            for (i = 0; i < size; ++i) {
                cachedResults[i] = this.m_results[i];
            }
            this.m_results = cachedResults;
        }
        results.close();
    }

    public Iterator getDocuments(long offset, long count) {
        if (offset > this.m_count) {
            throw new IndexOutOfBoundsException("offset: " + offset + ",is greater than result count: " + this.m_count);
        }
        long last = offset + count;
        if (last > (long)this.m_results.length && last <= this.m_count) {
            s_log.info((Object)("Requested range: " + offset + "->" + (offset + count) + " is outsize cache size " + this.m_results.length));
            ResultSet results = Search.process(this.m_spec, Search.NOP_RESULT_CACHE, this.m_engine);
            return results.getDocuments(offset, count);
        }
        return new ResultIterator(this.m_results, (int)offset, (int)count);
    }

    public long getCount() {
        return this.m_count;
    }

    public String getEngine() {
        return this.m_engine;
    }

    public long getQueryTime() {
        return this.m_time;
    }

    public void close() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ResultIterator
    implements Iterator {
        private Document[] m_results;
        private int m_current;
        private int m_remaining;

        public ResultIterator(Document[] results, int offset, int count) {
            this.m_results = results;
            int remaining = this.m_results.length - offset;
            if (remaining < count) {
                count = remaining;
            }
            this.m_current = offset;
            this.m_remaining = count;
        }

        public boolean hasNext() {
            return this.m_remaining > 0;
        }

        public Object next() {
            Document result = this.m_results[this.m_current];
            ++this.m_current;
            --this.m_remaining;
            return result;
        }

        public void remove() {
            throw new UnsupportedOperationException("cannot remove search results");
        }
    }
}

