/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portal.apportlet;

import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ResourceType;
import com.arsdigita.portal.PortletSetup;
import com.arsdigita.portal.PortletType;
import com.arsdigita.portal.apportlet.AppPortletType;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Category;

public class AppPortletSetup
extends PortletSetup {
    protected boolean m_isPortalApplication = true;
    protected boolean m_isSingleton = false;

    public AppPortletSetup(Category category) {
        super(category);
    }

    public void setPortalApplication(boolean isPortalApplication) {
        this.m_isPortalApplication = isPortalApplication;
    }

    public void setSingleton(boolean isSingleton) {
        this.m_isSingleton = isSingleton;
    }

    public PortletType run() {
        this.notice("Validating setup...");
        List messages = this.validate();
        if (messages.size() > 0) {
            Iterator iter = messages.iterator();
            while (iter.hasNext()) {
                this.m_category.error((Object)((String)iter.next()));
            }
            return null;
        }
        this.notice("Done validating.");
        PortletType portletType = this.process();
        if (portletType != null) {
            portletType.save();
        }
        return portletType;
    }

    protected PortletType process() {
        this.notice("Starting setup...");
        AppPortletType portletType = null;
        if (!ResourceType.isInstalled(this.m_typeName)) {
            this.notice("Not installed.  Installing now...");
            this.notice("Using the following properties to perform install.");
            this.notice("  PortletObjectType: " + this.m_typeName);
            this.notice("  Title: " + this.m_title);
            this.notice("  Description: " + this.m_description);
            this.notice("  Profile: " + this.m_profile);
            this.notice("  Instantiator: " + this.m_instantiator);
            this.notice("  ProviderApplicationType: " + this.m_provider);
            this.notice("  Key: " + this.m_key);
            this.notice("  StyleSheet: " + this.m_stylesheet);
            this.notice("  IsPortalApplication: " + this.m_isPortalApplication);
            portletType = AppPortletType.createAppPortletType(this.m_title, this.m_profile, this.m_typeName);
            portletType.setDescription(this.m_description);
            if (this.m_provider != null) {
                portletType.setProviderApplicationType(this.m_provider);
            }
            portletType.setPortalApplication(this.m_isPortalApplication);
            this.notice("Done installing.");
        } else {
            portletType = AppPortletType.retrieveAppPortletTypeForAppPortlet(this.m_typeName);
        }
        DomainObjectFactory.registerInstantiator(this.m_typeName, this.m_instantiator);
        this.notice("Done setting up.");
        return portletType;
    }
}

