/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.persistence.pdl;

import com.arsdigita.persistence.pdl.PDLCompiler;
import com.arsdigita.persistence.pdl.PDLFilter;
import com.arsdigita.persistence.pdl.PDLSource;
import com.arsdigita.util.UncheckedWrapperException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class ZipSource
implements PDLSource {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/persistence/pdl/ZipSource.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private final ZipFile m_file;
    private final PDLFilter m_filter;

    public ZipSource(ZipFile file, PDLFilter filter) {
        this.m_file = file;
        this.m_filter = filter;
    }

    public void parse(PDLCompiler compiler) {
        Enumeration<? extends ZipEntry> entries = this.m_file.entries();
        HashSet<String> entrynames = new HashSet<String>();
        while (entries.hasMoreElements()) {
            entrynames.add(entries.nextElement().getName());
        }
        Collection accepted = this.m_filter.accept(entrynames);
        Iterator iter = accepted.iterator();
        while (iter.hasNext()) {
            try {
                String entryname = (String)iter.next();
                ZipEntry entry = new ZipEntry(entryname);
                if (entry.isDirectory()) continue;
                String name = entry.getName();
                compiler.parse(new InputStreamReader(this.m_file.getInputStream(entry)){

                    public void close() {
                    }
                }, name);
            }
            catch (IOException e) {
                throw new UncheckedWrapperException(e);
            }
            catch (IllegalStateException e) {
                throw new UncheckedWrapperException(e);
            }
        }
    }
}

