/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.persistence.pdl;

import com.arsdigita.db.DbHelper;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.MetadataRoot;
import com.arsdigita.persistence.pdl.PDL;
import com.arsdigita.persistence.pdl.PDLException;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.util.cmd.BooleanSwitch;
import com.arsdigita.util.cmd.CommandLine;
import com.arsdigita.util.cmd.PathSwitch;
import com.arsdigita.util.cmd.StringSwitch;
import com.redhat.persistence.metadata.Column;
import com.redhat.persistence.metadata.ObjectMap;
import com.redhat.persistence.metadata.ObjectType;
import com.redhat.persistence.metadata.Table;
import com.redhat.persistence.metadata.UniqueKey;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class SQLRegressionGenerator {
    static final CommandLine CMD = new CommandLine((class$com$arsdigita$persistence$pdl$PDL == null ? (class$com$arsdigita$persistence$pdl$PDL = SQLRegressionGenerator.class$("com.arsdigita.persistence.pdl.PDL")) : class$com$arsdigita$persistence$pdl$PDL).getName(), null);
    static /* synthetic */ Class class$com$arsdigita$persistence$pdl$PDL;

    public static final void main(String[] args) throws PDLException {
        BasicConfigurator.configure();
        HashMap options = new HashMap();
        args = CMD.parse(options, args);
        BasicConfigurator.configure();
        if (Boolean.TRUE.equals(options.get("-debug"))) {
            Logger.getRootLogger().setLevel(Level.DEBUG);
        } else if (Boolean.TRUE.equals(options.get("-verbose"))) {
            Logger.getRootLogger().setLevel(Level.INFO);
        } else if (Boolean.TRUE.equals(options.get("-quiet"))) {
            Logger.getRootLogger().setLevel(Level.ERROR);
        } else {
            Logger.getRootLogger().setLevel(Level.FATAL);
        }
        String database = (String)options.get("-database");
        if ("postgres".equalsIgnoreCase(database)) {
            DbHelper.setDatabase(2);
        } else {
            DbHelper.setDatabase(1);
        }
        List files = PDL.findPDLFiles((File[])options.get("-path"));
        files.addAll(Arrays.asList(args));
        if (files.size() < 1) {
            throw new PDLException(PDL.CMD.usage());
        }
        HashSet all = new HashSet();
        all.addAll(files);
        PDL.compilePDLFiles(all);
        SQLRegressionGenerator.generateSQL(files, options);
    }

    private static void generateSQL(List files, Map options) throws PDLException {
        String fixFile;
        MetadataRoot root = SessionManager.getSession().getMetadataRoot();
        com.arsdigita.persistence.metadata.ObjectType acsObject = root.getObjectType("com.arsdigita.kernel.ACSObject");
        String checkFile = (String)options.get("-check");
        if (checkFile != null) {
            FileOutputStream file = null;
            try {
                file = new FileOutputStream(checkFile);
            }
            catch (FileNotFoundException ex) {
                throw new UncheckedWrapperException("cannot find file " + checkFile, ex);
            }
            PrintStream out = new PrintStream(file);
            Iterator types = root.getObjectTypes().iterator();
            while (types.hasNext()) {
                com.arsdigita.persistence.metadata.ObjectType specificType = (com.arsdigita.persistence.metadata.ObjectType)types.next();
                if (!specificType.isSubtypeOf(acsObject)) continue;
                com.arsdigita.persistence.metadata.ObjectType type = specificType;
                do {
                    SQLRegressionGenerator.generateRowTest(specificType, type, out, false);
                } while ((type = type.getSupertype()) != null);
            }
        }
        if ((fixFile = (String)options.get("-fix")) != null) {
            FileOutputStream file = null;
            try {
                file = new FileOutputStream(fixFile);
            }
            catch (FileNotFoundException ex) {
                throw new UncheckedWrapperException("cannot find file " + fixFile, ex);
            }
            PrintStream out = new PrintStream(file);
            Iterator types = root.getObjectTypes().iterator();
            while (types.hasNext()) {
                com.arsdigita.persistence.metadata.ObjectType specificType = (com.arsdigita.persistence.metadata.ObjectType)types.next();
                if (!specificType.isSubtypeOf(acsObject)) continue;
                SQLRegressionGenerator.generateRowTest(specificType, specificType, out, true);
            }
        }
    }

    private static void generateRowTest(com.arsdigita.persistence.metadata.ObjectType specificType, com.arsdigita.persistence.metadata.ObjectType type, PrintStream out, boolean fix) {
        Column key;
        MetadataRoot root = SessionManager.getSession().getMetadataRoot();
        ObjectType protoType = root.getRoot().getObjectType(type.getQualifiedName());
        Assert.truth(protoType != null, "null proto type for " + type.getQualifiedName());
        try {
            ObjectMap objectMap = root.getRoot().getObjectMap(protoType);
            Table mdTable = objectMap.getTable();
            UniqueKey primaryKey = mdTable.getPrimaryKey();
            Column[] columns = primaryKey.getColumns();
            key = columns[0];
        }
        catch (NullPointerException e) {
            System.err.println("NPE for " + type.getQualifiedName());
            return;
        }
        if (key == null) {
            return;
        }
        String col = key.getName();
        String table = key.getTable().getName();
        if (fix) {
            out.println("select 'Deleting objects " + specificType.getQualifiedName() + " not present in " + table + "." + col + "' as check from dual;\n");
            out.println("delete from acs_objects \n where object_type = '" + specificType.getQualifiedName() + "'\n" + "   and not exists (\n" + "       select 1 \n" + "         from " + table + "\n" + "        where " + table + "." + col + " = acs_objects.object_id\n" + "       );\n\n\n");
        } else {
            out.println("select 'Verifying presence of " + specificType.getQualifiedName() + " objects in " + table + "." + col + "' as chk from dual;\n");
            out.println("select object_id, display_name\n  from acs_objects \n where object_type = '" + specificType.getQualifiedName() + "'\n" + "   and not exists (\n" + "       select 1 \n" + "         from " + table + "\n" + "        where " + table + "." + col + " = acs_objects.object_id\n" + "       );\n\n\n");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        CMD.addSwitch(new PathSwitch("-path", "PDL files appearing in this path will be processed", new File[0]));
        CMD.addSwitch(new StringSwitch("-check", "generate sql for checking objects and write it to the specified directory", null));
        CMD.addSwitch(new StringSwitch("-fix", "generate sql for fixing objects and write it to the specified directory", null));
        CMD.addSwitch(new BooleanSwitch("-debug", "sets logging to DEBUG", Boolean.FALSE));
        CMD.addSwitch(new BooleanSwitch("-verbose", "sets logging to INFO", Boolean.FALSE));
        CMD.addSwitch(new BooleanSwitch("-quiet", "sets logging to ERROR and does not complain if no PDL files are found", Boolean.FALSE));
        CMD.addSwitch(new StringSwitch("-database", "target database", null));
    }
}

