/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.persistence.pdl;

import com.arsdigita.persistence.pdl.PDLCompiler;
import com.arsdigita.persistence.pdl.PDLFilter;
import com.arsdigita.persistence.pdl.PDLSource;
import com.arsdigita.util.UncheckedWrapperException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;

public class DirSource
implements PDLSource {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/persistence/pdl/DirSource.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private final File m_dir;
    private final PDLFilter m_filter;
    private static final Comparator FILE_NAME = new Comparator(){

        public int compare(Object o1, Object o2) {
            File f1 = (File)o1;
            File f2 = (File)o2;
            return f1.getAbsolutePath().compareTo(f2.getAbsolutePath());
        }
    };

    public DirSource(File dir, PDLFilter filter) {
        this.m_dir = dir;
        this.m_filter = filter;
    }

    public void parse(PDLCompiler compiler) {
        this.parse(compiler, this.m_dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(PDLCompiler compiler, File dir) {
        File[] listing = dir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return !file.isDirectory();
            }
        });
        Arrays.sort(listing, FILE_NAME);
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < listing.length; ++i) {
            names.add(listing[i].getAbsolutePath());
        }
        Collection accepted = this.m_filter.accept(names);
        for (int i = 0; i < listing.length; ++i) {
            File file = listing[i];
            if (!accepted.contains(file.getAbsolutePath())) continue;
            try {
                FileReader reader = new FileReader(file);
                try {
                    compiler.parse(reader, file.getAbsolutePath());
                    continue;
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException e) {
                throw new UncheckedWrapperException(e);
            }
        }
        File[] subdirs = dir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        Arrays.sort(subdirs, FILE_NAME);
        for (int i = 0; i < subdirs.length; ++i) {
            this.parse(compiler, subdirs[i]);
        }
    }
}

