/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.mimetypes.image;

import java.awt.Dimension;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public abstract class ImageSizer {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/mimetypes/image/ImageSizer.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$mimetypes$image$ImageSizer == null ? (class$com$arsdigita$mimetypes$image$ImageSizer = ImageSizer.class$("com.arsdigita.mimetypes.image.ImageSizer")) : class$com$arsdigita$mimetypes$image$ImageSizer));
    static /* synthetic */ Class class$com$arsdigita$mimetypes$image$ImageSizer;

    protected ImageSizer() {
    }

    public Dimension computeImageSize(String path) throws IOException {
        FilterInputStream in = null;
        Dimension size = null;
        try {
            in = new DataInputStream(new FileInputStream(path));
            size = this.computeSize((DataInputStream)in);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            in.close();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Dimension computeImageSize(File file) throws IOException {
        DataInputStream in = null;
        Dimension size = null;
        try {
            in = new DataInputStream(new FileInputStream(file));
            size = this.computeSize(in);
            Object var5_4 = null;
            if (in == null) return size;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                s_log.error((Object)"Couldn't close input stream", (Throwable)e);
            }
            throw throwable;
        }
        try {
            in.close();
            return size;
        }
        catch (IOException e) {
            s_log.error((Object)"Couldn't close input stream", (Throwable)e);
        }
        return size;
    }

    public static Dimension getScaledSize(Dimension d, int maxWidth, int maxHeight) {
        return ImageSizer.getScaledSize((int)d.getWidth(), (int)d.getHeight(), maxWidth, maxHeight);
    }

    public static Dimension getScaledSize(int width, int height, int maxWidth, int maxHeight) {
        if (width <= maxWidth && height <= maxHeight) {
            return new Dimension(width, height);
        }
        double widthFactor = (double)width / (double)maxWidth;
        double heightFactor = (double)height / (double)maxHeight;
        double scaleFactor = widthFactor > heightFactor ? widthFactor : heightFactor;
        int scaleWidth = (int)((double)width / scaleFactor);
        int scaleHeight = (int)((double)height / scaleFactor);
        return new Dimension(scaleWidth, scaleHeight);
    }

    public abstract Dimension computeSize(DataInputStream var1) throws IOException;

    protected static short toShort(byte highOrder, byte lowOrder) {
        short result = highOrder;
        result = (short)(result << 8);
        result = (short)(result & 0x7F00);
        short low = lowOrder;
        low = (short)(low & 0xFF);
        result = (short)(result | low);
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

