/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.mimetypes.image;

import com.arsdigita.mimetypes.image.ImageSizer;
import java.awt.Dimension;
import java.io.DataInputStream;
import java.io.IOException;

public class GIFImageSizer
extends ImageSizer {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/mimetypes/image/GIFImageSizer.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final String GIF_MARKER_87 = "GIF87a";
    private static final String GIF_MARKER_89 = "GIF89a";

    protected GIFImageSizer() {
    }

    public Dimension computeSize(DataInputStream in) throws IOException {
        byte[] data = new byte[10];
        if (in.read(data) < 10) {
            return null;
        }
        String head = new String(data, 0, 6);
        if (GIF_MARKER_87.equals(head) || GIF_MARKER_89.equals(head)) {
            short width = ImageSizer.toShort(data[7], data[6]);
            short height = ImageSizer.toShort(data[9], data[8]);
            return new Dimension(width, height);
        }
        return null;
    }
}

