/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.messaging;

import org.apache.oro.text.perl.Perl5Util;

public class SortKey {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/messaging/SortKey.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    char[] m_sortkey;
    private static final int CHARS_PER_LEVEL = 3;
    private static final String ZERO = "000";
    private static final String INVALID_SORTKEY_PATTERN = "/[^a-zA-Z0-9]+/";

    public SortKey() {
        this.m_sortkey = ZERO.toCharArray();
    }

    public SortKey(String sortkey) {
        this.m_sortkey = sortkey.toCharArray();
        this.validate();
    }

    public SortKey(SortKey parent) {
        this(parent.getChild().toString());
    }

    public SortKey getChild() {
        return new SortKey(this.toString() + ZERO);
    }

    public SortKey getParent() {
        return new SortKey(new String(this.m_sortkey, 0, this.m_sortkey.length - 3));
    }

    public String toString() {
        return new String(this.m_sortkey);
    }

    public int getDepth() {
        return this.m_sortkey.length / 3;
    }

    public int length() {
        return this.m_sortkey.length;
    }

    public void next() {
        this.incr(this.m_sortkey.length - 1);
    }

    private void incr(int pos) {
        char c = this.m_sortkey[pos];
        this.m_sortkey[pos] = this.nextChar(c);
        if (c == 'z') {
            this.incr(pos - 1);
        }
    }

    private char nextChar(char c) {
        char n;
        switch (c) {
            case '9': {
                n = 'A';
                break;
            }
            case 'Z': {
                n = 'a';
                break;
            }
            case 'z': {
                n = '0';
                break;
            }
            default: {
                n = (char)(c + '\u0001');
            }
        }
        return n;
    }

    public int intValue() {
        int value = 0;
        for (int i = 0; i < this.m_sortkey.length; ++i) {
            value = 62 * value + this.decode(this.m_sortkey[i]);
        }
        return value;
    }

    private int decode(char c) {
        if (c <= '9') {
            return c - 48;
        }
        if (c <= 'Z') {
            return c - 65 + 10;
        }
        return c - 97 + 36;
    }

    private void validate() {
        if (this.m_sortkey.length % 3 != 0) {
            throw new IllegalArgumentException("invalid sort key: length is not a multiple of 3");
        }
        Perl5Util util = new Perl5Util();
        if (util.match(INVALID_SORTKEY_PATTERN, this.toString())) {
            throw new IllegalArgumentException("invalid sort key: illegal characters: " + this.toString());
        }
    }
}

