/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.mail;

import com.arsdigita.mail.Response;
import com.arsdigita.mail.ServerModes;
import com.arsdigita.mail.SimpleServer;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.SocketException;
import javax.mail.MessagingException;
import javax.mail.internet.MimeUtility;

final class SocketHandler
extends Thread
implements ServerModes {
    private int m_mode;
    private Socket m_sock;
    private BufferedReader m_is;
    private DataOutputStream m_os;
    private boolean m_serving = true;
    private static final int HANGING_TIMEOUT = 30000;
    private static final String ENCODING = "iso-8859-1";
    private static final String GREETING = "220 Welcome, server waiting";
    private static Response[] responses = new Response[]{new Response("HELO", "250"), new Response("EHLO", "250"), new Response("MAIL FROM", "250"), new Response("RCPT TO", "250"), new Response("DATA", "354"), new Response(".", "250"), new Response("QUIT", "221", true)};
    private static String[] error = new String[]{"421 Service not available, shutdown transmission line", "450 mailbox unavailable", "451 requested action aborted", "452 requested action not taken, insufficient system storage", "500 syntax error, command unrecognized", "501 syntax error in parameters or arguments", "502 command not implemented", "550 no such user", "554 transaction failed"};

    public SocketHandler(Socket sock, int mode) {
        this.m_sock = sock;
        this.m_mode = mode;
        try {
            this.m_os = new DataOutputStream(this.m_sock.getOutputStream());
            this.m_is = new BufferedReader(new InputStreamReader(MimeUtility.decode((InputStream)this.m_sock.getInputStream(), (String)ENCODING)));
        }
        catch (MessagingException me) {
            try {
                this.m_is = new BufferedReader(new InputStreamReader(this.m_sock.getInputStream()));
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void run() {
        try {
            this.writeln(GREETING);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        try {
            while (this.m_serving && this.respond()) {
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        SimpleServer.incrReceivedCount();
        SimpleServer.incrSuccessCount();
        try {
            this.m_os.close();
            this.m_is.close();
            this.m_sock.close();
        }
        catch (IOException ic) {
            ic.printStackTrace();
        }
    }

    private void close() {
        this.m_serving = false;
    }

    public boolean respond() throws IOException, SocketException {
        String line = null;
        try {
            line = this.m_is.readLine();
        }
        catch (Exception e) {
            return false;
        }
        if (this.m_mode == 0) {
            for (int i = 0; i < responses.length; ++i) {
                if (responses[i].isValid(line)) {
                    try {
                        this.writeln(responses[i].getSend());
                        break;
                    }
                    catch (IOException ioe) {
                        if (!responses[i].allowClosed()) {
                            throw ioe;
                        }
                        break;
                    }
                }
                if (!line.startsWith("QUIT")) continue;
                return false;
            }
        } else {
            this.fail();
        }
        return true;
    }

    private void writeln(String s) throws IOException {
        this.m_os.writeBytes(s);
        this.m_os.writeChar(10);
        this.m_os.flush();
    }

    public void fail() throws IOException {
        switch (this.m_mode) {
            case 1: {
                this.close();
                break;
            }
            case 2: {
                try {
                    SocketHandler.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {}
                break;
            }
            case 3: {
                this.writeln(error[0]);
                break;
            }
            case 4: {
                this.writeln(error[2]);
                break;
            }
            case 5: {
                this.writeln(error[3]);
                break;
            }
            case 6: {
                this.writeln(error[4]);
                break;
            }
            case 7: {
                this.writeln(error[5]);
                break;
            }
            case 8: {
                this.writeln(error[6]);
                break;
            }
            case 9: {
                this.writeln(error[8]);
            }
        }
    }
}

