/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel.security;

import com.arsdigita.kernel.security.AccountNotFoundException;
import com.arsdigita.kernel.security.PartyPrincipal;
import java.math.BigDecimal;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.log4j.Logger;

public abstract class MappingLoginModule
implements LoginModule {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/security/MappingLoginModule.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((String)(class$com$arsdigita$kernel$security$MappingLoginModule == null ? (class$com$arsdigita$kernel$security$MappingLoginModule = MappingLoginModule.class$("com.arsdigita.kernel.security.MappingLoginModule")) : class$com$arsdigita$kernel$security$MappingLoginModule).getName());
    private BigDecimal m_userID = null;
    private Subject m_subject;
    private CallbackHandler m_handler;
    private Map m_shared;
    private Map m_options;
    static /* synthetic */ Class class$com$arsdigita$kernel$security$MappingLoginModule;

    public void initialize(Subject subject, CallbackHandler handler, Map shared, Map options) {
        this.m_subject = subject;
        this.m_handler = handler;
        this.m_shared = shared;
        this.m_options = options;
    }

    public boolean login() throws LoginException {
        s_log.debug((Object)"START login");
        this.m_userID = this.getUserID(this.getUsername());
        s_log.debug((Object)"SUCCESS login");
        return true;
    }

    private String getUsername() throws FailedLoginException {
        String username = (String)this.m_shared.get("javax.security.auth.login.name");
        if (username == null) {
            s_log.debug((Object)"FAILURE no username available");
            throw new FailedLoginException("no username available");
        }
        return username;
    }

    protected abstract BigDecimal getUserID(String var1) throws AccountNotFoundException, LoginException;

    public boolean commit() throws LoginException {
        s_log.debug((Object)"START commit");
        if (this.m_userID != null) {
            this.m_subject.getPrincipals().add(new PartyPrincipal(this.m_userID));
            s_log.debug((Object)"SUCCESS added new principal");
        }
        s_log.debug((Object)"END commit");
        return true;
    }

    public boolean abort() throws LoginException {
        s_log.debug((Object)"abort");
        return true;
    }

    public boolean logout() throws LoginException {
        s_log.debug((Object)"logout");
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

