/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel.security;

import com.arsdigita.kernel.security.KernelLoginException;
import com.arsdigita.kernel.security.Store;
import com.arsdigita.util.UncheckedWrapperException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;

public class Crypto {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/security/Crypto.java#21 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$kernel$security$Crypto == null ? (class$com$arsdigita$kernel$security$Crypto = Crypto.class$("com.arsdigita.kernel.security.Crypto")) : class$com$arsdigita$kernel$security$Crypto));
    private static int PBE_SALT_BYTES = 8;
    private static int PBE_ITERATIONS = 1024;
    private static String PBE_ALGO = "PBEWithMD5AndDES";
    private static String RANDOM_ALGO = "SHA1PRNG";
    private static String HASH_ALGO = "MD5";
    private static String MAC_ALGO = "HmacMD5";
    private static SecureRandom s_random = null;
    private static String PREFERRED_MAC_ALGO = null;
    public static final String CHARACTER_ENCODING = "UTF-8";
    static /* synthetic */ Class class$com$arsdigita$kernel$security$Crypto;

    public static Mac newMac() throws GeneralSecurityException {
        return Crypto.newMac(Store.INSTANCE.loadSecret());
    }

    static Mac newMac(byte[] secret) throws GeneralSecurityException {
        if (secret == null) {
            throw new NullPointerException("secret");
        }
        Mac mac = null;
        if (PREFERRED_MAC_ALGO != null) {
            mac = Mac.getInstance(PREFERRED_MAC_ALGO);
            mac.init(new SecretKeySpec(secret, "RAW"));
            return mac;
        }
        try {
            mac = Mac.getInstance(MAC_ALGO);
            PREFERRED_MAC_ALGO = MAC_ALGO;
        }
        catch (NoSuchAlgorithmException ex) {
            PREFERRED_MAC_ALGO = Crypto.getMAC();
            s_log.info((Object)("Default " + MAC_ALGO + " not available, falling back to " + PREFERRED_MAC_ALGO));
        }
        if (mac == null) {
            try {
                mac = Mac.getInstance(PREFERRED_MAC_ALGO);
            }
            catch (NoSuchAlgorithmException ex) {
                String msg = "Couldn't find " + PREFERRED_MAC_ALGO + ". Make sure you have the right" + "provider(s) installed. Check $JAVA_HOME/jre/lib/java.security";
                s_log.error((Object)msg, (Throwable)ex);
                throw new KernelLoginException(msg, ex);
            }
        }
        s_log.info((Object)(mac.getAlgorithm() + " selected for MAC algorithm."));
        mac.init(new SecretKeySpec(secret, "RAW"));
        return mac;
    }

    public static MessageDigest newDigester() throws GeneralSecurityException {
        return MessageDigest.getInstance(HASH_ALGO);
    }

    public static SecureRandom getRandom() throws GeneralSecurityException {
        if (s_random == null) {
            try {
                s_random = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (NoSuchAlgorithmException e) {
                s_random = SecureRandom.getInstance(Crypto.getPRNG());
            }
        }
        return s_random;
    }

    private static SecretKey newKey(char[] password) throws GeneralSecurityException {
        return SecretKeyFactory.getInstance(PBE_ALGO).generateSecret(new PBEKeySpec(password));
    }

    private static AlgorithmParameterSpec newParams(byte[] salt) throws GeneralSecurityException {
        return new PBEParameterSpec(salt, PBE_ITERATIONS);
    }

    private static Cipher newCipher(int mode, char[] password, byte[] salt) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(PBE_ALGO);
        cipher.init(mode, (Key)Crypto.newKey(password), Crypto.newParams(salt));
        return cipher;
    }

    private static byte[] newSalt() throws GeneralSecurityException {
        byte[] salt = new byte[PBE_SALT_BYTES];
        Crypto.getRandom().nextBytes(salt);
        return salt;
    }

    public static String encrypt(String decrypted, char[] password) throws GeneralSecurityException {
        byte[] bytes;
        byte[] salt;
        decrypted = decrypted.length() + ":" + decrypted;
        try {
            salt = Crypto.newSalt();
            bytes = Crypto.newCipher(1, password, salt).doFinal(decrypted.getBytes(CHARACTER_ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            throw new UncheckedWrapperException(e);
        }
        Base64 encoder = new Base64();
        String encrypted = new String(encoder.encode(salt)) + ':' + new String(encoder.encode(bytes));
        return encrypted;
    }

    public static String decrypt(String encrypted, char[] password) throws GeneralSecurityException {
        int length;
        String decrypted;
        byte[] bytes;
        byte[] salt;
        int colon = encrypted.indexOf(58);
        if (colon < 0) {
            throw new IllegalArgumentException("Expected salt:ciphertext (no colon)");
        }
        Base64 decoder = new Base64();
        try {
            salt = decoder.decode(encrypted.substring(0, colon).getBytes(CHARACTER_ENCODING));
            bytes = decoder.decode(encrypted.substring(colon + 1).getBytes(CHARACTER_ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            throw new UncheckedWrapperException(e);
        }
        try {
            decrypted = new String(Crypto.newCipher(2, password, salt).doFinal(bytes), CHARACTER_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new UncheckedWrapperException(e);
        }
        colon = decrypted.indexOf(58);
        if (colon < 0) {
            throw new InvalidKeyException("Expected length:cleartext (no colon)");
        }
        try {
            length = Integer.parseInt(decrypted.substring(0, colon));
        }
        catch (NumberFormatException e) {
            throw new InvalidKeyException("Expected length:cleartext (number format)");
        }
        decrypted = decrypted.substring(colon + 1);
        if (length != decrypted.length()) {
            throw new InvalidKeyException("Expected length:cleartext (bad length)");
        }
        return decrypted;
    }

    public static void main(String[] args) throws GeneralSecurityException {
        String original = "this is the clear text";
        char[] password = "Password123".toCharArray();
        int samples = 10;
        for (int i = 1; i <= 8192; i *= 2) {
            long start;
            int j;
            PBE_ITERATIONS = i;
            String[] encrypted = new String[samples];
            String[] decrypted = new String[samples];
            long time = 0L;
            for (j = 0; j < samples; ++j) {
                start = System.currentTimeMillis();
                encrypted[j] = Crypto.encrypt(original + j, password);
                time += System.currentTimeMillis() - start;
            }
            s_log.warn((Object)("encrypt, " + PBE_ITERATIONS + " iters: " + time / (long)samples + " ms"));
            time = 0L;
            for (j = 0; j < samples; ++j) {
                start = System.currentTimeMillis();
                decrypted[j] = Crypto.decrypt(encrypted[j], password);
                time += System.currentTimeMillis() - start;
            }
            s_log.warn((Object)("decrypt, " + PBE_ITERATIONS + " iters: " + time / (long)samples + " ms"));
            for (j = 0; j < samples; ++j) {
                if (decrypted[j].equals(original + j)) continue;
                throw new IllegalStateException("bad decryption; original <" + original + j + ">, decrypted <" + decrypted[j] + ">");
            }
        }
    }

    private static String getPRNG() {
        String algorithm = null;
        Provider[] jceProviders = Security.getProviders();
        for (int i = 0; i < jceProviders.length; ++i) {
            Set<Map.Entry<Object, Object>> e = jceProviders[i].entrySet();
            Iterator<Map.Entry<Object, Object>> iterator = e.iterator();
            while (iterator.hasNext()) {
                String current = iterator.next().toString();
                if (!current.startsWith("SecureRandom") || (algorithm = current.substring(13, current.indexOf("="))).indexOf("ImplementedIn") != -1) continue;
                return algorithm;
            }
        }
        return algorithm;
    }

    private static String getMAC() {
        String algorithm = null;
        String mdAlgorithm = null;
        String preferredAlgorithm = null;
        Provider[] jceProviders = Security.getProviders();
        for (int i = 0; i < jceProviders.length; ++i) {
            Set<Map.Entry<Object, Object>> e = jceProviders[i].entrySet();
            Iterator<Map.Entry<Object, Object>> iterator = e.iterator();
            while (iterator.hasNext()) {
                String current = iterator.next().toString();
                if (current.startsWith("Mac") && (algorithm = current.substring(4, current.indexOf("="))).indexOf("ImplementedIn") == -1 && algorithm != null) {
                    return algorithm;
                }
                if (!current.startsWith("MessageDigest") || (mdAlgorithm = current.substring(14, current.indexOf("="))).indexOf("ImplementedIn") != -1 || mdAlgorithm == null) continue;
                preferredAlgorithm = mdAlgorithm;
            }
        }
        return preferredAlgorithm;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

