/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel.security;

import com.arsdigita.kernel.security.Credential;
import com.arsdigita.kernel.security.CredentialManager;
import com.arsdigita.kernel.security.HTTPResponseCallback;
import com.arsdigita.kernel.security.Initializer;
import com.arsdigita.kernel.security.KernelLoginException;
import com.arsdigita.kernel.security.LifetimeCallback;
import com.arsdigita.kernel.security.PartyPrincipal;
import com.arsdigita.kernel.security.Util;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public abstract class CredentialLoginModule
implements LoginModule {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/security/CredentialLoginModule.java#10 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((String)(class$com$arsdigita$kernel$security$CredentialLoginModule == null ? (class$com$arsdigita$kernel$security$CredentialLoginModule = CredentialLoginModule.class$("com.arsdigita.kernel.security.CredentialLoginModule")) : class$com$arsdigita$kernel$security$CredentialLoginModule).getName());
    public static final long RENEW_SECS = 300L;
    public static final long TIMEOUT_SECS = 1200L;
    public static final long LIFETIME_SECS = 172800L;
    public static final long FOREVER_SECS = 94608000L;
    private Subject m_subject;
    private CallbackHandler m_handler;
    private Map m_shared;
    private Map m_options;
    private HttpServletRequest m_req = null;
    private HttpServletResponse m_res = null;
    private Boolean m_forever = null;
    private Boolean m_secure = null;
    private Credential m_credential = null;
    private CredentialManager m_manager;
    static /* synthetic */ Class class$com$arsdigita$kernel$security$CredentialLoginModule;
    static /* synthetic */ Class class$com$arsdigita$kernel$security$PartyPrincipal;

    public CredentialLoginModule(CredentialManager manager) {
        this.m_manager = manager;
    }

    public void initialize(Subject subject, CallbackHandler handler, Map shared, Map options) {
        this.m_manager.initialize(this, subject, handler, shared, options);
        this.m_subject = subject;
        this.m_handler = handler;
        this.m_shared = shared;
        this.m_options = options;
    }

    public boolean login() throws LoginException {
        s_log.debug((Object)"START login");
        this.loadCredential();
        s_log.debug((Object)"END login");
        return true;
    }

    public boolean logout() throws LoginException {
        s_log.debug((Object)"START logout");
        this.invalidateSession();
        this.deleteCredential();
        s_log.debug((Object)"END logout");
        return true;
    }

    public boolean abort() throws LoginException {
        s_log.debug((Object)"START abort");
        this.deleteCredential();
        s_log.debug((Object)"END abort");
        return true;
    }

    public boolean commit() throws LoginException {
        s_log.debug((Object)"START commit");
        try {
            BigDecimal id = this.getID();
            String value = id.toString();
            if (this.shouldInvalidateSession(value)) {
                this.invalidateSession();
            }
            if (this.m_manager.shouldSetValue(value)) {
                this.setCredential(value);
            }
            s_log.debug((Object)"SUCCESS commit");
        }
        catch (FailedLoginException e) {
            s_log.debug((Object)"FAILURE commit (ignored)", (Throwable)e);
        }
        return true;
    }

    private BigDecimal getID() throws FailedLoginException {
        s_log.debug((Object)"START getID");
        try {
            BigDecimal id = this.loadID();
            s_log.debug((Object)"SUCCESS getID from subject");
            return id;
        }
        catch (NoSuchElementException e) {
            if (!this.credentialIsSet()) {
                s_log.debug((Object)"FAILURE getID not available", (Throwable)e);
                throw new FailedLoginException("No ID available");
            }
            try {
                String value = this.m_credential.getValue();
                BigDecimal id = new BigDecimal(value);
                s_log.debug((Object)"SUCCESS getID from credential");
                this.saveID(id);
                return id;
            }
            catch (NumberFormatException nfe) {
                s_log.debug((Object)"FAILURE getID number format", (Throwable)nfe);
                throw new FailedLoginException("No ID available");
            }
        }
    }

    protected final BigDecimal loadID() throws NoSuchElementException {
        Set set = this.m_subject.getPrincipals(class$com$arsdigita$kernel$security$PartyPrincipal == null ? (class$com$arsdigita$kernel$security$PartyPrincipal = CredentialLoginModule.class$("com.arsdigita.kernel.security.PartyPrincipal")) : class$com$arsdigita$kernel$security$PartyPrincipal);
        return ((PartyPrincipal)set.iterator().next()).getID();
    }

    protected final void saveID(BigDecimal id) {
        this.m_subject.getPrincipals().add(new PartyPrincipal(id));
    }

    protected final boolean isSecure() throws LoginException {
        if (this.m_secure == null) {
            this.m_secure = new Boolean(Util.getSecurityHelper().isSecure(this.getRequest()));
        }
        return this.m_secure;
    }

    protected abstract String getCredentialName() throws LoginException;

    protected abstract long getLifetime() throws LoginException;

    private void loadCredential() throws LoginException {
        s_log.debug((Object)"START loadCredential");
        String value = this.m_manager.getValue();
        this.m_credential = Credential.parse(value);
        s_log.debug((Object)("SUCCESS loadCredential: expires: " + this.m_credential.getExpiration()));
    }

    protected abstract boolean shouldInvalidateSession(String var1) throws LoginException;

    private void invalidateSession() throws LoginException {
        s_log.debug((Object)("invalidateSession: before: " + this.getRequest().getSession().getId()));
        this.getRequest().getSession().invalidate();
        this.getRequest().getSession();
        s_log.debug((Object)("invalidateSession: after: " + this.getRequest().getSession().getId()));
    }

    private void setCredential(String value) throws LoginException {
        s_log.debug((Object)("START setCredential to " + value));
        this.m_credential = Credential.create(value, this.getLifetime());
        this.m_manager.setValue(this.m_credential.toString());
        s_log.debug((Object)("SUCCESS setCredential: expires: " + this.m_credential.getExpiration()));
    }

    protected final boolean credentialIsSet() {
        return this.m_credential != null;
    }

    protected final boolean credentialHasValue(String value) {
        return this.m_credential.getValue().equals(value);
    }

    protected final boolean credentialIsOld() {
        long currentTime;
        long expireTime = this.m_credential.getExpiration().getTime() / 1000L;
        long issueTime = expireTime - 1200L;
        long renewTime = issueTime + 300L;
        return renewTime < (currentTime = System.currentTimeMillis() / 1000L);
    }

    protected final boolean requestIsExcluded() throws LoginException {
        Iterator exts = Initializer.getExcludedExtensions();
        while (exts.hasNext()) {
            String ext = (String)exts.next();
            if (!this.getRequest().getRequestURI().endsWith(ext)) continue;
            s_log.debug((Object)("got excluded extension: " + this.getRequest().getRequestURI()));
            return true;
        }
        return false;
    }

    private void deleteCredential() throws LoginException {
        this.m_manager.deleteValue();
        this.m_credential = null;
    }

    protected final HttpServletRequest getRequest() throws LoginException {
        if (this.m_req == null) {
            this.m_req = Util.getRequest(this.m_handler);
        }
        return this.m_req;
    }

    protected final HttpServletResponse getResponse() throws LoginException {
        try {
            if (this.m_res == null) {
                HTTPResponseCallback cb = new HTTPResponseCallback();
                this.m_handler.handle(new Callback[]{cb});
                this.m_res = cb.getResponse();
            }
            return this.m_res;
        }
        catch (IOException e) {
            throw new KernelLoginException("Could not get HTTP response", e);
        }
        catch (UnsupportedCallbackException e) {
            throw new KernelLoginException("Could not get HTTP response", e);
        }
    }

    protected final boolean getForever() throws LoginException {
        try {
            if (this.m_forever == null) {
                LifetimeCallback cb = new LifetimeCallback();
                this.m_handler.handle(new Callback[]{cb});
                this.m_forever = new Boolean(cb.isForever());
            }
            return this.m_forever;
        }
        catch (IOException e) {
            throw new KernelLoginException("Could not get lifetime", e);
        }
        catch (UnsupportedCallbackException e) {
            throw new KernelLoginException("Could not get lifetime", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

