/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel;

import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.db.Sequences;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.ResourceTypeCollection;
import com.arsdigita.kernel.ResourceTypeConfig;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.kernel.ui.ResourceConfigComponent;
import com.arsdigita.kernel.ui.ResourceConfigFormSection;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;

public class ResourceType
extends DomainObject {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/ResourceType.java#10 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$kernel$ResourceType == null ? (class$com$arsdigita$kernel$ResourceType = ResourceType.class$("com.arsdigita.kernel.ResourceType")) : class$com$arsdigita$kernel$ResourceType));
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.kernel.ResourceType";
    protected static ResourceTypeConfig s_defaultConfig = new ResourceTypeConfig();
    static final Map s_configMap = Collections.synchronizedMap(new HashMap());
    static /* synthetic */ Class class$com$arsdigita$kernel$ResourceType;

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    protected ResourceType(DataObject dataObject) {
        super(dataObject);
    }

    protected ResourceType(String dataObjectType) {
        super(dataObjectType);
        this.setID(this.generateID());
    }

    protected ResourceType(String dataObjectType, String title, String resourceObjectType) {
        this(dataObjectType);
        Assert.assertNotNull(title, "title");
        Assert.assertNotNull(resourceObjectType, "resourceObjectType");
        this.setTitle(title);
        this.setResourceObjectType(resourceObjectType);
    }

    public static ResourceType createResourceType(String title, String resourceObjectType) {
        return new ResourceType(BASE_DATA_OBJECT_TYPE, title, resourceObjectType);
    }

    public static ResourceType retrieveResourceType(BigDecimal id) {
        Assert.assertNotNull(id, "id");
        return ResourceType.retrieveResourceType(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public static ResourceType retrieveResourceType(OID oid) {
        Assert.assertNotNull(oid, "oid");
        DataObject dataObject = SessionManager.getSession().retrieve(oid);
        Assert.assertNotNull(dataObject);
        return ResourceType.retrieveResourceType(dataObject);
    }

    public static ResourceType retrieveResourceType(DataObject dataObject) {
        Assert.assertNotNull(dataObject, "dataObject");
        return new ResourceType(dataObject);
    }

    public static ResourceType retrieveResourceTypeForResource(String resourceObjectType) {
        Assert.assertNotNull(resourceObjectType, "resourceObjectType");
        DataCollection collection = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        collection.addEqualsFilter("objectType", resourceObjectType);
        ResourceType resourceType = null;
        if (collection.next()) {
            resourceType = ResourceType.retrieveResourceType(collection.getDataObject());
        }
        collection.close();
        return resourceType;
    }

    public static ResourceTypeCollection retrieveAllResourceTypes() {
        DataCollection collection = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        Assert.assertNotNull(collection, "collection");
        return new ResourceTypeCollection(collection);
    }

    public String getTitle() {
        String title = (String)this.get("title");
        Assert.assertNotNull(title, "title");
        return title;
    }

    public void setTitle(String title) {
        Assert.assertNotNull(title, "title");
        this.set("title", title);
    }

    public String getDescription() {
        String description = (String)this.get("description");
        return description;
    }

    public void setDescription(String description) {
        this.set("description", description);
    }

    public Collection getRelevantPrivileges() {
        LinkedList<PrivilegeDescriptor> result = new LinkedList<PrivilegeDescriptor>();
        DataAssociationCursor dac = ((DataAssociation)this.get("relevantPrivileges")).cursor();
        while (dac.next()) {
            PrivilegeDescriptor priv = PrivilegeDescriptor.get((String)dac.get("privilege"));
            result.add(priv);
        }
        return result;
    }

    public void addRelevantPrivilege(PrivilegeDescriptor privilege) {
        this.addRelevantPrivilege(privilege.getName());
    }

    public void addRelevantPrivilege(String privilegeName) {
        OID privOID = new OID("com.arsdigita.kernel.permissions.Privilege", (Object)privilegeName);
        DataObject privDO = SessionManager.getSession().retrieve(privOID);
        this.add("relevantPrivileges", privDO);
    }

    public void removeRelevantPrivilege(PrivilegeDescriptor privilege) {
        this.removeRelevantPrivilege(privilege.getName());
    }

    public void removeRelevantPrivilege(String privilegeName) {
        OID privOID = new OID("com.arsdigita.kernel.permissions.Privilege", (Object)privilegeName);
        DataObject privDO = SessionManager.getSession().retrieve(privOID);
        this.remove("relevantPrivileges", privDO);
    }

    public String getResourceObjectType() {
        String objectType = (String)this.get("objectType");
        Assert.assertNotNull(objectType);
        return objectType;
    }

    protected void setResourceObjectType(String objectType) {
        Assert.assertNotNull(objectType);
        this.set("objectType", objectType);
    }

    public BigDecimal getID() {
        BigDecimal id = (BigDecimal)this.get("id");
        Assert.assertNotNull(id, "id");
        return id;
    }

    private BigDecimal setID(BigDecimal id) {
        Assert.assertNotNull(id, "id");
        if (this.isNew() && this.get("id") == null) {
            this.set("id", id);
            return id;
        }
        return this.getID();
    }

    public static boolean isInstalled(String resourceObjectType) {
        return ResourceType.retrieveResourceTypeForResource(resourceObjectType) != null;
    }

    private BigDecimal generateID() throws PersistenceException {
        try {
            return Sequences.getNextValue();
        }
        catch (SQLException e) {
            String errorMsg = "Unable to generate a unique id.";
            s_log.error((Object)"Unable to generate a unique id.");
            throw new PersistenceException("Unable to generate a unique id.");
        }
    }

    public static final void registerResourceTypeConfig(String resourceObjectType, ResourceTypeConfig config) {
        s_configMap.put(resourceObjectType, config);
    }

    public static final Iterator getConfigs() {
        return s_configMap.entrySet().iterator();
    }

    public final ResourceTypeConfig getConfig() {
        String objectType = this.getResourceObjectType();
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Using object type '" + objectType + "' to " + "lookup config for resource type " + this.getTitle()));
            s_log.debug((Object)s_configMap);
        }
        ResourceTypeConfig config = (ResourceTypeConfig)s_configMap.get(objectType);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Found config " + config));
        }
        return config;
    }

    public final boolean hasConfig() {
        return this.getConfig() != null;
    }

    public final ResourceConfigFormSection getCreateFormSection(RequestLocal parentResource) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Getting the application config form section for resource type " + this));
        }
        if (this.getConfig() == null) {
            s_log.debug((Object)"No config was registered for this resource type; using the default");
            return s_defaultConfig.getCreateFormSection(this, parentResource);
        }
        s_log.debug((Object)"Found a config");
        return this.getConfig().getCreateFormSection(this, parentResource);
    }

    public final ResourceConfigFormSection getModifyFormSection(RequestLocal resource) {
        if (this.getConfig() == null) {
            return s_defaultConfig.getModifyFormSection(resource);
        }
        return this.getConfig().getModifyFormSection(resource);
    }

    public final ResourceConfigComponent getCreateComponent(RequestLocal parentResource) {
        if (this.getConfig() == null) {
            return s_defaultConfig.getCreateComponent(this, parentResource);
        }
        return this.getConfig().getCreateComponent(this, parentResource);
    }

    public ResourceConfigComponent getModifyComponent(RequestLocal resource) {
        if (this.getConfig() == null) {
            return s_defaultConfig.getModifyComponent(resource);
        }
        return this.getConfig().getModifyComponent(resource);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

