/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel;

import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import org.apache.log4j.Logger;

public final class DatabaseTransaction {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/DatabaseTransaction.java#7 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$kernel$DatabaseTransaction == null ? (class$com$arsdigita$kernel$DatabaseTransaction = DatabaseTransaction.class$("com.arsdigita.kernel.DatabaseTransaction")) : class$com$arsdigita$kernel$DatabaseTransaction));
    private final TransactionContext m_context = SessionManager.getSession().getTransactionContext();
    private boolean m_isCommitRequested = true;
    static /* synthetic */ Class class$com$arsdigita$kernel$DatabaseTransaction;

    public final void begin() {
        if (!this.m_context.inTxn()) {
            s_log.debug((Object)"Beginning transaction");
            this.m_context.beginTxn();
        } else {
            s_log.debug((Object)"Tried to begin, but the transaction was already begun");
        }
    }

    public final void end() {
        if (this.isCommitRequested()) {
            this.commit();
        } else {
            this.abort();
        }
    }

    public final void commit() {
        if (this.m_context.inTxn()) {
            s_log.debug((Object)"Committing transaction");
            this.m_context.commitTxn();
        } else {
            s_log.debug((Object)"Tried to commit, but the transaction was already finished");
        }
    }

    public final void abort() {
        if (this.m_context.inTxn()) {
            s_log.debug((Object)"Aborting transaction");
            this.m_context.abortTxn();
        } else {
            s_log.debug((Object)"Tried to abort, but the transaction was already finished");
        }
    }

    public final boolean isCommitRequested() {
        return this.m_isCommitRequested;
    }

    public final void setCommitRequested(boolean isCommitRequested) {
        this.m_isCommitRequested = isCommitRequested;
    }

    public String toString() {
        return super.toString() + " " + "[" + this.m_context.inTxn() + "," + this.isCommitRequested() + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

