/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.initializer;

import com.arsdigita.initializer.Configuration;
import com.arsdigita.initializer.Initializer;
import com.arsdigita.logging.ErrorReport;
import java.util.ArrayList;
import java.util.Iterator;

public class InitializerErrorReport
extends ErrorReport {
    private Initializer m_initializer;

    public InitializerErrorReport(Throwable throwable, Initializer initializer) {
        super(throwable);
        this.m_initializer = initializer;
        try {
            this.addInitializer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.addConfig();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addInitializer() {
        if (this.m_initializer == null) {
            return;
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("Classname: " + this.m_initializer.getClass().getName());
        this.addSection("Initializer summary", lines);
    }

    private void addConfig() {
        if (this.m_initializer == null) {
            return;
        }
        ArrayList<String> lines = new ArrayList<String>();
        Configuration config = this.m_initializer.getConfiguration();
        Iterator params = config.getParameterNames().iterator();
        while (params.hasNext()) {
            String name = (String)params.next();
            Object value = config.getParameter(name);
            lines.add(name + ": " + value);
        }
        this.addSection("Initializer parameters", lines);
    }
}

